/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BufferedInputStream;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.LinkedList;
import HTTPClient.Log;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import HTTPClient.SocketTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private BufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private static Object cleanup;
    private LinkedList RespHandlerList;
    private long chunk_len;
    private int cur_timeout = 0;

    StreamDemultiplexor(int n, Socket socket, HTTPConnection hTTPConnection) throws IOException {
        this.Protocol = n;
        this.Connection = hTTPConnection;
        this.RespHandlerList = new LinkedList();
        this.init(socket);
    }

    private void init(Socket socket) throws IOException {
        Log.write(4, "Demux: Initializing Stream Demultiplexor (" + this.hashCode() + ")");
        this.Sock = socket;
        this.Stream = new BufferedInputStream(socket.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1L;
        this.Timer = TimerThread.setTimeout(this);
        this.Timer.hyber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Response response, Request request) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(response, request, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RespInputStream getStream(Response response) {
        ResponseHandler responseHandler;
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null && responseHandler.resp != response) {
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
        if (responseHandler != null) {
            return responseHandler.stream;
        }
        return null;
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    int read(byte[] byArray, int n, int n2, ResponseHandler responseHandler, int n3) throws IOException {
        ResponseHandler responseHandler2;
        if (responseHandler.exception != null) {
            responseHandler.exception.fillInStackTrace();
            throw responseHandler.exception;
        }
        if (responseHandler.eof) {
            return -1;
        }
        while ((responseHandler2 = (ResponseHandler)this.RespHandlerList.getFirst()) != null && responseHandler2 != responseHandler) {
            try {
                responseHandler2.stream.readAll(n3);
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    throw iOException;
                }
                responseHandler.exception.fillInStackTrace();
                throw responseHandler.exception;
            }
        }
        StreamDemultiplexor streamDemultiplexor = this;
        synchronized (streamDemultiplexor) {
            if (responseHandler.exception != null) {
                responseHandler.exception.fillInStackTrace();
                throw responseHandler.exception;
            }
            if (responseHandler.resp.cd_type != 1) {
                Log.write(4, "Demux: Reading for stream " + responseHandler.stream.hashCode());
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                int n4 = -1;
                if (n3 != this.cur_timeout) {
                    Log.write(4, "Demux: Setting timeout to " + n3 + " ms");
                    this.Sock.setSoTimeout(n3);
                    this.cur_timeout = n3;
                }
                switch (responseHandler.resp.cd_type) {
                    case 1: {
                        n4 = this.Stream.read(byArray, n, n2);
                        if (n4 != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        n4 = -1;
                        this.close(responseHandler);
                        break;
                    }
                    case 3: {
                        n4 = this.Stream.read(byArray, n, n2);
                        if (n4 != -1) break;
                        this.close(responseHandler);
                        break;
                    }
                    case 4: {
                        int n5 = responseHandler.resp.ContentLength;
                        if (n2 > n5 - responseHandler.stream.count) {
                            n2 = n5 - responseHandler.stream.count;
                        }
                        if ((n4 = this.Stream.read(byArray, n, n2)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (responseHandler.stream.count + n4 != n5) break;
                        this.close(responseHandler);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1L) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0L) {
                            if ((long)n2 > this.chunk_len) {
                                n2 = (int)this.chunk_len;
                            }
                            if ((n4 = this.Stream.read(byArray, n, n2)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= (long)n4;
                            if (this.chunk_len != 0L) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1L;
                            break;
                        }
                        responseHandler.resp.readTrailers(this.Stream);
                        n4 = -1;
                        this.close(responseHandler);
                        this.chunk_len = -1L;
                        break;
                    }
                    case 6: {
                        byte[] byArray2 = responseHandler.getEndBoundary(this.Stream);
                        int[] nArray = responseHandler.getEndCompiled(this.Stream);
                        n4 = this.Stream.read(byArray, n, n2);
                        if (n4 == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        int n6 = this.Stream.pastEnd(byArray2, nArray);
                        if (n6 == -1) break;
                        n4 -= n6;
                        this.close(responseHandler);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + responseHandler.resp.cd_type);
                    }
                }
                this.restartTimer();
                return n4;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.restartTimer();
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                Log.write(4, "Demux: ", iOException);
                this.close(iOException, true);
                throw responseHandler.exception;
            }
            catch (ParseException parseException) {
                Log.write(4, "Demux: ", parseException);
                this.close(new IOException(parseException.toString()), true);
                throw responseHandler.exception;
            }
        }
    }

    synchronized long skip(long l, ResponseHandler responseHandler) throws IOException {
        if (responseHandler.exception != null) {
            responseHandler.exception.fillInStackTrace();
            throw responseHandler.exception;
        }
        if (responseHandler.eof) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l];
        int n = this.read(byArray, 0, (int)l, responseHandler, 0);
        if (n == -1) {
            return 0L;
        }
        return n;
    }

    synchronized int available(ResponseHandler responseHandler) throws IOException {
        if (responseHandler != null && responseHandler.exception != null) {
            responseHandler.exception.fillInStackTrace();
            throw responseHandler.exception;
        }
        if (responseHandler != null && responseHandler.eof) {
            return 0;
        }
        int n = this.Stream.available();
        if (responseHandler == null) {
            return n;
        }
        switch (responseHandler.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return n > 0 ? 1 : 0;
            }
            case 3: {
                return n;
            }
            case 4: {
                int n2 = responseHandler.resp.ContentLength;
                return n < (n2 -= responseHandler.stream.count) ? n : n2;
            }
            case 5: {
                return n;
            }
            case 6: {
                return n;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + responseHandler.resp.cd_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(IOException iOException, boolean bl) {
        if (this.Sock == null) {
            return;
        }
        Log.write(4, "Demux: Closing all streams and socket (" + this.hashCode() + ")");
        try {
            this.Stream.close();
        }
        catch (IOException iOException2) {
            // empty catch block
        }
        try {
            this.Sock.close();
        }
        catch (IOException iOException3) {
            // empty catch block
        }
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (iOException != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(iOException, bl);
            }
        }
    }

    private void retry_requests(IOException iOException, boolean bl) {
        RetryException retryException = null;
        RetryException retryException2 = null;
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp.got_headers) {
                responseHandler.exception = iOException;
            } else {
                RetryException retryException3 = new RetryException(iOException.getMessage());
                if (retryException == null) {
                    retryException = retryException3;
                }
                retryException3.request = responseHandler.request;
                retryException3.response = responseHandler.resp;
                retryException3.exception = iOException;
                retryException3.conn_reset = bl;
                retryException3.first = retryException;
                retryException3.addToListAfter(retryException2);
                retryException2 = retryException3;
                responseHandler.exception = retryException3;
            }
            this.RespHandlerList.remove(responseHandler);
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ResponseHandler responseHandler) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (responseHandler != (ResponseHandler)this.RespHandlerList.getFirst()) {
                return;
            }
            Log.write(4, "Demux: Closing stream " + responseHandler.stream.hashCode());
            responseHandler.eof = true;
            this.RespHandlerList.remove(responseHandler);
        }
        if (responseHandler == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null && responseHandler.stream.closed) {
                if (responseHandler == this.MarkedForClose) {
                    ResponseHandler responseHandler2;
                    do {
                        responseHandler2 = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(responseHandler2);
                    } while (responseHandler2 != responseHandler);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    return;
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void markForClose(Response response) {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                return;
            }
            if (this.Timer != null) {
                this.Timer.kill();
                this.Timer = null;
            }
            ResponseHandler responseHandler = null;
            ResponseHandler responseHandler2 = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler2 != null) {
                if (responseHandler2.resp == response) {
                    this.MarkedForClose = responseHandler2;
                    Log.write(4, "Demux: stream " + response.inp_stream.hashCode() + " marked for close");
                    this.closeSocketIfAllStreamsClosed();
                    return;
                }
                if (this.MarkedForClose == responseHandler2) {
                    return;
                }
                responseHandler = responseHandler2;
                responseHandler2 = (ResponseHandler)this.RespHandlerList.next();
            }
            if (responseHandler == null) {
                return;
            }
            this.MarkedForClose = responseHandler;
            this.closeSocketIfAllStreamsClosed();
            Log.write(4, "Demux: stream " + responseHandler.stream.hashCode() + " marked for close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Log.write(4, "Demux: Aborting socket (" + this.hashCode() + ")");
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null) {
                if (responseHandler.resp.http_resp != null) {
                    responseHandler.resp.http_resp.markAborted();
                }
                if (responseHandler.exception == null) {
                    responseHandler.exception = new IOException("Request aborted by user");
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    try {
                        this.Stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.Sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    public String toString() {
        String string;
        switch (this.Protocol) {
            case 0: {
                string = "HTTP";
                break;
            }
            case 1: {
                string = "HTTPS";
                break;
            }
            case 2: {
                string = "SHTTP";
                break;
            }
            case 3: {
                string = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return this.getClass().getName() + "[Protocol=" + string + "]";
    }

    static /* synthetic */ SocketTimeout access$000() {
        return TimerThread;
    }

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
        cleanup = new Object(){
            private final SocketTimeout timer = StreamDemultiplexor.access$000();

            protected void finalize() {
                this.timer.kill();
            }
        };
    }
}

