/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.Codecs;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.MD5;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AuthorizationInfo
implements Cloneable {
    private static Hashtable CntxtList = new Hashtable();
    private static AuthorizationHandler AuthHandler = new DefaultAuthHandler();
    private String host;
    private int port;
    private String scheme;
    private String realm;
    private String cookie;
    private NVPair[] auth_params = new NVPair[0];
    private Object extra_info = null;
    private String[] paths = new String[0];

    AuthorizationInfo(String string, int n) {
        this.host = string.trim().toLowerCase();
        this.port = n;
    }

    public AuthorizationInfo(String string, int n, String string2, String string3, NVPair[] nVPairArray, Object object) {
        this.scheme = string2.trim();
        this.host = string.trim().toLowerCase();
        this.port = n;
        this.realm = string3;
        this.cookie = null;
        if (nVPairArray != null) {
            this.auth_params = Util.resizeArray(nVPairArray, nVPairArray.length);
        }
        this.extra_info = object;
    }

    public AuthorizationInfo(String string, int n, String string2, String string3, String string4) {
        this.scheme = string2.trim();
        this.host = string.trim().toLowerCase();
        this.port = n;
        this.realm = string3;
        this.cookie = string4 != null ? string4.trim() : null;
    }

    AuthorizationInfo(AuthorizationInfo authorizationInfo) {
        this.scheme = authorizationInfo.scheme;
        this.host = authorizationInfo.host;
        this.port = authorizationInfo.port;
        this.realm = authorizationInfo.realm;
        this.cookie = authorizationInfo.cookie;
        this.auth_params = Util.resizeArray(authorizationInfo.auth_params, authorizationInfo.auth_params.length);
        this.extra_info = authorizationInfo.extra_info;
    }

    public static AuthorizationHandler setAuthHandler(AuthorizationHandler authorizationHandler) {
        AuthorizationHandler authorizationHandler2 = AuthHandler;
        AuthHandler = authorizationHandler;
        return authorizationHandler2;
    }

    public static AuthorizationHandler getAuthHandler() {
        return AuthHandler;
    }

    public static AuthorizationInfo getAuthorization(String string, int n, String string2, String string3) {
        return AuthorizationInfo.getAuthorization(string, n, string2, string3, HTTPConnection.getDefaultContext());
    }

    public static synchronized AuthorizationInfo getAuthorization(String string, int n, String string2, String string3, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(string, n, string2, string3, null, null);
        return (AuthorizationInfo)hashtable.get(authorizationInfo);
    }

    static AuthorizationInfo queryAuthHandler(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException, IOException {
        if (AuthHandler == null) {
            return null;
        }
        AuthorizationInfo authorizationInfo2 = AuthHandler.getAuthorization(authorizationInfo, roRequest, roResponse);
        if (authorizationInfo2 != null) {
            if (roRequest != null) {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)authorizationInfo2.clone(), roRequest.getConnection().getContext());
            } else {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)authorizationInfo2.clone(), HTTPConnection.getDefaultContext());
            }
        }
        return authorizationInfo2;
    }

    static synchronized AuthorizationInfo getAuthorization(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse, boolean bl) throws AuthSchemeNotImplException, IOException {
        Hashtable hashtable = roRequest != null ? Util.getList(CntxtList, roRequest.getConnection().getContext()) : Util.getList(CntxtList, HTTPConnection.getDefaultContext());
        AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)hashtable.get(authorizationInfo);
        if (authorizationInfo2 == null && bl) {
            authorizationInfo2 = AuthorizationInfo.queryAuthHandler(authorizationInfo, roRequest, roResponse);
        }
        return authorizationInfo2;
    }

    static AuthorizationInfo getAuthorization(String string, int n, String string2, String string3, RoRequest roRequest, RoResponse roResponse, boolean bl) throws AuthSchemeNotImplException, IOException {
        return AuthorizationInfo.getAuthorization(new AuthorizationInfo(string, n, string2, string3, null, null), roRequest, roResponse, bl);
    }

    public static void addAuthorization(AuthorizationInfo authorizationInfo) {
        AuthorizationInfo.addAuthorization(authorizationInfo, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(AuthorizationInfo authorizationInfo, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)hashtable.get(authorizationInfo);
        if (authorizationInfo2 != null) {
            int n = authorizationInfo2.paths.length;
            int n2 = authorizationInfo.paths.length;
            if (n2 == 0) {
                authorizationInfo.paths = authorizationInfo2.paths;
            } else {
                authorizationInfo.paths = Util.resizeArray(authorizationInfo.paths, n2 + n);
                System.arraycopy(authorizationInfo2.paths, 0, authorizationInfo.paths, n2, n);
            }
        }
        hashtable.put(authorizationInfo, authorizationInfo);
    }

    public static void addAuthorization(String string, int n, String string2, String string3, String string4, NVPair[] nVPairArray, Object object) {
        AuthorizationInfo.addAuthorization(string, n, string2, string3, string4, nVPairArray, object, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(String string, int n, String string2, String string3, String string4, NVPair[] nVPairArray, Object object, Object object2) {
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(string, n, string2, string3, string4);
        if (nVPairArray != null && nVPairArray.length > 0) {
            authorizationInfo.auth_params = Util.resizeArray(nVPairArray, nVPairArray.length);
        }
        authorizationInfo.extra_info = object;
        AuthorizationInfo.addAuthorization(authorizationInfo, object2);
    }

    public static void addBasicAuthorization(String string, int n, String string2, String string3, String string4) {
        AuthorizationInfo.addAuthorization(string, n, "Basic", string2, Codecs.base64Encode(string3 + ":" + string4), null, null);
    }

    public static void addBasicAuthorization(String string, int n, String string2, String string3, String string4, Object object) {
        AuthorizationInfo.addAuthorization(string, n, "Basic", string2, Codecs.base64Encode(string3 + ":" + string4), null, null, object);
    }

    public static void addDigestAuthorization(String string, int n, String string2, String string3, String string4) {
        AuthorizationInfo.addDigestAuthorization(string, n, string2, string3, string4, HTTPConnection.getDefaultContext());
    }

    public static void addDigestAuthorization(String string, int n, String string2, String string3, String string4, Object object) {
        NVPair[] nVPairArray;
        AuthorizationInfo authorizationInfo = AuthorizationInfo.getAuthorization(string, n, "Digest", string2, object);
        if (authorizationInfo == null) {
            nVPairArray = new NVPair[]{new NVPair("username", string3), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            nVPairArray = authorizationInfo.getParams();
            for (int i = 0; i < nVPairArray.length; ++i) {
                if (!nVPairArray[i].getName().equalsIgnoreCase("username")) continue;
                nVPairArray[i] = new NVPair("username", string3);
                break;
            }
        }
        String[] stringArray = new String[]{MD5.hexDigest(string3 + ":" + string2 + ":" + string4), null, null};
        AuthorizationInfo.addAuthorization(string, n, "Digest", string2, null, nVPairArray, stringArray, object);
    }

    public static void removeAuthorization(AuthorizationInfo authorizationInfo) {
        AuthorizationInfo.removeAuthorization(authorizationInfo, HTTPConnection.getDefaultContext());
    }

    public static void removeAuthorization(AuthorizationInfo authorizationInfo, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        hashtable.remove(authorizationInfo);
    }

    public static void removeAuthorization(String string, int n, String string2, String string3) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(string, n, string2, string3, null, null));
    }

    public static void removeAuthorization(String string, int n, String string2, String string3, Object object) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(string, n, string2, string3, null, null), object);
    }

    static AuthorizationInfo findBest(RoRequest roRequest) {
        int n;
        String[] stringArray;
        AuthorizationInfo authorizationInfo;
        String string = Util.getPath(roRequest.getRequestURI());
        String string2 = roRequest.getConnection().getHost();
        int n2 = roRequest.getConnection().getPort();
        Hashtable hashtable = Util.getList(CntxtList, roRequest.getConnection().getContext());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            authorizationInfo = (AuthorizationInfo)enumeration.nextElement();
            if (!authorizationInfo.host.equals(string2) || authorizationInfo.port != n2) continue;
            stringArray = authorizationInfo.paths;
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.equals(stringArray[n])) continue;
                return authorizationInfo;
            }
        }
        authorizationInfo = null;
        stringArray = string.substring(0, string.lastIndexOf(47) + 1);
        n = Integer.MAX_VALUE;
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)enumeration.nextElement();
            if (!authorizationInfo2.host.equals(string2) || authorizationInfo2.port != n2) continue;
            String[] stringArray2 = authorizationInfo2.paths;
            for (int i = 0; i < stringArray2.length; ++i) {
                int n3;
                int n4;
                String string3 = stringArray2[i].substring(0, stringArray2[i].lastIndexOf(47) + 1);
                if (stringArray.equals(string3)) {
                    return authorizationInfo2;
                }
                if (stringArray.startsWith(string3)) {
                    n4 = 0;
                    n3 = string3.length() - 1;
                    while ((n3 = stringArray.indexOf(47, n3 + 1)) != -1) {
                        ++n4;
                    }
                    if (n4 >= n) continue;
                    n = n4;
                    authorizationInfo = authorizationInfo2;
                    continue;
                }
                if (!string3.startsWith((String)stringArray)) continue;
                n4 = 0;
                n3 = stringArray.length();
                while ((n3 = string3.indexOf(47, n3 + 1)) != -1) {
                    ++n4;
                }
                if (n4 >= n) continue;
                n = n4;
                authorizationInfo = authorizationInfo2;
            }
        }
        return authorizationInfo;
    }

    public synchronized void addPath(String string) {
        String string2 = Util.getPath(string);
        for (int i = 0; i < this.paths.length; ++i) {
            if (!this.paths[i].equals(string2)) continue;
            return;
        }
        this.paths = Util.resizeArray(this.paths, this.paths.length + 1);
        this.paths[this.paths.length - 1] = string2;
    }

    static AuthorizationInfo[] parseAuthString(String string, RoRequest roRequest, RoResponse roResponse) throws ProtocolException {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        int[] nArray = new int[2];
        AuthorizationInfo[] authorizationInfoArray = new AuthorizationInfo[]{};
        while (Character.isWhitespace(cArray[n3 - 1])) {
            --n3;
        }
        while ((n = Util.skipSpace(cArray, n)) != n3) {
            int n4;
            n2 = Util.findSpace(cArray, n + 1);
            try {
                n4 = roResponse.getStatusCode();
            }
            catch (IOException iOException) {
                throw new ProtocolException(iOException.toString());
            }
            AuthorizationInfo authorizationInfo = n4 == 401 ? new AuthorizationInfo(roRequest.getConnection().getHost(), roRequest.getConnection().getPort()) : new AuthorizationInfo(roRequest.getConnection().getProxyHost(), roRequest.getConnection().getProxyPort());
            if (cArray[n2 - 1] == ',') {
                authorizationInfo.scheme = string.substring(n, n2 - 1);
                n = n2;
            } else {
                authorizationInfo.scheme = string.substring(n, n2);
                nArray[0] = n;
                nArray[1] = n2;
                Vector vector = AuthorizationInfo.parseParams(string, cArray, nArray, n3, authorizationInfo);
                n = nArray[0];
                n2 = nArray[1];
                if (!vector.isEmpty()) {
                    authorizationInfo.auth_params = new NVPair[vector.size()];
                    vector.copyInto(authorizationInfo.auth_params);
                }
            }
            if (authorizationInfo.realm == null) {
                authorizationInfo.realm = "";
            }
            authorizationInfoArray = Util.resizeArray(authorizationInfoArray, authorizationInfoArray.length + 1);
            authorizationInfoArray[authorizationInfoArray.length - 1] = authorizationInfo;
        }
        return authorizationInfoArray;
    }

    private static final Vector parseParams(String string, char[] cArray, int[] nArray, int n, AuthorizationInfo authorizationInfo) throws ProtocolException {
        int n2 = nArray[0];
        int n3 = nArray[1];
        boolean bl = true;
        Vector<NVPair> vector = new Vector<NVPair>();
        while ((n2 = Util.skipSpace(cArray, n3)) != n) {
            String string2;
            if (!bl) {
                if (cArray[n2] != ',') {
                    throw new ProtocolException("Bad Authentication header format: '" + string + "'\nExpected \",\" at position " + n2);
                }
                if ((n2 = Util.skipSpace(cArray, n2 + 1)) == n) break;
                if (cArray[n2] == ',') {
                    n3 = n2;
                    continue;
                }
            }
            int n4 = n2;
            for (n3 = n2 + 1; n3 < n && !Character.isWhitespace(cArray[n3]) && cArray[n3] != '=' && cArray[n3] != ','; ++n3) {
            }
            if (bl && (n3 == n || cArray[n3] == '=' && (n3 + 1 == n || cArray[n3 + 1] == '=' && n3 + 2 == n))) {
                authorizationInfo.cookie = string.substring(n2, n);
                n2 = n;
                break;
            }
            String string3 = string.substring(n2, n3);
            n2 = Util.skipSpace(cArray, n3);
            if (n2 < n && cArray[n2] != '=' && cArray[n2] != ',' || !bl && (n2 == n || cArray[n2] == ',')) {
                n2 = n4;
                break;
            }
            if (n2 < n && cArray[n2] == '=') {
                if ((n2 = Util.skipSpace(cArray, n2 + 1)) == n) {
                    throw new ProtocolException("Bad Authentication header format: " + string + "\nUnexpected EOL after token" + " at position " + (n3 - 1));
                }
                if (cArray[n2] != '\"') {
                    n3 = Util.skipToken(cArray, n2);
                    if (n3 == n2) {
                        throw new ProtocolException("Bad Authentication header format: " + string + "\nToken expected at " + "position " + n2);
                    }
                    string2 = string.substring(n2, n3);
                } else {
                    n3 = n2++;
                    while ((n3 = string.indexOf(34, n3 + 1)) != -1 && string.charAt(n3 - 1) == '\\') {
                    }
                    if (n3 == -1) {
                        throw new ProtocolException("Bad Authentication header format: " + string + "\nClosing <\"> for " + "quoted-string starting at position " + n2 + " not found");
                    }
                    string2 = Util.dequoteString(string.substring(n2, n3));
                    ++n3;
                }
            } else {
                string2 = null;
            }
            if (string3.equalsIgnoreCase("realm")) {
                authorizationInfo.realm = string2;
            } else {
                vector.addElement(new NVPair(string3, string2));
            }
            bl = false;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return vector;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final String getRealm() {
        return this.realm;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final void setCookie(String string) {
        this.cookie = string;
    }

    public final NVPair[] getParams() {
        return Util.resizeArray(this.auth_params, this.auth_params.length);
    }

    public final void setParams(NVPair[] nVPairArray) {
        this.auth_params = nVPairArray != null ? Util.resizeArray(nVPairArray, nVPairArray.length) : new NVPair[0];
    }

    public final Object getExtraInfo() {
        return this.extra_info;
    }

    public final void setExtraInfo(Object object) {
        this.extra_info = object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.scheme);
        stringBuffer.append(" ");
        if (this.cookie != null) {
            stringBuffer.append(this.cookie);
        } else {
            if (this.realm.length() > 0) {
                stringBuffer.append("realm=\"");
                stringBuffer.append(Util.quoteString(this.realm, "\\\""));
                stringBuffer.append('\"');
            }
            for (int i = 0; i < this.auth_params.length; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(this.auth_params[i].getName());
                if (this.auth_params[i].getValue() == null) continue;
                stringBuffer.append("=\"");
                stringBuffer.append(Util.quoteString(this.auth_params[i].getValue(), "\\\""));
                stringBuffer.append('\"');
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (this.host + this.scheme.toLowerCase() + this.realm).hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AuthorizationInfo) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)object;
            if (this.host.equals(authorizationInfo.host) && this.port == authorizationInfo.port && this.scheme.equalsIgnoreCase(authorizationInfo.scheme) && this.realm.equals(authorizationInfo.realm)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        AuthorizationInfo authorizationInfo;
        try {
            authorizationInfo = (AuthorizationInfo)super.clone();
            authorizationInfo.auth_params = Util.resizeArray(this.auth_params, this.auth_params.length);
            try {
                authorizationInfo.extra_info = this.extra_info.getClass().getMethod("clone", null).invoke(this.extra_info, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            authorizationInfo.paths = new String[this.paths.length];
            System.arraycopy(this.paths, 0, authorizationInfo.paths, 0, this.paths.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        return authorizationInfo;
    }

    static {
        CntxtList.put(HTTPConnection.getDefaultContext(), new Hashtable());
    }
}

