/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.regexp.Regexp;

public class ReplaceRegExp
extends Task {
    private File file = null;
    private String flags = "";
    private boolean byline = false;
    private Vector filesets;
    private RegularExpression regex = null;
    private Substitution subs = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public ReplaceRegExp() {
        this.filesets = new Vector();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMatch(String match) {
        if (this.regex != null) {
            throw new BuildException("Only one regular expression is allowed");
        }
        this.regex = new RegularExpression();
        this.regex.setPattern(match);
    }

    public void setReplace(String replace) {
        if (this.subs != null) {
            throw new BuildException("Only one substitution expression is allowed");
        }
        this.subs = new Substitution();
        this.subs.setExpression(replace);
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public void setByLine(String byline) {
        Boolean res = Boolean.valueOf(byline);
        if (res == null) {
            res = Boolean.FALSE;
        }
        this.byline = res;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public RegularExpression createRegexp() {
        if (this.regex != null) {
            throw new BuildException("Only one regular expression is allowed.");
        }
        this.regex = new RegularExpression();
        return this.regex;
    }

    public Substitution createSubstitution() {
        if (this.subs != null) {
            throw new BuildException("Only one substitution expression is allowed");
        }
        this.subs = new Substitution();
        return this.subs;
    }

    protected String doReplace(RegularExpression r, Substitution s, String input, int options) {
        String res = input;
        Regexp regexp = r.getRegexp(this.getProject());
        if (regexp.matches(input, options)) {
            res = regexp.substitute(input, s.getExpression(this.getProject()), options);
        }
        return res;
    }

    protected void doReplace(File f, int options) throws IOException {
        File parentDir = this.fileUtils.getParentFile(f);
        File temp = this.fileUtils.createTempFile("replace", ".txt", parentDir);
        FileReader r = null;
        FileWriter w = null;
        try {
            r = new FileReader(f);
            w = new FileWriter(temp);
            BufferedReader br = new BufferedReader(r);
            BufferedWriter bw = new BufferedWriter(w);
            PrintWriter pw = new PrintWriter(bw);
            boolean changes = false;
            this.log("Replacing pattern '" + this.regex.getPattern(this.getProject()) + "' with '" + this.subs.getExpression(this.getProject()) + "' in '" + f.getPath() + "'" + (this.byline ? " by line" : "") + (this.flags.length() > 0 ? " with flags: '" + this.flags + "'" : "") + ".", 3);
            if (this.byline) {
                int c;
                StringBuffer linebuf = new StringBuffer();
                String line = null;
                String res = null;
                boolean hasCR = false;
                do {
                    if ((c = br.read()) == 13) {
                        if (hasCR) {
                            line = linebuf.toString();
                            res = this.doReplace(this.regex, this.subs, line, options);
                            if (!res.equals(line)) {
                                changes = true;
                            }
                            pw.print(res);
                            pw.print('\r');
                            linebuf.setLength(0);
                            continue;
                        }
                        hasCR = true;
                        continue;
                    }
                    if (c == 10) {
                        line = linebuf.toString();
                        res = this.doReplace(this.regex, this.subs, line, options);
                        if (!res.equals(line)) {
                            changes = true;
                        }
                        pw.print(res);
                        if (hasCR) {
                            pw.print('\r');
                            hasCR = false;
                        }
                        pw.print('\n');
                        linebuf.setLength(0);
                        continue;
                    }
                    if (hasCR || c < 0) {
                        line = linebuf.toString();
                        res = this.doReplace(this.regex, this.subs, line, options);
                        if (!res.equals(line)) {
                            changes = true;
                        }
                        pw.print(res);
                        if (hasCR) {
                            pw.print('\r');
                            hasCR = false;
                        }
                        linebuf.setLength(0);
                    }
                    if (c < 0) continue;
                    linebuf.append((char)c);
                } while (c >= 0);
                pw.flush();
            } else {
                int flen = (int)f.length();
                char[] tmpBuf = new char[flen];
                int numread = 0;
                int totread = 0;
                while (numread != -1 && totread < flen) {
                    numread = br.read(tmpBuf, totread, flen);
                    totread += numread;
                }
                String buf = new String(tmpBuf);
                String res = this.doReplace(this.regex, this.subs, buf, options);
                if (!res.equals(buf)) {
                    changes = true;
                }
                pw.print(res);
                pw.flush();
            }
            r.close();
            r = null;
            w.close();
            w = null;
            if (changes) {
                if (!f.delete()) {
                    throw new BuildException("Couldn't delete " + f, this.getLocation());
                }
                if (!temp.renameTo(f)) {
                    throw new BuildException("Couldn't rename temporary file " + temp, this.getLocation());
                }
                temp = null;
            }
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (temp != null) {
                temp.delete();
            }
            throw throwable;
        }
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (temp != null) {
            temp.delete();
        }
    }

    public void execute() throws BuildException {
        if (this.regex == null) {
            throw new BuildException("No expression to match.");
        }
        if (this.subs == null) {
            throw new BuildException("Nothing to replace expression with.");
        }
        if (this.file != null && this.filesets.size() > 0) {
            throw new BuildException("You cannot supply the 'file' attribute and filesets at the same time.");
        }
        int options = 0;
        if (this.flags.indexOf(103) != -1) {
            options |= 0x10;
        }
        if (this.flags.indexOf(105) != -1) {
            options |= 0x100;
        }
        if (this.flags.indexOf(109) != -1) {
            options |= 0x1000;
        }
        if (this.flags.indexOf(115) != -1) {
            options |= 0x10000;
        }
        if (this.file != null && this.file.exists()) {
            try {
                this.doReplace(this.file, options);
            }
            catch (IOException e) {
                this.log("An error occurred processing file: '" + this.file.getAbsolutePath() + "': " + e.toString(), 0);
            }
        } else if (this.file != null) {
            this.log("The following file is missing: '" + this.file.getAbsolutePath() + "'", 0);
        }
        int sz = this.filesets.size();
        int i = 0;
        while (i < sz) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                File f = new File(fs.getDir(this.getProject()), files[j]);
                if (f.exists()) {
                    try {
                        this.doReplace(f, options);
                    }
                    catch (Exception e) {
                        this.log("An error occurred processing file: '" + f.getAbsolutePath() + "': " + e.toString(), 0);
                    }
                } else {
                    this.log("The following file is missing: '" + f.getAbsolutePath() + "'", 0);
                }
                ++j;
            }
            ++i;
        }
    }
}

