/*
 * Decompiled with CFR 0.152.
 */
package madkit.docbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.docbrowser.BrowserGUI;
import madkit.docbrowser.DocLink;
import madkit.utils.graphics.GraphicUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class DocTree
extends JPanel
implements TreeSelectionListener {
    private File docFile;
    private Document documentation = null;
    private JTree sectionTree;
    private BrowserGUI browser;
    private Hashtable pluginsDoc;
    private DefaultMutableTreeNode top;
    private DefaultTreeModel treemodel;

    public DocTree(File file, BrowserGUI browserGUI) {
        this.browser = browserGUI;
        this.docFile = file;
        this.pluginsDoc = new Hashtable();
        this.setLayout(new BorderLayout());
        this.loadSections();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.sectionTree);
        this.add((Component)jScrollPane, "Center");
    }

    private void loadSections() {
        String string = "file:" + this.docFile.getParentFile().getParentFile().getPath() + "/docs/index.html";
        this.top = new DefaultMutableTreeNode(new DocLink("Madkit", "Madkit Documentation", string, "madkit"));
        this.treemodel = new DefaultTreeModel(this.top);
        try {
            if (this.documentation == null) {
                this.loadDoc();
            }
            this.createNodesBySections(this.top);
        }
        catch (SAXException sAXException) {
            DocTree.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            DocTree.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            DocTree.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            DocTree.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
        this.sectionTree = new JTree(this.treemodel);
        this.sectionTree.getSelectionModel().setSelectionMode(1);
        this.sectionTree.setShowsRootHandles(true);
        this.sectionTree.setRootVisible(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(this.getClass().getResource("/images/window/HtmlFile.gif")));
        this.sectionTree.setCellRenderer(defaultTreeCellRenderer);
        this.sectionTree.addTreeSelectionListener(this);
    }

    private static void debug(String string) {
        System.err.println("**debug** DocTree : " + string);
    }

    private void loadDoc() throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this.documentation = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.docFile);
    }

    private void createNodesBySections(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        String string = "file:" + this.docFile.getParentFile().getParentFile().getPath() + File.separatorChar;
        NodeList nodeList = this.documentation.getElementsByTagName("section");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(element.getAttribute("display"));
            NodeList nodeList2 = element.getElementsByTagName("docref");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                String string2 = Boolean.valueOf(element2.getAttribute("absolute")) != false ? element2.getAttribute("url") : string + element2.getAttribute("url");
                DocLink docLink = new DocLink(element.getAttribute("name"), element2.getAttribute("name"), string2, element2.getAttribute("plugin"));
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(docLink);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                this.addPluginLnk(docLink._plugin, docLink);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    DefaultMutableTreeNode findSection(String string) {
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((String)defaultMutableTreeNode.getUserObject()).equals(string)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    void addLink(String string, DocLink docLink) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findSection(docLink.getSection());
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(docLink.getSection());
            this.treemodel.insertNodeInto(defaultMutableTreeNode, this.top, this.treemodel.getChildCount(this.top));
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(docLink);
        this.treemodel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, this.treemodel.getChildCount(defaultMutableTreeNode));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addPluginLnk(string, docLink);
    }

    void addPluginLnk(String string, DocLink docLink) {
        Vector<DocLink> vector = (Vector<DocLink>)this.pluginsDoc.remove(string);
        if (vector == null) {
            vector = new Vector<DocLink>();
        }
        vector.add(docLink);
        this.pluginsDoc.put(string, vector);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sectionTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DocLink) {
            DocLink docLink = (DocLink)object;
            this.displayURL(docLink._url);
        }
    }

    private void displayURL(String string) {
        if (string.endsWith(".html") || string.endsWith(".htm") || string.endsWith(".HTML") || string.endsWith(".HTM") || string.endsWith("/") || string.endsWith("\\")) {
            this.browser.setPage(string);
        } else {
            GraphicUtils.execute((String)string);
        }
    }

    public String getDocURL(String string, String string2) {
        Collection collection = (Collection)this.pluginsDoc.get(string);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        for (DocLink docLink : collection) {
            if (!docLink._section.equals(string2)) continue;
            return docLink._url;
        }
        return null;
    }

    public String getHtmlForPlugin(String string) {
        String string2 = "<html><body>";
        string2 = string2 + "<h1>" + string + " Documentation<h1>";
        Collection collection = (Collection)this.pluginsDoc.get(string);
        if (collection != null) {
            string2 = string2 + "<ul>";
            for (DocLink docLink : collection) {
                string2 = string2 + "<li><a href=\"" + docLink._url + "\">" + docLink._display + "</a></li>";
            }
            string2 = string2 + "</ul>";
        }
        string2 = string2 + "</body><html>";
        return string2;
    }
}

