/*
 * Decompiled with CFR 0.152.
 */
package madkit.docbrowser;

import java.io.File;
import java.util.StringTokenizer;
import madkit.docbrowser.BrowserGUI;
import madkit.docbrowser.DocLink;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;

public class DocBrowserAgent
extends Agent {
    public static final String community = "public";
    public static final String group = "system";
    public static final String DOC_BROWSER_ROLE = "docbrowser";
    private boolean _alive = true;
    private BrowserGUI gui;
    private File madkitDirectory;
    private String docIndex;

    public DocBrowserAgent() {
        this(null);
    }

    public DocBrowserAgent(File file) {
        this.madkitDirectory = file == null ? new File(System.getProperty("madkit.dir")) : file.getAbsoluteFile();
        this.docIndex = "file:" + this.madkitDirectory.getPath() + File.separatorChar + "docs" + File.separatorChar + "index.html";
    }

    public void live() {
        if (this.hasGUI()) {
            this.gui.setPage(this.docIndex);
        }
        while (this._alive) {
            Message message = this.waitNextMessage();
            if (!this._alive) {
                return;
            }
            this.exitImmediatlyOnKill();
            if (!(message instanceof StringMessage)) continue;
            this.handleRequest(((StringMessage)message).getString());
        }
    }

    public void activate() {
        this.println("DocBrowserAgent activated");
        this.createGroup(false, community, group, null, null);
        this.requestRole(community, group, DOC_BROWSER_ROLE, null);
        this.broadcastMessage(community, group, "plugin", (Message)new StringMessage("getdoc"));
    }

    public void end() {
        this.println("Stopping DocBrowserAgent");
    }

    public void initGUI() {
        File file = new File(this.madkitDirectory.getAbsolutePath() + File.separatorChar + "cache" + File.separatorChar + "docs.xml");
        this.gui = new BrowserGUI(file, (AbstractAgent)this);
        this.setGUIObject(this.gui);
    }

    private void handleRequest(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u00a3");
        String string2 = stringTokenizer.nextToken();
        if (string2 == null) {
            this.println("Unknown Request " + string2);
            return;
        }
        if (!string2.equalsIgnoreCase("displayURL")) {
            if (string2.equalsIgnoreCase("displayDoc")) {
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (this.hasGUI()) {
                    this.gui.displayDoc(string3, string4);
                }
            } else if (string2.equalsIgnoreCase("displayLink")) {
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                if (this.hasGUI()) {
                    DocLink docLink = new DocLink(string5, string6, "file:" + string7, string8);
                    this.gui.displayLink(string8, docLink);
                }
            } else {
                this.println("Unknown Request " + string2);
            }
        }
    }
}

