/*
 * Decompiled with CFR 0.152.
 */
package madkit.TreeTools;

import java.io.File;
import java.util.Vector;
import madkit.TreeTools.AbstractFileNode;
import madkit.TreeTools.DirEntry;
import madkit.TreeTools.DirNode;
import madkit.TreeTools.Entry;
import madkit.TreeTools.FileNode;
import madkit.TreeTools.GenericTree;
import madkit.TreeTools.GenericTreeNode;

public class RemoteTree
extends GenericTree {
    Entry rootFile;
    GenericTreeNode localRoot;

    public Entry getRootFile() {
        return this.rootFile;
    }

    protected void buildDirectoryTree(AbstractFileNode abstractFileNode, Entry entry) {
        if (entry == null) {
            return;
        }
        if (entry.isDir()) {
            Vector vector = ((DirEntry)entry).getVect();
            for (int i = 0; i < vector.size(); ++i) {
                if (((Entry)vector.elementAt(i)).isDir()) {
                    DirNode dirNode = new DirNode((Entry)vector.elementAt(i), true);
                    abstractFileNode.add(dirNode);
                    this.buildDirectoryTree(dirNode, (Entry)vector.elementAt(i));
                    continue;
                }
                this.buildFileTree(abstractFileNode, (Entry)vector.elementAt(i));
            }
        }
    }

    protected void buildFileTree(AbstractFileNode abstractFileNode, Entry entry) {
        abstractFileNode.add(new FileNode(entry));
    }

    public void buildTree() {
        this.buildDirectoryTree((AbstractFileNode)this.top, this.rootFile);
    }

    public RemoteTree(Entry entry) {
        super(new DirNode(entry, true));
        this.rootFile = entry;
        this.buildTree();
        super.installTree();
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
    }

    public void addNode(Entry entry) {
        ((DirEntry)this.rootFile).addDirEntry((DirEntry)entry);
        DirNode dirNode = new DirNode(entry, true);
        super.addNode(this.top, dirNode);
        this.buildDirectoryTree(dirNode, entry);
        this.treeModel.reload();
    }

    public void remNode(int n) {
        ((DirEntry)this.rootFile).remDirEntry(n);
        this.top.remove(n);
        this.treeModel.reload();
    }

    public String getPath(Object[] objectArray) {
        String string = "";
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + objectArray[i].toString();
            if (i == n - 1) continue;
            string = string + File.separator;
        }
        return string;
    }
}

