/*
 * Decompiled with CFR 0.152.
 */
package madkit.TreeTools;

import java.io.File;
import java.util.Vector;
import madkit.TreeTools.Entry;
import madkit.TreeTools.FilEntry;

public class DirEntry
extends Entry {
    protected Vector vect;

    public DirEntry() {
        this.setDir(true);
        this.setName("Shared Directory");
        this.vect = new Vector();
    }

    public DirEntry(String string) {
        super(string, true);
        this.vect = new Vector();
        this.initialise(string);
    }

    public void initialise(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.setDir(true);
                    this.vect.addElement(new DirEntry(string + File.separator + file2.getName()));
                    ((Entry)this.vect.elementAt(n)).setDate(file2.lastModified());
                    ++n;
                    continue;
                }
                if (!file2.canRead()) continue;
                this.vect.addElement(new FilEntry(string + File.separator + file2.getName()));
                ((Entry)this.vect.elementAt(n)).setDate(file2.lastModified());
                ++n;
            }
        }
    }

    public Vector getVect() {
        return this.vect;
    }

    public void setVect(Vector vector) {
        this.vect = vector;
    }

    public void addDirEntry(DirEntry dirEntry) {
        this.vect.addElement(dirEntry);
    }

    public void remDirEntry(int n) {
        this.vect.removeElementAt(n);
    }

    public Object getEntry(int n) {
        return this.vect.elementAt(n);
    }

    public int getVectSize() {
        return this.vect.size();
    }

    public long isThereFile(String string, String string2) {
        long l = 0L;
        for (int i = 0; i < this.vect.size(); ++i) {
            if (((Entry)this.vect.elementAt(i)).isDir()) {
                l = ((DirEntry)this.vect.elementAt(i)).isThereFile(string, string2 + ((Entry)this.vect.elementAt(i)).getName() + File.separator);
                continue;
            }
            if (!string.equals(string2 + ((Entry)this.vect.elementAt(i)).getName())) continue;
            return ((Entry)this.vect.elementAt(i)).getDate();
        }
        return l;
    }

    public void display(String string) {
        System.out.println(string + "*" + this.getName());
        string = string + "\t";
        for (int i = 0; i < this.vect.size(); ++i) {
            if (((Entry)this.vect.elementAt(i)).isDir()) {
                ((DirEntry)this.vect.elementAt(i)).display(string);
                continue;
            }
            System.out.println(string + ((Entry)this.vect.elementAt(i)).getName());
        }
    }
}

