/*
* Prey.java -TurtleKit - A 'star logo' in MadKit
* Copyright (C) 2000-2007 Fabien Michel
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package turtlekit.simulations.hunt2;

import java.awt.Color;
import java.util.Arrays;

import turtlekit.kernel.Turtle;

/** A Prey

  @author Fabien MICHEL
  @version 2.0 25/02/2007 */

@SuppressWarnings("serial")
public class Prey extends Animat 
 {

 /**
	 * @param visionRadius
	 * @param initLife
	 */
	public Prey(int visionRadius, int initLife) {
		super(visionRadius, initLife);
	}

public void setup()
{
	playRole("prey");
	randomHeading();
	setColor(Color.white);
	if (countTurtlesHere()>0)
		fd(1);
}

double flee(int radius)
{
	for(int i=-radius;i<=radius;i++)
		for(int j=-radius;j<=radius;j++)
			if (! (i==0 && j==0) )
			{
				Turtle[] tur = turtlesAt(i,j);
				for (int k = 0; k < tur.length; k++)
					if (tur[k].isPlayingRole("predator")){ //instead of "instanceof". So prey can be another java class
						return 180+towards(tur[0].xcor(),tur[0].ycor());
					}
			}
	return Math.random()*180;
}

//a behavior
public String live()
{
	if(life>100)
		reproduce();
	consumeResource();
	setHeading(flee(visionRadius));
	turnRight(Math.random()*60);
	turnLeft(Math.random()*60);
	move();
	return "live";
}


}




