/*
* TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2000-2007 Fabien Michel, Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.kernel;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Hashtable;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

import madkit.kernel.AbstractAgent;

/**
 * <p>Titre : The GUI of metalauncher</p>
 * 
 * <p>Description : Under Development</p>
 * @author Gregory Beurier
 */
public class MetaLauncherGui extends JFrame {
    Hashtable tabTree = new Hashtable();
    int nbPanel = 0;
    MetaLauncher m;
    
    
    /** Creates new form NewJFrame */
    public MetaLauncherGui(MetaLauncher father) {
        m = father;
        initComponents();
    }
    
     /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
            	MetaLauncherGui m = new MetaLauncherGui(null);
            	m.setVisible(true);
            	
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
    	setTitle("TurtleKit 2.0.1");
        jInstanceTabPanel = new javax.swing.JTabbedPane();
        jMenuBar = new javax.swing.JMenuBar();
        jFileMenu = new javax.swing.JMenu();
        jLoadItem = new javax.swing.JMenuItem();
        jSaveItem = new javax.swing.JMenuItem();
        jCloseItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jQuitItem = new javax.swing.JMenuItem();
        jEditMenu = new javax.swing.JMenu();
        jToolsMenu = new javax.swing.JMenu();
        jHelpMenu = new javax.swing.JMenu();
        jContentsItem = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        jAboutItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jInstanceTabPanel.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                jInstanceTabPanelComponentShown(evt);
            }
        });

        getContentPane().add(jInstanceTabPanel, java.awt.BorderLayout.CENTER);

        jFileMenu.setText("File");
        jFileMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jFileMenuActionPerformed(evt);
            }
        });

        jLoadItem.setText("Open Simulation");
        jLoadItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.ALT_MASK));
        jLoadItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jLoadItemActionPerformed(evt);
            }
        });

        jFileMenu.add(jLoadItem);

        jSaveItem.setText("Save Simulation");
        jSaveItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jSaveItemActionPerformed(evt);
            }
        });

        jFileMenu.add(jSaveItem);

        jCloseItem.setText("Close");
        jFileMenu.add(jCloseItem);

        jFileMenu.add(jSeparator1);

        jQuitItem.setText("Quit");
        jFileMenu.add(jQuitItem);

        jMenuBar.add(jFileMenu);

        jEditMenu.setText("Edit");
        jMenuBar.add(jEditMenu);

        jToolsMenu.setText("Tools");
        jMenuBar.add(jToolsMenu);

        jHelpMenu.setText("Help");
        jContentsItem.setText("Help Contents");
        jHelpMenu.add(jContentsItem);

        jHelpMenu.add(jSeparator2);

        jAboutItem.setText("About");
        jHelpMenu.add(jAboutItem);

        jMenuBar.add(jHelpMenu);

        setJMenuBar(jMenuBar);

        setBounds(0, 0, 1500, 900);
        
    }
    // </editor-fold>//GEN-END:initComponents

    private void jInstanceTabPanelComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jInstanceTabPanelComponentShown

    }//GEN-LAST:event_jInstanceTabPanelComponentShown

    private void jSaveItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jSaveItemActionPerformed
        JFileChooser jChooser = new JFileChooser(System.getProperty("user.dir")+File.separator+"plugins");
        SimuFilter filter = new SimuFilter();
        jChooser.setFileFilter(filter);
        int returnVal = jChooser.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            System.out.println("You chose to open this file: " +
                    jChooser.getSelectedFile().getName());
            //MetaLauncherTabGUI newTab = new MetaLauncherTabGUI(jChooser.getSelectedFile());
            //jInstanceTabPanel.add("tmp", newTab);
            System.out.println("You chose to open this file: " +jChooser.getSelectedFile().getAbsolutePath());
            ((TabbedLauncherPanel)(tabTree.get(new Integer(jInstanceTabPanel.getSelectedIndex())))).saveXml(jChooser.getSelectedFile());
        }
    }//GEN-LAST:event_jSaveItemActionPerformed
    
    private void jLoadItemActionPerformed(java.awt.event.ActionEvent evt) {
//    	loadSimulationFile("/home/fab/MadKit/MadKit/plugins/turtlekit2/tk2simulations/Template_Simulation.xml");
        JFileChooser jChooser = new JFileChooser(System.getProperty("user.dir"));
        SimuFilter filter = new SimuFilter();
        jChooser.setFileFilter(filter);
        int returnVal = jChooser.showOpenDialog(this);
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            System.out.println("You chose to open this file: " +jChooser.getSelectedFile().getAbsolutePath());
            loadSimulationFile(jChooser.getSelectedFile().getAbsolutePath());
        }
        
    }//GEN-LAST:event_jLoadItemActionPerformed

	/**
	 * @param fileName
	 */
	private void loadSimulationFile(String fileName) {
		System.out.println("launching");
		Launcher l = new Launcher(fileName);
		m.launchAgent((AbstractAgent)l,fileName,true);
		l.disposeMyGUI();
		TabbedLauncherPanel xml = new TabbedLauncherPanel(fileName,l);
		jInstanceTabPanel.add(fileName, xml);
		tabTree.put(new Integer(nbPanel), xml); nbPanel++;
	}
     
    
    
    private void jFileMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jFileMenuActionPerformed
            }//GEN-LAST:event_jFileMenuActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem jAboutItem;
    private javax.swing.JMenuItem jCloseItem;
    private javax.swing.JMenuItem jContentsItem;
    private javax.swing.JMenu jEditMenu;
    private javax.swing.JMenu jFileMenu;
    private javax.swing.JMenu jHelpMenu;
    private javax.swing.JTabbedPane jInstanceTabPanel;
    private javax.swing.JMenuItem jLoadItem;
    private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JMenuItem jQuitItem;
    private javax.swing.JMenuItem jSaveItem;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JMenu jToolsMenu;
    // End of variables declaration//GEN-END:variables
    
}

class SimuFilter extends FileFilter {
    public final static String xml = "xml";
    public final static String smu = "smu";
    public final static String tk2 = "tk2";
    
    //Accept all directories and all gif, jpg, tiff, or png files.
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = getExtension(f);
        if (extension != null) {
            if (extension.equals(xml) ||
                    extension.equals(smu) ||
                    extension.equals(tk2)) {
                return true;
            } else {
                return false;
            }
        }
        
        return false;
    }
    
    public String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');
        
        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }
    
    //The description of this filter
    public String getDescription() {
        return "Turtlekit2 simulation files";
    }
}