/**
 * 
 */
package turtlekit2.guis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.HeadlessException;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.util.SwingUtility;

/**
 * @author fab
 *
 */
public class Tk2GUI extends JFrame implements DockingConstants{

	
	/**
	 * @param title
	 * @throws HeadlessException
	 */
	public Tk2GUI(){
		super("TK2");
        getContentPane().setLayout(new BorderLayout(3, 3));
        
        DefaultDockingPort leftPort = createDockingPort();
        getContentPane().add(leftPort, BorderLayout.WEST);

        DefaultDockingPort centerPort = createDockingPort();
        getContentPane().add(centerPort, BorderLayout.CENTER);
        
        ViewerGUI viewerGui = new ViewerGUI();
        connectToDockingPort(viewerGui, centerPort);
       
        ViewerGUI viewerGui2 = new ViewerGUI();
        connectToDockingPort(viewerGui2, centerPort);
       
        //JTreePanel jtree = new JTreePanel();
        
        
		
	}


	/**
	 * @param args
	 */
	public static void main(String[] args) {
		DockingManager.setFloatingEnabled(true);
		
		JFrame f = new Tk2GUI();
		f.setSize(800, 600);
		SwingUtility.centerOnScreen(f);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);

	}

	
    private static JComponent createDockableComponent(String name) {
        JPanel panel = new JPanel();
        panel.setBorder(new LineBorder(Color.BLUE));
        panel.add(new JLabel(name));
        return panel;
}

    private static DefaultDockingPort createDockingPort() {
    	DefaultDockingPort port = new DefaultDockingPort();
    	port.setPreferredSize(new Dimension(100, 100));
    	return port;
    }

    private static void connectToDockingPort(JComponent component, DefaultDockingPort port) {
        DockingManager.registerDockable(component);
        port.dock(component, DockingConstants.CENTER_REGION);
}


}
