/*
 * Genetic Package Copyright (C) 2002-2007 Gregory Beurier
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package turtlekit2.genetic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import turtlekit2.kernel.PatchVariable;
import turtlekit2.kernel.Turtle;

/**The GTurtle class implements the Turtle commands which are used to move set heading 
 * and implements genetic functionalities such as percepts construction or genes interpretation....
 * 
 *  * <p></p>
 * <p>XML Attributes : given in the metamanager class and in the parameters node</p>
 * <p>Pool: the name of the pool where the agent takes genome. required !!</p>
 * <p>GeneticMode: the way the genomes are given to the turtles. default is 0.
 * Options: 
 * 0: 1 genome per agent
 * 1: 1 genome per agent group (or node in the XML)
 * 2: for each pool, 1 genome per agents role
 * 3: 1 genome for the pool of the agent
 * 4: for each pool, 1 genome per role</p>
 * <p>Name: the agent Name.</p>
 * <p>Pool: the pool where agents takes genomes.</p>
 * <p>Role: the agent Role </p>
 * <p></p>
 * 
 @author Gregory BEURIER
 */
public class GTurtle extends Turtle {
	Genome genome = null;
	Vector flavors = new Vector();
	

	public GTurtle() {super("basisBehavior");}
	protected GTurtle(String initMethod) {super(initMethod);}
	public void setup() {}
	public void createFrame(){}
	public String basisBehavior(){
		
		return("basisBehavior");
	  }

	

	/** a HashTable of perceptions (Key: Flavor name, Value: Quantity perceived) */
	public Hashtable<String, Double> perceptTable(){
		Hashtable<String, Double> perceptTable = new Hashtable<String, Double>(flavors.size());
		for(int i=0;i<flavors.size();i++){
			perceptTable.put(((PatchVariable)(flavors.get(i))).getName(),new Double(getPatchVariable(((PatchVariable)(flavors.get(i))).getName())));
		}
		return perceptTable;
	}
	
	/** a ArrayList of perceptions, Values: Quantity of flavors/pheromones perceived ordered by declaration order*/
	public ArrayList<Double> perceptValues(){
		ArrayList<Double> perceptValues = new ArrayList<Double>(flavors.size());
		for (Double double1 : perceptValues) {
			
		}
		for(int i=0;i<flavors.size();i++){
			
			perceptValues.add(new Double(getPatchVariable(((PatchVariable)(flavors.get(i))).getName())));
		}
		return perceptValues;
	}
	
	/** toString method: role and pool */
	public String toString(){
		String output ="";
		output += getName() + " ";
		if(getAttributes().containsKey("Pool"))output += " pool: " +  getAttributes().getString("Pool");
		if(getAttributes().containsKey("Role"))output += " role: " +  getAttributes().getString("Role");
		output += " Type: " + getAttributes().getString("AgentClass");
		output += "\n";
		return output;
	}
	
	
	/**
	 * @return Returns the genome.
	 */
	public Genome getGenome() {
		return genome;
	}
	/**
	 * @param genome The genome to set.
	 */
	public void setGenome(Genome genome) {
		this.genome = genome;
	}
	/**
	 * @param flavors The flavors to set.
	 */
	public void setFlavors(Vector flavors) {
		this.flavors = flavors;
	}
	
	public Vector getFlavors() {
		return this.flavors;
	}
}
