package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import modulecoFramework.utils.graphicalWatcher.probes.AverageMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MaxMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MinMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.watchers.AutoCountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class JPanelOperation2 extends JPanel implements ActionListener {
	
	JTable jTableModality;
	
	JLabel jLabelProperty;
	JLabel jLabelModality;
	
	JComboBox jComboBoxProperty;
	
	ModalityTableModel modaliyTableModel;
	
	JScrollPane jScrollPaneModality;
	
	AutoCountWatcher autoCountWatcher;
	
	String choosenCommunity;
	String choosenGroup;
	String choosenRole;
	
	Object bean = null;
	
	public JPanelOperation2(AutoCountWatcher countWatcher) {
		super(new GridBagLayout());
		this.autoCountWatcher = countWatcher;
		this.build();
	}
	
	public void build() {
		
		jLabelProperty = new JLabel("Propriet : ");
		jLabelModality = new JLabel("Modalits trouvs : ");
		
		jComboBoxProperty = new JComboBox();
		
		modaliyTableModel = new ModalityTableModel(this, this.autoCountWatcher);
		//fieldTableModel = new FieldTableModel(this);
		jTableModality = new JTable(modaliyTableModel);
		jTableModality.setDefaultEditor(Color.class, new ColorEditor());
		jTableModality.setDefaultRenderer(Color.class, new ColorRenderer(true));
		//jTableModality.setGridColor(Color.white);
		jTableModality.setIntercellSpacing(new Dimension(2,2));
		jTableModality.setRowHeight(25);
		
		jScrollPaneModality = new JScrollPane(jTableModality);
		
		jComboBoxProperty.addActionListener(this);
		
		/*jTableSeries = new JTable(new SeriesTableModel(normalWatcher));
		jTableSeries.setDefaultEditor(Color.class, new ColorEditor());
		jTableSeries.setDefaultRenderer(Color.class, new ColorRenderer(true));
		jTableSeries.setGridColor(Color.white);
		jTableSeries.setIntercellSpacing(new Dimension(2,2));
		jTableSeries.setRowHeight(25);*/
		
		/*jScrollPaneSeries = new JScrollPane(jTableSeries);
		jScrollPaneSeries.getViewport().setBackground(Color.white);
		jScrollPaneSeries.getViewport().setOpaque(true);*/
		
		this.add(jLabelProperty,
				new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(jComboBoxProperty,
				new GridBagConstraints(0,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
		this.add(jLabelModality,
				new GridBagConstraints(0,2,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(jScrollPaneModality,
				new GridBagConstraints(0,3,1,1,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
	}
	
	public void setObject(Object o) {
		
		//System.out.println("JPanelOperation2 : setObject ");
		this.bean = o;
		
		jComboBoxProperty.removeAllItems();
		jComboBoxProperty.removeActionListener(this);
		if (this.bean != null) {
			Field[] fields = this.bean.getClass().getFields();
			for (int i = 0; i < fields.length; i++) {
				jComboBoxProperty.addItem(fields[i].getName());
			}
			//modaliyTableModel.setObject(o);
		}
		jComboBoxProperty.addActionListener(this);
		
		//jTableFields.setModel(fieldTableModel);  
	}
	
	public void setChoosenCommunity(String choosenCommunity) {
		this.choosenCommunity = choosenCommunity;
	}
	
	public void setChoosenGroup(String choosenGroup) {
		this.choosenGroup = choosenGroup;
	}
	
	public void setChoosenRole(String choosenRole) {
		this.choosenRole = choosenRole;
	}
	
	public void addSeries(String property) {
		
		System.out.println("addSeries for property : "+property);
		AutoCountMemoryProbe countMemoryProbe = new AutoCountMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
	
		autoCountWatcher.addMemoryProbe(countMemoryProbe,"defaultName");
		((ModalityTableModel)jTableModality.getModel()).updateModality();
		//jTableModality.setModel(modaliyTableModel);

	}
	/*public void addSeries(String operation, String property) {
		System.out.println("addSeries !!!!");
		CountMemoryProbe memoryProbe=null;
		if ("Sum".equals(operation)) {
			memoryProbe = new SumMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Avg".equals(operation)) {
			memoryProbe = new AverageMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Min".equals(operation)) {
			memoryProbe = new MinMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Max".equals(operation)) {
			memoryProbe = new MaxMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		if (memoryProbe != null) {
			countWatcher.addMemoryProbe(memoryProbe,operation+property);
			hashMapLink.put(operation+property,memoryProbe);
		}
		((SeriesTableModel) jTableSeries.getModel()).updateSeries();
	}
	
	public void removeSeries(String operation, String property) {
		System.out.println("removeSeries !!!!");
		MemoryProbe memoryProbe = (MemoryProbe)hashMapLink.get(operation+property);
		hashMapLink.remove(operation+property);
		countWatcher.removeMemoryProbe(memoryProbe);
		((SeriesTableModel) jTableSeries.getModel()).updateSeries();
	}*/

	public void actionPerformed(ActionEvent evt) {
		
		String item = (String)jComboBoxProperty.getSelectedItem();
		System.out.println("ACTION PERFORMED !!! "+item);
		if (evt.getSource().equals(jComboBoxProperty)) {
			if (item != null) {
				this.addSeries((String)jComboBoxProperty.getSelectedItem());
				jTableModality.validate();
				jTableModality.repaint();
			}
		}
		
	}
	
}
