package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import modulecoFramework.utils.graphicalWatcher.probes.AverageMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MaxMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MinMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.StdMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.VarMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class JPanelOperation1 extends JPanel {
	
	JTable jTableFields;
	JTable jTableSeries;
	
	JLabel jLabelFields;
	JLabel jLabelSeries;
	
	FieldTableModel fieldTableModel;
	
	JScrollPane jScrollPaneFields;
	JScrollPane jScrollPaneSeries;
	
	NormalWatcher normalWatcher;
	
	String choosenCommunity;
	String choosenGroup;
	String choosenRole;
	
	Map hashMapLink;
	
	public JPanelOperation1(NormalWatcher normalWatcher) {
		super(new GridBagLayout());
		this.normalWatcher = normalWatcher;
		hashMapLink = new HashMap();
		this.build();
	}
	
	public void build() {
		
		jLabelFields = new JLabel("Champs : ");
		jLabelSeries = new JLabel("Series : ");
		
		fieldTableModel = new FieldTableModel(this);
		jTableFields = new JTable(fieldTableModel);
		jScrollPaneFields = new JScrollPane(jTableFields);
		
		jTableSeries = new JTable(new SeriesTableModel(normalWatcher));
		jTableSeries.setDefaultEditor(Color.class, new ColorEditor());
		jTableSeries.setDefaultRenderer(Color.class, new ColorRenderer(true));
		jTableSeries.setGridColor(Color.white);
		jTableSeries.setIntercellSpacing(new Dimension(2,2));
		jTableSeries.setRowHeight(25);
		
		jScrollPaneSeries = new JScrollPane(jTableSeries);
		jScrollPaneSeries.getViewport().setBackground(Color.white);
		jScrollPaneSeries.getViewport().setOpaque(true);
		
		this.add(jLabelFields,
				new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(new JScrollPane(jTableFields),
				new GridBagConstraints(0,1,1,1,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
		this.add(jLabelSeries,
				new GridBagConstraints(0,2,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(jScrollPaneSeries,
				new GridBagConstraints(0,3,1,1,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
	}
	
	public void setObject(Object o) {
		fieldTableModel.setObject(o);
		jTableFields.setModel(fieldTableModel);  
	}
	
	public void setChoosenCommunity(String choosenCommunity) {
		this.choosenCommunity = choosenCommunity;
	}
	
	public void setChoosenGroup(String choosenGroup) {
		this.choosenGroup = choosenGroup;
	}
	
	public void setChoosenRole(String choosenRole) {
		this.choosenRole = choosenRole;
	}
	
	public void addSeries(String operation, String property) {
		System.out.println("addSeries !!!!");
		AbstractMemoryProbe memoryProbe=null;
		if ("Sum".equals(operation)) {
			memoryProbe = new SumMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Avg".equals(operation)) {
			memoryProbe = new AverageMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Min".equals(operation)) {
			memoryProbe = new MinMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Max".equals(operation)) {
			memoryProbe = new MaxMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("Var".equals(operation)) {
			memoryProbe = new VarMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		else if ("StD".equals(operation)) {
			memoryProbe = new StdMemoryProbe(choosenCommunity, choosenGroup, choosenRole, property);
		}
		if (memoryProbe != null) {
			normalWatcher.addMemoryProbe(memoryProbe,operation+property);
			hashMapLink.put(operation+property,memoryProbe);
		}
		((SeriesTableModel) jTableSeries.getModel()).updateSeries();
	}
	
	public void removeSeries(String operation, String property) {
		System.out.println("removeSeries !!!!");
		AbstractMemoryProbe memoryProbe = (AbstractMemoryProbe)hashMapLink.get(operation+property);
		hashMapLink.remove(operation+property);
		normalWatcher.removeMemoryProbe(memoryProbe);
		((SeriesTableModel) jTableSeries.getModel()).updateSeries();
	}
	
}
