package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MemoryProbeTest;
import modulecoFramework.utils.graphicalWatcher.watchers.AbstractChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

public class DynamicBarChart extends AbstractCAgentRepresentation{

	ChartPanel chartPanel;
	XYSeries[] series;
	AbstractChartWatcher abstractChartWatcher;
	JFreeChart chart;
	int pas = 0;
	CategoryDataset categoryDataset;
	String[] seriesNames;
	DefaultCategoryDataset defaultCategoryDataset;
	
	public DynamicBarChart(AbstractChartWatcher abstractChartWatcher) {
		
		this.name = "DynamicLineChart";
		
		this.abstractChartWatcher = abstractChartWatcher;
		
		this.setName("DynamicLineChart");
		this.setLayout(new BorderLayout());
		
		String[] categoryNames = new String[abstractChartWatcher.getNumberOfSeries()];
		defaultCategoryDataset = new DefaultCategoryDataset();
		
		seriesNames = new String[abstractChartWatcher.getNumberOfSeries()];
		
		for (int i = 0; i < categoryNames.length; i++) {
			categoryNames[i] = abstractChartWatcher.getSerieName(i);
			seriesNames[i] = abstractChartWatcher.getSerieName(i);
			defaultCategoryDataset.addValue(abstractChartWatcher.getLastValue(i),seriesNames[i],"");
		}
		
		categoryDataset = (CategoryDataset) defaultCategoryDataset;
		
		chart = ChartFactory.createBarChart
        		("Sample Category Chart", // Title
        				"",              // X-Axis label
        				"Sales",                 // Y-Axis label
        				categoryDataset,         // Dataset
        				PlotOrientation.VERTICAL,
        				true,                     // Show legend
        				true,						// tooltips
        				true						// urls	
        		);	

		CategoryPlot categoryPlot = (CategoryPlot) chart.getPlot();
		
		for (int i = 0; i < categoryDataset.getRowCount(); i++) {
			categoryPlot.getRenderer().setSeriesPaint(i,abstractChartWatcher.getColor(i));
		}
		
		chartPanel = new ChartPanel(chart);
		chartPanel.setMouseZoomable(true,true);
		this.add(chartPanel,BorderLayout.CENTER);
		
		this.validate();
		this.repaint();
		
		/*
		defaultCategoryDataset.addValue(35,"Second Quater","2001");
		defaultCategoryDataset.addValue(40,"First Quater","2002");
		defaultCategoryDataset.addValue(60,"Second Quater","2002");
		CategoryDataset categoryDataset = (CategoryDataset) defaultCategoryDataset;*/
		
		/*System.out.println("---------------------------------");
		System.out.println("New DynamicLineChart v2");
		System.out.println("\tNombre de srie : "+abstractChartWatcher.getNumberOfSeries());*/
		
		/*series = new XYSeries[abstractChartWatcher.getNumberOfSeries()];
		XYSeriesCollection dataset = new XYSeriesCollection();
		XYLineAndShapeRenderer xylasr = new XYLineAndShapeRenderer();
		for (int i = 0; i < series.length; i++) {
			series[i] = new XYSeries(abstractChartWatcher.getSerieName(i));
			series[i].add(pas, abstractChartWatcher.getLastValue(i));
			dataset.addSeries(series[i]);
			xylasr.setSeriesPaint(i,abstractChartWatcher.getColor(i));
		}
		pas++;
			
		//XYDataset dataset = new XYSeriesCollection(series);

		chart = ChartFactory.createXYLineChart(
		     "Line Chart",
		     "X",
		     "Y",
		     dataset,
	         org.jfree.chart.plot.PlotOrientation.VERTICAL,
		     true,
		     false,
	         false);
		
		for (int i = 0; i < series.length; i++) {
			Color color = abstractChartWatcher.getColor(i);
			//System.out.println(color);
			chart.getXYPlot().getRenderer().setSeriesPaint(i, color);
		}
		
		chartPanel = new ChartPanel(chart);
		chartPanel.setMouseZoomable(true,true);
		this.add(chartPanel,BorderLayout.CENTER);
		this.validate();
		this.repaint();*/
		
	}
	
	public void updateImage() {
		double[] values;
		for (int i = 0; i < categoryDataset.getRowCount(); i++) {
			defaultCategoryDataset.addValue(abstractChartWatcher.getLastValue(i),seriesNames[i],"");
		}
		/*defaultCategoryDataset.addValue(abstractChartWatcher.getLastValue(i),seriesNames[i],"");
		for (int i = 0; i < series.length; i++) {
			series[i].add(pas, abstractChartWatcher.getLastValue(i));
		}*/
		pas++;
	}

	public void resetImage() {
		
	}
	
	public JFreeChart getChart() {
		return chart;
	}

	
	
}
