package modulecoGUI.dataRecorder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

import modulecoFramework.modeleco.EWorld;
import modulecoFramework.modeleco.ModelParameters;
import modulecoFramework.utils.dataRecorder.Recorder;

/**
 * 
 * @author Thibaud Roussillat
 * @date 11/07/05
 */
public class JConfigRecorder extends JPanel implements ActionListener {
	
	/** Serial UID **/
	private static final long serialVersionUID = -4149040572651950861L;
	
	JPanel jPanelContainer;
	
	JPanel jPanelModelParameter;
	JPanel jPanelFile;
	JPanel jPanelProperties;
	
	JDialog jDialog;
	
	EWorld world;
	
	Recorder recorder;
	
	JButton jButtonOk;
	JButton jButtonCancel;
	
	JButton jButtonWorldRecord;
	JButton jButtonWorldRecord2;
	JButton jButtonWorldNotRecord;
	JButton jButtonWorldNotRecord2;
	
	JButton jButtonAgentRecord;
	JButton jButtonAgentRecord2;
	JButton jButtonAgentNotRecord;
	JButton jButtonAgentNotRecord2;
	
	JList jListWorldRecord;
	JList jListWorldNotRecord;
	
	JList jListAgentRecord;
	JList jListAgentNotRecord;
	
	JButton jButtonBrowse;
	JTextField jTextFieldFilePath;
	
	public JConfigRecorder(Recorder recorder, EWorld world) {
		
		this.recorder = recorder;
		this.world = world;
		this.setLayout(new BorderLayout());
		this.build();
		
	}
	
	protected void build() {
		
		this.buildModelParameter();
		this.buildFileParameter();
		this.buildProperties();
		
		jPanelContainer = new JPanel(new BorderLayout());
		jPanelContainer.add(jPanelModelParameter,BorderLayout.NORTH);
		jPanelContainer.add(jPanelFile,BorderLayout.CENTER);
		jPanelContainer.add(jPanelProperties,BorderLayout.SOUTH);
		
		jButtonOk = new JButton("OK");
		jButtonCancel = new JButton("Cancel");
		
		jButtonOk.addActionListener(this);
		
		JPanel jPanelButton = new JPanel(new FlowLayout());
		//jPanelButton.add(jButtonCancel);
		jPanelButton.add(jButtonOk);
		
		this.add(jPanelContainer,BorderLayout.CENTER);
		this.add(jPanelButton,BorderLayout.SOUTH);
		
		this.validate();
		this.repaint();
		
	}
	
	protected void buildModelParameter() {
		
		GridLayout gl = new GridLayout(3,4);
		gl.setHgap(10);
		gl.setVgap(10);
		
		jPanelModelParameter = new JPanel(gl);
		jPanelModelParameter.setBorder(BorderFactory.createTitledBorder("Model parameters"));
		
		JLabel jLabelModelName = new JLabel("Model Name : ");
		JLabel jLabelNeighbourName = new JLabel("Neighbour Name : ");
		JLabel jLabelSchedulerType = new JLabel("Scheduler Type : ");
		JLabel jLabelWorldSize = new JLabel("World Size : ");
		JLabel jLabelZoneName = new JLabel("Zone Name : ");
		
		ModelParameters modelParameters = this.world.getModelParameters();
		
		JTextField jTextFieldModelName = new JTextField(modelParameters.getName());
		JTextField jTextFieldNeighbourName = new JTextField(modelParameters.getNeighbourhood());
		JTextField jTextFieldSchedulerType = new JTextField(modelParameters.getTimeScheduler());
		JTextField jTextFieldWorldSize = new JTextField(modelParameters.getLength());
		JTextField jTextFieldZoneName = new JTextField(modelParameters.getZone());
		
		jTextFieldModelName.setEnabled(false);
		jTextFieldNeighbourName.setEnabled(false);
		jTextFieldSchedulerType.setEnabled(false);
		jTextFieldWorldSize.setEnabled(false);
		jTextFieldZoneName.setEnabled(false);
		
		jPanelModelParameter.add(jLabelModelName);
		jPanelModelParameter.add(jTextFieldModelName);
		jPanelModelParameter.add(jLabelNeighbourName);
		jPanelModelParameter.add(jTextFieldNeighbourName);
		jPanelModelParameter.add(jLabelSchedulerType);
		jPanelModelParameter.add(jTextFieldSchedulerType);
		jPanelModelParameter.add(jLabelWorldSize);
		jPanelModelParameter.add(jTextFieldWorldSize);
		jPanelModelParameter.add(jLabelZoneName);
		jPanelModelParameter.add(jTextFieldZoneName);
		
	}
	
	protected void buildFileParameter() {
		
		jPanelFile = new JPanel(new GridBagLayout());
		jPanelFile.setBorder(BorderFactory.createTitledBorder("Data File Parameters"));
		
		JLabel jLabelFilePath = new JLabel("File Path : ");
		JLabel jLabelFileFormat = new JLabel("Data Format : ");
		
		jTextFieldFilePath = new JTextField(recorder.getFilePath());
		jTextFieldFilePath.addFocusListener(new FocusListener(){
			public void focusGained(FocusEvent arg0) {
			}
			public void focusLost(FocusEvent arg0) {
				recorder.setFilePath(jTextFieldFilePath.getText());
			}
		});
		jTextFieldFilePath.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent evt)  {
				recorder.setFilePath(jTextFieldFilePath.getText());
            }
		});
		
		jButtonBrowse = new JButton("Browse");
		jButtonBrowse.addActionListener(this);
		
		jPanelFile.add(jLabelFilePath, new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelFile.add(jTextFieldFilePath, new GridBagConstraints(1,0,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelFile.add(jButtonBrowse, new GridBagConstraints(2,0,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelFile.add(jLabelFileFormat, new GridBagConstraints(0,1,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		
	}
	
	protected void buildProperties() {
		
		jPanelProperties = new JPanel(new BorderLayout());
		jPanelProperties.setBorder(BorderFactory.createTitledBorder("Selected Variables"));
		
		JTabbedPane jTabbedPane = new JTabbedPane();
		
		JPanel jPanelWorldProperties = new JPanel(new GridBagLayout());
		JPanel jPanelAgentProperties = new JPanel(new GridBagLayout());
		
		JLabel jLabelWorldRecord = new JLabel("Recorded :");
		JLabel jLabelWorldNotRecord = new JLabel("Not Recorded :");
		
		JLabel jLabelAgentRecord = new JLabel("Recorded :");
		JLabel jLabelAgentNotRecord = new JLabel("Not Recorded :");
		
		jListWorldRecord = new JList(recorder.getRecordedWorldProperies());
		jListWorldNotRecord = new JList(recorder.getNotRecordedWorldProperies());
		
		jListAgentRecord = new JList(recorder.getRecordedAgentProperies());
		jListAgentNotRecord = new JList(recorder.getNotRecordedAgentProperies());
		
		jButtonWorldRecord = new JButton(">");
		jButtonWorldRecord2 = new JButton(">>");
		jButtonWorldNotRecord = new JButton("<");
		jButtonWorldNotRecord2 = new JButton("<<");
		
		jButtonAgentRecord = new JButton(">");
		jButtonAgentRecord2 = new JButton(">>");
		jButtonAgentNotRecord = new JButton("<");
		jButtonAgentNotRecord2 = new JButton("<<");
		
		jButtonWorldRecord.addActionListener(this);
		jButtonWorldNotRecord.addActionListener(this);
		
		jButtonAgentRecord.addActionListener(this);
		jButtonAgentNotRecord.addActionListener(this);
		
		jPanelWorldProperties.add(jLabelWorldRecord,new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(jLabelWorldNotRecord,new GridBagConstraints(2,0,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(new JScrollPane(jListWorldRecord),new GridBagConstraints(0,1,1,4,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.BOTH,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(jButtonWorldRecord,new GridBagConstraints(1,1,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(jButtonWorldRecord2,new GridBagConstraints(1,2,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(jButtonWorldNotRecord,new GridBagConstraints(1,3,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(jButtonWorldNotRecord2,new GridBagConstraints(1,4,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelWorldProperties.add(new JScrollPane(jListWorldNotRecord),new GridBagConstraints(2,1,1,4,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.BOTH,new Insets(5,10,5,10),0,0));
		
		jPanelAgentProperties.add(jLabelAgentRecord,new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(jLabelAgentNotRecord,new GridBagConstraints(2,0,1,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(new JScrollPane(jListAgentRecord),new GridBagConstraints(0,1,1,4,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.BOTH,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(jButtonAgentRecord,new GridBagConstraints(1,1,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(jButtonAgentRecord2,new GridBagConstraints(1,2,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(jButtonAgentNotRecord,new GridBagConstraints(1,3,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(jButtonAgentNotRecord2,new GridBagConstraints(1,4,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelAgentProperties.add(new JScrollPane(jListAgentNotRecord),new GridBagConstraints(2,1,1,4,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.BOTH,new Insets(5,10,5,10),0,0));
		
		jTabbedPane.add("Agents' Variables", jPanelAgentProperties);
		jTabbedPane.add("World's Variables", jPanelWorldProperties);
		
		jPanelProperties.add(jTabbedPane,BorderLayout.CENTER);
		
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle("Record Data : ");
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}
	
	public int showJConfigRedorder(Component parent) {
		jDialog = this.createDialog(parent);
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return 1;
	}

	public void actionPerformed(ActionEvent evt) {
		
		/** World : Recorded > Not Recorded **/
		if (evt.getSource().equals(jButtonWorldRecord)) {
			
			Object[] selectedO = jListWorldRecord.getSelectedValues();
			
			for (int i = 0; i < selectedO.length; i++) {
				String s = (String) selectedO[i];
				recorder.eraseWorldProperty(s);
			}
			
			String[] recordedProperties = recorder.getRecordedWorldProperies();
			DefaultListModel dlmRecordedProperties = new DefaultListModel();
			for (int j = 0; j < recordedProperties.length; j++) {
				dlmRecordedProperties.addElement(recordedProperties[j]);
			}
			jListWorldRecord.setModel(dlmRecordedProperties);
			
			String[] notRecordedProperties = recorder.getNotRecordedWorldProperies();
			DefaultListModel dlmNotRecordedProperties = new DefaultListModel();
			for (int j = 0; j < notRecordedProperties.length; j++) {
				dlmNotRecordedProperties.addElement(notRecordedProperties[j]);
			}
			jListWorldNotRecord.setModel(dlmNotRecordedProperties);
			
		}
		
		/** World : Recorded < Not Recorded **/
		else if (evt.getSource().equals(jButtonWorldNotRecord)) {
			
			Object[] selectedO = jListWorldNotRecord.getSelectedValues();
			
			for (int i = 0; i < selectedO.length; i++) {
				String s = (String) selectedO[i];
				recorder.recordWorldProperty(s);
			}
			
			String[] recordedProperties = recorder.getRecordedWorldProperies();
			DefaultListModel dlmRecordedProperties = new DefaultListModel();
			for (int j = 0; j < recordedProperties.length; j++) {
				dlmRecordedProperties.addElement(recordedProperties[j]);
			}
			jListWorldRecord.setModel(dlmRecordedProperties);
			
			String[] notRecordedProperties = recorder.getNotRecordedWorldProperies();
			DefaultListModel dlmNotRecordedProperties = new DefaultListModel();
			for (int j = 0; j < notRecordedProperties.length; j++) {
				dlmNotRecordedProperties.addElement(notRecordedProperties[j]);
			}
			jListWorldNotRecord.setModel(dlmNotRecordedProperties);
			
		}
		
		/** Agent : Recorded > Not Recorded **/
		else if (evt.getSource().equals(jButtonAgentRecord)) {
			
			Object[] selectedO = jListAgentRecord.getSelectedValues();
			
			for (int i = 0; i < selectedO.length; i++) {
				String s = (String) selectedO[i];
				recorder.eraseAgentProperty(s);
			}
			
			String[] recordedProperties = recorder.getRecordedAgentProperies();
			DefaultListModel dlmRecordedProperties = new DefaultListModel();
			for (int j = 0; j < recordedProperties.length; j++) {
				dlmRecordedProperties.addElement(recordedProperties[j]);
			}
			jListAgentRecord.setModel(dlmRecordedProperties);
			
			String[] notRecordedProperties = recorder.getNotRecordedAgentProperies();
			DefaultListModel dlmNotRecordedProperties = new DefaultListModel();
			for (int j = 0; j < notRecordedProperties.length; j++) {
				dlmNotRecordedProperties.addElement(notRecordedProperties[j]);
			}
			jListAgentNotRecord.setModel(dlmNotRecordedProperties);
			
		}
		
		/** Agent : Recorded < Not Recorded **/
		else if (evt.getSource().equals(jButtonAgentNotRecord)) {
			
			Object[] selectedO = jListAgentNotRecord.getSelectedValues();
			
			for (int i = 0; i < selectedO.length; i++) {
				String s = (String) selectedO[i];
				recorder.recordAgentProperty(s);
			}
			
			String[] recordedProperties = recorder.getRecordedAgentProperies();
			DefaultListModel dlmRecordedProperties = new DefaultListModel();
			for (int j = 0; j < recordedProperties.length; j++) {
				dlmRecordedProperties.addElement(recordedProperties[j]);
			}
			jListAgentRecord.setModel(dlmRecordedProperties);
			
			String[] notRecordedProperties = recorder.getNotRecordedAgentProperies();
			DefaultListModel dlmNotRecordedProperties = new DefaultListModel();
			for (int j = 0; j < notRecordedProperties.length; j++) {
				dlmNotRecordedProperties.addElement(notRecordedProperties[j]);
			}
			jListAgentNotRecord.setModel(dlmNotRecordedProperties);
			
		}
		
		else if (evt.getSource().equals(jButtonOk)) {
			jDialog.setVisible(false);
			jDialog.dispose();
		}
		
		else if (evt.getSource().equals(jButtonBrowse)) {
			JFileChooser jfc = new JFileChooser(recorder.getFile());
			int choix = jfc.showSaveDialog(this);
			if (choix == JFileChooser.APPROVE_OPTION) {
				recorder.setFilePath(jfc.getSelectedFile().getAbsolutePath());
				jTextFieldFilePath.setText(recorder.getFilePath());
			}
			
		}
		
	}

}
