package modulecoGUI.cAgentEditor;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

public class OutputTableModel extends AbstractTableModel {
	
	/** serialVersionUID */
	private static final long serialVersionUID = 6568944258420554878L;

	/** L'objet edit **/
	public Object bean;
	
	/** La map associant proprit et propertyDescriptor **/
	private Map propertyDescriptorMap;
	
	/** Le beanInfo **/
    private BeanInfo info;
	
    /** Les paramtres de sorties **/
	String[] outputParameters;
	
	/**
	 * Constructor
	 */
	public OutputTableModel()  {
		
	}
	
	public OutputTableModel(Object bean)  {
        this();
        setObject(bean);
    }

	private void setObject(Object bean) {
		// On recupre le bean
		this.bean = bean;

		// On recupre le BeanInfo dans info
        info = BeanInfoFactory.getBeanInfo(bean);
		
		try {
			Field field1 = bean.getClass().getField("outputParameters");
			outputParameters = (String[]) field1.get(bean);
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		
		// Filter la table :
		// On recupre le BeanDescriptor grace au bean info
        if (info != null)  {
            filterTable();
        }
		
	}

	/**
	 * Filter les propertyDescriptors pour qu'ils correspondent  ceux prsents
	 * dans outputParameters.
	 */
	public void filterTable() {
		
		propertyDescriptorMap = new HashMap();
		PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
		
		PropertyDescriptor descr;
		for (int i = 0; i < descriptors.length; i++) {
	    	descr = descriptors[i];
	    	if (descr.getReadMethod() != null && !descr.isHidden() && !descr.isExpert()) {
		    	for (int j=0; j< outputParameters.length; j++) {
		    		if (descriptors[i].getName().equals(outputParameters[j])) {
			    		propertyDescriptorMap.put(outputParameters[j],descr);
		    		}
		    	}
	    	}
	    }
		
		/*List list  = new ArrayList();
		PropertyDescriptor descr;
	    for (int i = 0; i < descriptors.length; i++) {
	    	descr = descriptors[i];
	    	if (!descr.isHidden() && !descr.isExpert()) {
		    	for (int j=0; j< outputParameters.length; j++) {
		    		if (descriptors[i].getName().equals(outputParameters[j])) {
			    		list.add(descriptors[i]);
		    		}
		    	}
	    	}
	    }
	    if (list != null) {
		    descriptors = (PropertyDescriptor[])list.toArray(new PropertyDescriptor[list.size()]);
		}*/
	}
	
	public int getRowCount() {
		return outputParameters.length;
	}

	public int getColumnCount() {
		return 2;
	}

	public Object getValueAt(int row, int column) {
		if (column==0) {
			return outputParameters[row];
		}
		else if (column==1) {
			Object value = null;
			PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptorMap.get(outputParameters[row]);
			Method getter = null;
			if (pd != null) {
				getter = pd.getReadMethod();
			}
			if (getter != null) {
				Class[] paramTypes = getter.getParameterTypes();
				Object[] args = new Object[paramTypes.length];

				try {
					for (int i = 0; i < paramTypes.length; i++) {
						// XXX - debug
						System.out
								.println("\tShouldn't happen! getValueAt getter = "
										+ getter
										+ " parameter = "
										+ paramTypes[i]);
						args[i] = paramTypes[i].newInstance();
					}
				} catch (Exception ex) {
					// XXX - handle better
					ex.printStackTrace();
				}

				try {
					value = getter.invoke(bean, args);
					return value;
				} catch (IllegalArgumentException ex) {
					// XXX - handle better
					ex.printStackTrace();
				} catch (IllegalAccessException ex2) {
					// XXX - handle better
					ex2.printStackTrace();
				} catch (InvocationTargetException ex3) {
					// XXX - handle better
					ex3.printStackTrace();
				} catch (NoSuchMethodError ex4) {
					// XXX - handle better
					System.out
							.println("NoSuchMethodError for method invocation");
					System.out.println("Bean: " + bean.toString());
					System.out.println("Getter: " + getter.getName());
					System.out.println("Getter args: ");
					for (int i = 0; i < args.length; i++) {
						System.out.println("\t" + "type: " + paramTypes[i]
								+ " value: " + args[i]);
					}
					ex4.printStackTrace();
				}
			}
			else {
				try {
					return bean.getClass().getField(outputParameters[row]).get(bean);
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchFieldException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return "Not accessible value";
	}

}
