package modulecoGUI.cAgentEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EAgent;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

public class JAgentEditor extends AbstractCAgentRepresentation implements ActionListener {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 8571046791350217667L;

	protected EAgent agent;
	
	protected int minRowHeight = 24;
	protected int intercellSpacing = 1;
	protected int action;
	
	public static int APPROVE_OPTION = 1;
	
	protected JPanel jPanelButton;
	protected JButton jButtonOK;
	
	protected JDialog jDialog;
	protected JFrame jFrame;
	
	protected JTabbedPane jTabbedPane;
	
	/**
	 * Constructor
	 * @param agent : the agent to edit
	 */
	public JAgentEditor(EAgent agent) {
		
		this.setLayout(new BorderLayout());
		
		this.agent = agent;
		
		this.build();
		
	}
	
	/*public void activate() {
		this.requestRole(Moduleco.COMMUNITY, Moduleco.ENGINE_GROUP,"worldListener", null);
	}*/

	/**
	 * Build the Component and place it
	 *
	 */
	private void build() {
		
		this.setLayout(new BorderLayout());
		
		jTabbedPane = new JTabbedPane();
		
		// build the table to edit agent
		PropertyTableModel tableModelParameters = new PropertyTableModel(agent);
		
        PropertyColumnModel columnModelParameters = new PropertyColumnModel();
        JTable tableParameters = new JTable(tableModelParameters, columnModelParameters);
		
        this.setTable(tableParameters);
        
        jTabbedPane.addTab("Parameters",new JScrollPane(tableParameters));
        
        /*this.add(new JScrollPane(tableParameters),BorderLayout.CENTER);*/
        
        OutputTableModel outputTableModel = new OutputTableModel(agent);
        JTable tableOutput = new JTable(outputTableModel);
        
        jTabbedPane.addTab("Values",new JScrollPane(tableOutput));
        
        this.add(jTabbedPane,BorderLayout.CENTER);
        
        // Build the panel with the button
        jPanelButton = new JPanel(new FlowLayout());
        jButtonOK = new JButton("OK");
        jButtonOK.addActionListener(this);
        jPanelButton.add(jButtonOK);
        
        this.add(jPanelButton,BorderLayout.SOUTH);
        
	}
	
	private void setTable(JTable table) {
		
        table.setGridColor(UIManager.getColor("control"));
        table.setBackground(UIManager.getColor("control"));
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		
		table.setIntercellSpacing(new Dimension(0,intercellSpacing));
		table.getTableHeader().setVisible(false);
		
		for (int i=0;i<table.getRowCount();i++) {
        	Component c1 = table.getCellRenderer(i,1).getTableCellRendererComponent(table, table.getValueAt(i,1), false, false, i, 1);
        	Component c2 = table.getCellRenderer(i,2).getTableCellRendererComponent(table, table.getValueAt(i,2), false, false, i, 2);
        	Component c3 = table.getCellRenderer(i,3).getTableCellRendererComponent(table, table.getValueAt(i,3), false, false, i, 3);
        	
        	double c1H = c1.getPreferredSize().getHeight();
        	double c2H = c2.getPreferredSize().getHeight();
        	double c3H = c3.getPreferredSize().getHeight();
        	
        	if (c1H > c2H && c1H > c3H && c1H > minRowHeight) {
        		table.setRowHeight(i,(int)c1H);
        	}
        	else if (c2H > c1H && c2H > c3H && c2H > minRowHeight) {
        		table.setRowHeight(i,(int)c2H);
        	}
        	else {
        		table.setRowHeight(i,minRowHeight);
        	}
        }
	}
	
	/**
	 * Show the Agent Editor
	 * @param parent : the parent Component
	 * @return the action (always 1 for the moment)
	 */
	public int showAgentEditor(Component parent) {
		
		jFrame = new JFrame();
		
		jFrame.getContentPane().add(this);
		jFrame.setTitle("Edit Agent : " + agent.getName());
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jFrame.setSize(new Dimension(400,400));
		jFrame.setLocation((screenSize.width-jFrame.getWidth())/2,(screenSize.height-jFrame.getHeight())/2);
		jFrame.setVisible(true);
		return 0;
		
		/*jDialog = this.createDialog(parent);
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return APPROVE_OPTION;*/
		
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(false);
	 		dialog.setTitle("Edit Agent : " + agent.getName());
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}

	public void actionPerformed(ActionEvent evt) {
		
		if (evt.getSource().equals(jButtonOK)) {
			jFrame.setVisible(false);
			jFrame.dispose();
			/*jDialog.setVisible(false);
			jDialog.dispose();*/
		}
		
	}

	public void updateImage() {
		this.repaint();
	}

	public void resetImage() {
		// TODO Auto-generated method stub
	}
	
}
