package modulecoGUI;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

import test.SimpleClassLoader;

import madkit.kernel.Agent;
import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.ENeighbourWorld;
import modulecoFramework.simulation.ModulecoLauncher;
import modulecoFramework.utils.dataRecorder.StatRecorder;
import modulecoGUI.XMLGuiReader.GUIParser;
import modulecoGUI.XMLGuiReader.XMLModelReader;
import modulecoGUI.cAgentEditor.JAgentEditor;
import modulecoGUI.cAgentEditor.JAgentLinksEditor;
import modulecoGUI.dataRecorder.JConfigRecorder;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentationContainer;
import modulecoGUI.graphicBuilder.JCreateDynamicChart;

import modulecoGUI.utils.SimpleFileFilter;

/**
 * @author Thibaud Roussillat
 * @version 1.5.1a - Last modify on 20 September 2005
 *
 * Cette classe reprsente le gestionnaire d'interaction. C'est elle qui gre la manire 
 * dont les tches utilisateurs vont se succder. Elle possde une rfrence sur la classe ModulecoLauncher
 * du noyau ainsi que sur les classes ModulecoBean et JPanelMain de l'interface. 
 * 
 */
public class CentralControl {

	/** Le panneau "highest level" de l'interaction **/
	JPanelMain jPanelMain;
	
	/** La fentre pour avoir accs au menu facilement (mise  jour notamment des vues : jMenuShowView)**/
	ModulecoBean modulecoBean;
	
	/** MoulecoLauncher : Point d'entre du Noyau Moduleco **/
	public ModulecoLauncher modulecoLauncher;
	
	/** Permet de grer les prfrences utilisateurs **/
	Preferences preferences = Preferences.userNodeForPackage(CentralControl.class);
	
	/** Stockage des reprsentations graphiques du monde (celles-ci doivent tre de type CAgentRepresentation)**/
	CAgentRepresentationContainer agentRepresentationContainer;
	
	/** Permet de savoir si un statManager est disponible... **/
	public boolean statManagerEnabled = true;
	
	/** Codage des graphiques dynamiques  afficher **/
	public static int LINE_CHART = 0;
	public static int BAR_CHART = 1;
	public static int PIE_CHART = 2;
	
	/** Le parser XML permettant de charger les labels prsents dans l'interface **/
	public GUIParser guiParser;
	
	/**
	 * Constructeur 
	 * @param modulecoLauncher : the modulecoLauncher
	 */
	public CentralControl(ModulecoLauncher modulecoLauncher) {
		
		/* Fait le lien avec le noyau de modulecoMK */
		this.modulecoLauncher = modulecoLauncher;
		
		/* Indique au modulecoLauncher qu'il peut accder au centralControl */
		this.modulecoLauncher.setCentralControl(this);
		
		/* Construction d'un nouveau agentRepresentationContainer */
		agentRepresentationContainer = new DefaultAgentRepresentationContainer();
		
		/** TODO : enregistrer la langue choisie et charger le fichier correspondant **/
		/* Initialisation du parseur xml avec un fichier par dfaut */
		guiParser = new GUIParser("GUI.english.xml");
		
	}
	
	/**
	 * Renvoi un container qui contient un ensemble de reprsentation graphique du monde 
	 * (canevas, courbes ou autre). Ces reprsentations graphiques sont de type CAgentRepresentation
	 * @return the agentRepresentationContainer
	 */
	public CAgentRepresentationContainer getAgentRepresentationContainer() {
		return agentRepresentationContainer;
	}
	
	/**
	 * Called by JPanelParameters.actionPerformed() (> Cancel) 
	 * to remove the JPanelParameters and clear the central area
	 */
	public void removeJPanelParameters() {
		/* Demande au jPanelMain de retirer le panneau central */
		jPanelMain.removeJPanelParameters();
	}
	
	/**
	 * Call when a model has been selected to configure it.
	 * @param world : the loaded world
	 */
	public void loadJPanelParameters(Object world) {
		jPanelMain.loadJPanelParameters(world);
	}
	
	/**
	 * @return Returns the jPanelMain.
	 */
	public JPanelMain getJPanelMain() {
		return jPanelMain;
	}
	
	/**
	 * @param panelMain The jPanelMain to set.
	 */
	public void setJPanelMain(JPanelMain panelMain) {
		jPanelMain = panelMain;	
	}

	/**
	 * TODO : prvisualisation du modle sur le JFileChooser : http://java.developpez.com/faq/java/?page=jfilechooser#previewJFileChooser
	 * Open a JModelChooser to permit the user to select a model to open
	 */
	public void openJFileChooserForModele() {
		
		/* Cration d'un nouveau JModelChooser avec en paramtre l'objet graphique parent (modulecoBean)
		 * et le modle par dfaut rcupr dans les prfrences utilisateur */
		JModelChooser jmc = new JModelChooser(modulecoBean,preferences.get("defaultModel",""));
		/* Ouverture de la fentre du JModelChooser (action bloquante tant que la fentre n'est pas ferme) */
		int i = jmc.showModelChooser();
		
		/* Si le choix du modle est valider */
		if (i == JModelChooser.APPROVE_OPTION) {
			/* Commande la JPanelMane de mettre  disable les boutons de contrle de la simulation */
			jPanelMain.setControlButtonEnable(false);
			/* Rcupration du nom du modle */
			String model = (String) jmc.getSelectedModel();
			/* Enregistrement du dernier model ouvert (prfrene interface graphique) */
			preferences.put("defaultModel",model);
			/* Chargement du model et du monde */
			this.loadWorld(model);
			/* Prpare la lecture du fichier XML d'aide en fonction du modle choisi */
			XMLModelReader.buildXMLModelReader();
			/* Nettoie le container de reprsentation des agents */
			this.clearAgentRepresentation();
			/* Charge le fichier de paramtre pour configurer le modle */
			this.loadJPanelParameters(modulecoLauncher.getEWorld());
			
			/* Mise  jour du titre de la fentre */
			modulecoBean.setTitle("Moduleco - "+Moduleco.getCurrentModelName());
			
		}
		
	}
	
	/**
	 * load the model named selectedModel in the modulecoLauncher
	 * @param selectedModel : the name of the model
	 */
	private void loadWorld(String selectedModel) {
		modulecoLauncher.create(selectedModel);
	}
	
	
	/**
	 * Test d'introspection :  remettre en place s'il on veut charger des modles
	 * qui ne sont pas dans le rpertoire /lib.
	 */
	private Class getClassFromFile(File file) {
		
		System.out.println("Test Introspection : ");
		System.out.println("File : " + file.getAbsolutePath());
		
		SimpleClassLoader simpleClassLoader = new SimpleClassLoader();
		
		Class c = null;
		
		try {
			c = simpleClassLoader.loadLocalClass(file,true);
			System.out.println("Class Loaded !!!");
			System.out.println(c.getName());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		
		/**
		 * TODO : attention, la classe c'est associ au ClassLoader qui l'a charg... c'est donc lui
		 * qui est utilis pour tout les objet cr dans cette classe et non celui par dfaut.
		 * Certaine classe ne sont donc plus accessible...
		 * Remettre celui par dfaut ?
		 */
		
		return c;

	}

	/**
	 * Permet de charger le panel principal aprs le panneau
	 * de paramtre. Appeler par la mthode this.validateParameters()
	 */
	public void loadJPanelMiddle() {
		jPanelMain.loadJPanelMiddle();
	}

	/**
	 * Charge dans l'interface graphique tout les reprsentations graphiques dfini sous forme de
	 * classe dans le modle.
	 * TODO : dfinir une mthode pour dfinir les reprsentations disponibles
	 *
	 */
	public void loadDefaultAgentRepresentation() {
		
		/* Rcupration du champ "outputGraphics" de la classe World*/
		Field field = null;
		try {
			/* Rcupration de l'objet Field */
			field = modulecoLauncher.getEWorld().getClass().getField("outputGraphics");
			String[] representation = new String[0];
			try {
				/* Rcupration de la valeur du champ */
				representation = (String[]) field.get(modulecoLauncher.getEWorld());
				/* Pour chaque reprsentation graphique :*/
				for (int i=0;i<representation.length;i++) {
					Class classe = null;
					/* Rcupration du nom complet de la classe */
					String classeName = modulecoLauncher.getEWorld().getPackageName() + "."+representation[i];
					try {
						/* Chargement via le classe Loader de Madkit */
						classe = Moduleco.getClass(classeName);
						CAgentRepresentation car = null;
						try {
							/* Instanciation de la classe */
							car = (CAgentRepresentation) classe.newInstance();
						} catch (InstantiationException e) {
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							e.printStackTrace();
						}
						/* liaison de la reprsentation graphique vers le centralControl */
						car.setCentralControl(this);
						/* ajout  la liste des reprsentations graphiques du modle disponibles */
						this.addAgentRepresentation(car);
					
					} 
					catch (ClassNotFoundException e) {
						/* Affichage d'un message dans l'interface */
						//this.showMessageDialog("ClassNotFoundException : "+ classeName+".\n"+classeName+" doesn't exist in your model.\nThe default version will be loaded from the Moduleco framework.");
						try {
							/* Si la classe n'existait pas dans le modle, chargement  partir du framework 
							 * valable pour les reprsentations graphiques gnrique qui n'ont pas t
							 * redfini dans le modle (par exemple Canevas.java) */
							classe = Moduleco.getClass("modulecoGUI.grapheco."+representation[i]);
							CAgentRepresentation car = null;
							try {
								/* Instanciation de la classe */
								car = (CAgentRepresentation) classe.newInstance();
							} catch (InstantiationException e1) {
								e1.printStackTrace();
							} catch (IllegalAccessException e1) {
								e1.printStackTrace();
							}
							/* liaison de la reprsentation graphique vers le centralControl */
							car.setCentralControl(this);
							/* ajout  la liste des reprsentations graphiques du modle disponibles */
							this.addAgentRepresentation(car);
						} catch (ClassNotFoundException e1) {
							e1.printStackTrace();
							/* Affichage d'un message d'alerte en cas d'impossibilit de charger une 
							 * reprsentation spcifie */
							//this.showMessageDialog("ClassNotFoundException : "+ classeName+".\n"+classeName+" doesn't exist in the Moduleco framework.\nYou must implement it in your model.");
						}
					}
				}
			
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			
		} catch (SecurityException e) {
			e.printStackTrace();
			this.showMessageDialog("SecurityException in loading the field outputGraphics of the class \"World\". Verify the field is not redeclared with a protected or private access.");
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
			this.showMessageDialog("NoSuchFieldException in loading the field \"outputGraphics\" of the class \"World\". Verify the field exists");
		}
		
		/* Cration et Chargement des reprsentations graphiques communes  tous les modles
		 * et permettant d'intragir avec eux (Panneau de configuration du modle, AgentEditor, Console,...)*/
		this.addAgentRepresentation(new JConfigModelParameterQuick());
		this.addAgentRepresentation(new JMadkitOutputQuick(modulecoLauncher.getOutputGUI()));
		this.addAgentRepresentation(new JAgentEditorQuick(modulecoLauncher.getGraphicalWatcher()));
			
	}
	
	/**
	 * Ajoute un objet de type agentRepresentation dans l'interface
	 * Cette mthode est appel uniquement au chargement des diffrentes 
	 * reprsentation par loadDefaultAgentRepresentation()
	 * @param agentRepresentation : une reprsentation graphique du modle
	 */
	public void addAgentRepresentation(CAgentRepresentation agentRepresentation) {
		
		/* affectation de l'agent "pre" */
		agentRepresentation.setCAgent(modulecoLauncher.getEWorld());
		/* Ajout au container des reprsentations */
		agentRepresentationContainer.addCAgentRepresentation(agentRepresentation);
		
		/* Mise  jour du menu "show view" avec nom et icone */
		modulecoBean.updateMenuShowView(agentRepresentation.getName(),agentRepresentation.getIcon());
		
	}
	
	
	/**
	 * Ajoute dynamiquement un objet de type agentRepresentation dans l'interface. Cela
	 * signifie que l'on peut ajouter dynamiquement une reprsentation graphique du modle
	 * Cette mthode est notamment appel lors des crations de graphiques dynamiques...
	 * @param agentRepresentation : la reprsentation graphique de type agentRepresentation
	 */
	public void addDynamicAgentRepresentation(CAgentRepresentation agentRepresentation) {
		/* Ajout de la reprsentation */
		this.addAgentRepresentation(agentRepresentation);
		/* L'ajoute au jPanelMain */
		this.jPanelMain.addAgentRepresentation(agentRepresentation);
		/* Et demande de l'afficher au premier plan */
		this.showView(agentRepresentation.getName());
	}
	
	/**
	 * TODO : debug method : remove it in the future
	 * Montre la hirarchie des fentres dans Moduleco
	 */
	public void displayDockingHierarchy() {
		jPanelMain.jPanelMiddle.displayDockingHierarchy();	
	}

	/**
	 * Remet  zero l'organisation des vues de l'interfaces graphiques.
	 */
	public void resetPerspective() {

		jPanelMain.resetPerspective();
		
	}

	/**
	 * Met au premier plan la view nomm "name". Attention, si deux vues ont le mme
	 * nom, il chargera la premire vue trouve.
	 * @param name : le nom de la view
	 */
	public void showView(String name) {

		jPanelMain.showView(name);
		
	}

	/**
	 * Set the ModulecoBean
	 * @param modulecoModuleco
	 */
	public void setModulecoBean(ModulecoBean modulecoBean) {
		
		this.modulecoBean = modulecoBean;
		this.setJPanelMain(modulecoBean.getJPanelMain());
		
	}

	/**
	 * Valide les paramtres d'entres du modle une fois que l'utilisateur a cliqu sur "OK".
	 */
	public void validateParameters() {
		
		/* Lance le monde et crer les scheduler */
		modulecoLauncher.launch();
		
		/* Charge les reprsentations graphiques par dfaut */
		this.loadDefaultAgentRepresentation();
		
		/* Charge dans l'interface le panneau central */
		this.loadJPanelMiddle();
		
		/* Met  jour l'ensemble des reprsentations grpahiques */
		agentRepresentationContainer.updateImage();
		
		/* Remet  disposition les boutons de control de la simulation */
		jPanelMain.setControlButtonEnable(true);
		
	}
	
	/**
	 * Launch a MadKit agent from the menu
	 * @param className
	 */
	public void launchMadkitAgent(String className) {
		
		try {
			/* Chargement de la classe via le Class loader de Madkit */
			Class c = Moduleco.getClass(className);
			/* Instanciation de la classe */
			Object o = c.newInstance();
			/* Lancement de l'agent */
			modulecoLauncher.launchAgent((Agent)o,className,true);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	
	}

	/**
	 * Start the simulation. Fait le lien avec la JToolBarCommande
	 */
	public void simulationStart() {
		modulecoLauncher.getSimulationControl().start();
	}
	
	/**
	 * Make the world evolve one step. Fait le lien avec la JToolBarCommande
	 */
	public void simulationMstep() {
		modulecoLauncher.getSimulationControl().progress(); //agents event
		modulecoLauncher.getSimulationControl().progress(); //world event
	}
	
	/**
	 * Stop the simulation.
	 * <p>
	 * invoked by JToolBarCommand.actionPerformed() Encapsulate
	 * simulationControl.stop(); stop the current simulation i.e; interrupt the
	 * Thread but the simulation is not closed.
	 */
	public void simulationStop() {
			modulecoLauncher.getSimulationControl().stop();
	}
	
	/**
	 * Terminate the current simulation. Fait le lien avec la JToolBarCommande
	 */
	public void simulationTerminate() {
			modulecoLauncher.getSimulationControl().terminate();
	}
	

	/**
	 * Met  jour  chaque pas les diffrentes reprsentations graphiques du modles
	 */
	public void updateImage() {
		agentRepresentationContainer.updateImage();
	}

	/**
	 * Met  jour le nombre d'itration dans la JToolBarCommande.
	 */
	public void updateIter(int iter) {
		jPanelMain.updateIter(iter);
	}

	/**
	 * Reload the same model, and its parameters
	 * For the moment, show the parameter panel
	 */
	public void reload() {
		/* Refixe le nbre d'itration  0 */
		jPanelMain.updateIter(0);
		/* Met  "disabled" les boutons de controle de la simulation */
		jPanelMain.setControlButtonEnable(false);
		/* Termine la simulation prcdente */
		modulecoLauncher.end();
		/* Cr la nouvelle simulation */
		modulecoLauncher.create(Moduleco.getCurrentModelName());
		/* Nettoie le container de reprsentation */
		this.clearAgentRepresentation();
		/* Charge le panneau de paramtre */
		jPanelMain.loadJPanelParameters(modulecoLauncher.getEWorld());
		
	}

	/**
	 * Vide l'agentRepresentationContainer pour ne plus avoir les reprsentation
	 * du modle prcdent en mmoire
	 */
	private void clearAgentRepresentation() {
		agentRepresentationContainer.clearAllAgentRepresentation();
	}
	
	/**
	 * Debug method : print the neighbourhood of each agent
	 */
	public void displayNeighbourhood() {
		ENeighbourWorld eWorld = (ENeighbourWorld) modulecoLauncher.getEWorld();
		//eWorld.get
		List list = eWorld.agentSet;
		for (Iterator i=list.iterator();i.hasNext();) {
			EAgent agent = (EAgent) i.next();
			System.out.println(agent.agentID);
			List neighbours = (agent.getMediums())[0].getAgentsForRole("neighbour");
			//List neighbours = agent.getNeighbours();
			for (Iterator j=neighbours.iterator();j.hasNext();) {
				EAgent voisin = (EAgent) j.next();
				System.out.println("\t"+voisin.agentID);
			}
		}
	}

	/**
	 * Ecrit les paramtres du modle en proposant une fentre permettant
	 * de choisir l'emplacement du fichier.
	 */
	public void writeModelParameters() {
		
		FileFilter param = new SimpleFileFilter("Fichiers de Paramtres",".parameters");
		
		JFileChooser chooser = new JFileChooser(preferences.get("folderParameters","."));
		chooser.addChoosableFileFilter(param);
		chooser.setDialogTitle("Open a parameter File for model "+modulecoLauncher.getEWorld().getName());
		int returnVal = chooser.showSaveDialog(null);
		
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			preferences.put("folderParameters",chooser.getCurrentDirectory().getAbsolutePath());
			System.out.println("File SAve : "+chooser.getSelectedFile().getAbsoluteFile());
			modulecoLauncher.writeModelParameters(chooser.getSelectedFile());
		}
		
	}

	/**
	 * Lit les paramtres du modle en proposant une fentre graphique permettant
	 * de choisir le fichier  charger.
	 */
	public String readModelParameter() {
		
		FileFilter param = new SimpleFileFilter("Fichiers de Paramtres",".parameters");
		
		JFileChooser chooser = new JFileChooser(preferences.get("folderParameters","."));
		chooser.addChoosableFileFilter(param);
		chooser.setDialogTitle("Open a parameter File for model "+modulecoLauncher.getEWorld().getName());
		int returnVal = chooser.showOpenDialog(null);
		
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			preferences.put("folderParameters",chooser.getCurrentDirectory().getAbsolutePath());
			System.out.println("File Open : "+chooser.getSelectedFile().getAbsoluteFile());
			modulecoLauncher.readModelParameters(chooser.getSelectedFile());
			jPanelMain.jPanelParameters.repaint();
			return chooser.getSelectedFile().getAbsolutePath();
		}
		
		return "";
		
	}

	/**
	 * Appel  partir de JToolBarCommand
	 * @param typeChart : un entier reprsentant le type de graphique<br>
	 * static dans CentralControl : <br>
	 * 	LINE_CHART = 0; <br>
	 *	BAR_CHART = 1; <br>
	 *	PIE_CHART = 2; <br>
	 */
	public void createChart(int typeChart) {
		
		JCreateDynamicChart gwb = new JCreateDynamicChart(this, typeChart, modulecoBean);
		gwb.showCreateDynamicChart();
		
	}

	/**
	 * Charge le modle dont le nom est pass en paramtre sans montrer le panneau
	 * de configuration des paramtres du modle
	 * Appel par Core.java
	 * @param modelName : le nom du modle  charger
	 */
	public void loadDefaultModel(String modelName) {
		
		this.loadWorld(modelName);
		this.loadJPanelParameters(modulecoLauncher.getEWorld());
		this.validateParameters();
		
	}

	/**
	 * Permet d'afficher la fentre permettant de configurer les variables  enregistrer
	 * dans le fichier spcifier via l'interface.
	 *
	 */
	public void showJConfigRecorder() {
		
		JConfigRecorder jConfigRecorder = new JConfigRecorder(modulecoLauncher.getRecorder(), modulecoLauncher.getEWorld());
		jConfigRecorder.showJConfigRedorder(this.modulecoBean);
		
	}

	/** 
	 * Permet d'diter un agent slctionner via le Canevas
	 * Appel via Canevas.java
	 * TODO : crer une interface (EditWorldListener) et faire en sorte que les vnements dclencher via
	 * l'interface soit rcuprer par ces listener l ! (ici CentralControl pourrait implmenter EditWorldListener)
	 * Voir le role du WorldListener dans de tel cas...
	 * @param agent : the agent to edit
	 */
	public void editAgent(EAgent agent) {
		
		System.out.println("editAgent : "+ agent.getAgentID());
		JAgentEditor jAgentEditor = new JAgentEditor(agent);
		jAgentEditor.showAgentEditor(modulecoBean);
		this.addAgentRepresentation(jAgentEditor);
		this.updateImage();
		
	}

	/** 
	 * Permet d'diter les liens entre agent
	 * @param agent : the agent to edit 
	 */
	public void editAgentLinks(EAgent agent) {
		
		JAgentLinksEditor jAgentLinksEditor = new JAgentLinksEditor(agent);
		jAgentLinksEditor.showAgentLinksEditor(this.modulecoBean);
		
		this.updateImage();
		
	}
	
	/** 
	 * Permet d'afficher facilement des pop-up d'erreur dans l'interface
	 * @param message : le message  afficher dans la pop-up
	 */
	public void showMessageDialog(String message) {
		
		JOptionPane.showMessageDialog(modulecoBean, message, "Warning", JOptionPane.WARNING_MESSAGE);

	}

	/**
	 * Renvoie le statRecorder de modulecoLauncher.
	 * Mis en place ici pour pouvoir tre rcuperer par la classe
	 * Graphique.java pour pouvoir afficher les donnes.
	 * @return the statRecorder of ModulecoLauncher
	 */
	public StatRecorder getStatRecorder() {
		return modulecoLauncher.getStatRecorder();
	}

	
}
