package modulecoFramework.utils.graphicalWatcher.watchers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;

public class LineChartWatcher extends AbstractChartWatcher implements ReferenceableAgent {

	//List listProbes;
	//Vector vectorProbes;
	
	Map mapProbes;
	Map mapColors;
	
	Vector vectorNames;
	
	Vector values;
	
	int numberOfSeries = 0;
	
	boolean countProbe = false;
	
	int noNameProbe=0;
	
	/**
	 * 
	 *
	 */
	public LineChartWatcher() {
		mapProbes = new HashMap();
		mapColors = new HashMap();
		vectorNames = new Vector();
	}
	
	public void activate() {
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
	}
	
	public void observeAgents() {
		values = new Vector();
		
		if (countProbe) {
			AutoCountMemoryProbe cmp = (AutoCountMemoryProbe) mapProbes.get(vectorNames.get(0));
			cmp.step();
			int nb = cmp.getNbSeries();
			for (int i=0;i<nb;i++) {
				values.add(Double.valueOf(cmp.getLastValue(nb)));
			}
		}
		else {
			for (Iterator i=mapProbes.values().iterator();i.hasNext();) {
				AbstractMemoryProbe mp = (AbstractMemoryProbe) i.next();
				mp.step();
				values.add(Double.valueOf(mp.getLastValue()));
			}
		}
	}
	
	public String getSerieName(int i) {
		if (countProbe) {
			return (String)vectorNames.get(0)+i;
		}
		else {
			return (String)vectorNames.get(i);
		}
	}
	
	/**
	 * 
	 * @param memoryProbe
	 * @param name permit to reference the probe on the Watcher
	 */
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe, String name) {
		this.addProbe(memoryProbe);
		if (memoryProbe instanceof AutoCountMemoryProbe) {
			countProbe = true;
			/* clear other probe */
			vectorNames.clear();
			mapProbes.clear();
			mapColors.clear();
			/* adding this probe */
			vectorNames.add(name);
			mapProbes.put(name, memoryProbe);
			mapColors.put(name, new Color(24,85,96));
			//numberOfSeries = ((CountMemoryProbe)memoryProbe).getNbSeries();
			numberOfSeries = 1;
		}
		else {
			if (countProbe) {
				vectorNames.clear();
				mapColors.clear();
				mapProbes.clear();
				countProbe = false;
			}
			/**
			 * TODO : throw exception existing name for this watcher !!!
			 */
			mapProbes.put(name,memoryProbe);
			mapColors.put(name,new Color(125,22,240));
			vectorNames.add(name);
			numberOfSeries ++;
		}
		memoryProbe.step();
	}
	
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe) {
		this.addMemoryProbe(memoryProbe,"probe"+(noNameProbe++));
	}
	
	
	public void removeMemoryProbe(AbstractMemoryProbe memoryProbe) {
		System.out.println("Try Removing probes : ");
		if (mapProbes.containsValue(memoryProbe)) {
			System.out.println("Removing probes : ");
			String name="";
			Object key=null;
			for (Iterator i=mapProbes.keySet().iterator();i.hasNext();){
				key = i.next();
				if (mapProbes.get(key).equals(memoryProbe)) {
					break;
				}				
			}
			mapProbes.remove(key);
			name = (String) key;
			vectorNames.remove(name);
			if (countProbe) {
				countProbe = false;
				numberOfSeries = 0;
			}
			else {
				numberOfSeries--;
			}
		}
		
	}
	
	public double getLastValue(int numSerie) {
		//return ((Double)values.get(numSerie)).doubleValue();
		if (countProbe) {
			double result = ((AutoCountMemoryProbe)mapProbes.get(vectorNames.get(0))).getLastValue(numSerie);
			System.out.println("\tResult : "+result);
			return result;
		}
		else {
			return ((AbstractMemoryProbe)mapProbes.get(vectorNames.get(numSerie))).getLastValue();
		}
	}
	
	/*public double getValue(int pas, int numSerie) {
		if (countProbe) {
			return ((CountMemoryProbe)vectorProbes.get(0)).getValue(pas);
		}
		else {
			return ((MemoryProbe)vectorProbes.get(numSerie)).getValue(pas);
		}
	}*/

	public int getNumberOfSeries() {
		if (countProbe) {
			return ((AutoCountMemoryProbe)mapProbes.get(vectorNames.get(0))).getNbSeries();
		}
		else {
			return numberOfSeries;
		}
	}

	public void setSerieName(int numSerie, String name) {
		String oldName = (String)vectorNames.get(numSerie);
		AbstractMemoryProbe p = (AbstractMemoryProbe) mapProbes.get(oldName);
		mapProbes.remove(oldName);
		mapProbes.put(name,p);
		vectorNames.add(numSerie,name);
	}
	
	public void setColor(int numSerie, Color color) {
		String name = (String)vectorNames.get(numSerie);
		mapColors.put(name,color);
		System.out.println("setting color to "+color);
	}
	
	public Color getColor(int numSerie) {
		if (countProbe) {
			String name = (String)vectorNames.get(0);
			Color color = (Color)mapColors.get(name);
			return color;
		}
		else {
			String name = (String)vectorNames.get(numSerie);
			Color color = (Color)mapColors.get(name);
			return color;
		}
	}
	
	public void afficher() {
		System.out.println("---------------------------");
		System.out.println("LineChartWatcher :");
		System.out.println("\tvectorNames : ");
		for (int i = 0; i < vectorNames.size(); i++) {
			System.out.println("\t\t"+i+" : "+vectorNames.get(i));
		}
		System.out.println("\tmapProbes : ");
		for (Iterator i=mapProbes.keySet().iterator();i.hasNext();) {
			Object key = i.next();
			System.out.println("\t\t"+key+" : "+mapProbes.get(key));
		}
		
		/*
		System.out.println("\t");
		System.out.println("\t");
		System.out.println("\t");*/
	}

}
