package modulecoFramework.utils.graphicalWatcher.watchers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;

public class AutoCountWatcher extends AbstractChartWatcher implements ReferenceableAgent {

	//List listProbes;
	//Vector vectorProbes;
	
	//Map mapProbes;
	Map mapColors;
	Map mapAfficher;
	
	Vector vectorNames;
	Vector values;
	
	int numberOfSeries = 0;

	int noNameProbe=0;
	
	/** Pour le moment ne peut contenir qu'une probe... */
	AutoCountMemoryProbe countMemoryProbe;
	
	/**
	 * 
	 *
	 */
	public AutoCountWatcher() {
		//mapProbes = new HashMap();
		mapColors = new HashMap();
		mapAfficher = new HashMap();
		vectorNames = new Vector();
		values = new Vector();
	}
	
	public void activate() {
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
	}
	
	public void observeAgents() {
		values = new Vector();
		countMemoryProbe.step();
		/*for (Iterator i=mapProbes.values().iterator();i.hasNext();) {
			MemoryProbe mp = (MemoryProbe) i.next();
			mp.step();
			values.add(Double.valueOf(mp.getLastValue()));
		}*/
	}
	
	public String getSerieName(int i) {
		return (String)vectorNames.get(i);
	}
	
	/**
	 * 
	 * @param memoryProbe
	 * @param name permit to reference the probe on the Watcher
	 */
	public void addMemoryProbe(AutoCountMemoryProbe memoryProbe, String name) {
		
		if (memoryProbe != null) {
			//System.out.println("Adding a count probe : " + memoryProbe.getProperty());
			this.countMemoryProbe = memoryProbe;
			this.addProbe(this.countMemoryProbe);
			this.countMemoryProbe.step();
			for (int i = 0; i < this.countMemoryProbe.getNbSeries(); i++) {
				System.out.println("[AutoCountWatcher] serie name : "+i+" , "+this.countMemoryProbe.getSerieName(i));
				vectorNames.add(i,this.countMemoryProbe.getSerieName(i));
				mapAfficher.put(vectorNames.get(i),new Boolean(true));
				mapColors.put(vectorNames.get(i),new Color(47,250,23));
			}
		}
		
		/*mapProbes.put(name,memoryProbe);
		mapColors.put(name,new Color(125,22,240));
		vectorNames.add(name);
		numberOfSeries ++;
		memoryProbe.step();
		values.add(Double.valueOf(memoryProbe.getLastValue()));*/
	}
	
	public Boolean getAfficher(int row) {
		return (Boolean)mapAfficher.get(vectorNames.get(row));
	}
	
	public void setAfficher(int row, Boolean boolean1) {
		mapAfficher.put(vectorNames.get(row),boolean1);
	}
	
	public void addMemoryProbe(AutoCountMemoryProbe memoryProbe) {
		this.addMemoryProbe(memoryProbe,"probe"+(noNameProbe++));
	}
	
	
	public void removeMemoryProbe(AbstractMemoryProbe memoryProbe) {
		//System.out.println("Try Removing probes : ");
		if (countMemoryProbe.equals(memoryProbe)) {
			countMemoryProbe = null;
		}
		
	}
	
	public double getLastValue(int numSerie) {
		
		double result = countMemoryProbe.getLastValue(numSerie);
		//System.out.println("\tResult for series "+numSerie+" : "+result);
		return result;
		
		//return ((Double)values.get(numSerie)).doubleValue();
		/*if (countProbe) {
			double result = ((CountMemoryProbe)mapProbes.get(vectorNames.get(0))).getLastValue(numSerie);
			System.out.println("\tResult : "+result);
			return result;
		}
		else {*/
			//return ((MemoryProbe)mapProbes.get(vectorNames.get(numSerie))).getLastValue();
		//}*/
		//return ((Double)values.get(numSerie)).doubleValue();
	}
	
	/*public double getValue(int pas, int numSerie) {
		if (countProbe) {
			return ((CountMemoryProbe)vectorProbes.get(0)).getValue(pas);
		}
		else {
			return ((MemoryProbe)vectorProbes.get(numSerie)).getValue(pas);
		}
	}*/

	public int getNumberOfSeries() {
		//System.out.println("Count Watcher - getNumberOfSeries : ");
		if (countMemoryProbe != null) {
			//System.out.println("\tnumberOfSeries : "+countMemoryProbe.getNbSeries());
			return countMemoryProbe.getNbSeries();
		}
		else {
			//System.out.println("\tnumberOfSeries : countMemoryProbe null");
			return 0;
		}
		/*if (countProbe) {
			return ((CountMemoryProbe)mapProbes.get(vectorNames.get(0))).getNbSeries();
		}
		else {*/
			//return numberOfSeries;
		//}
	}

	public void setSerieName(int numSerie, String name) {
		
		String oldName = (String)vectorNames.get(numSerie);
		System.out.println("oldName : " + oldName);
		vectorNames.remove(numSerie);
		vectorNames.add(numSerie, name);
		
		Object o = mapColors.get(oldName);
		mapColors.put(name,o);
		mapColors.remove(oldName);
		
		/*MemoryProbe p = (MemoryProbe) mapProbes.get(oldName);
		mapProbes.remove(oldName);
		mapProbes.put(name,p);
		vectorNames.add(numSerie,name);*/
	}
	
	public void setColor(int numSerie, Color color) {
		String name = (String)vectorNames.get(numSerie);
		mapColors.put(name,color);
		System.out.println("setting color to "+color);
	}
	
	public Color getColor(int numSerie) {
		String name = (String)vectorNames.get(numSerie);
		Color color = (Color)mapColors.get(name);
		return color;
	}
	
	public void afficher() {
		System.out.println("---------------------------");
		System.out.println("LineChartWatcher :");
		System.out.println("\tvectorNames : ");
		
		for (int i = 0; i < vectorNames.size(); i++) {
			System.out.println("\t\t"+i+" : "+vectorNames.get(i));
		}
		/*System.out.println("\tmapProbes : ");
		for (Iterator i=mapProbes.keySet().iterator();i.hasNext();) {
			Object key = i.next();
			System.out.println("\t\t"+key+" : "+mapProbes.get(key));
		}*/
		
		/*
		System.out.println("\t");
		System.out.println("\t");
		System.out.println("\t");*/
	}

}

