package modulecoFramework.utils.graphicalWatcher.probes;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.ConsoleHandler;

public class Filter {

	Map mapPropertyValues;
	Map mapOperator;
	
	Vector vectorConstraints;
	Vector vectorLogicalOperators;
	
	public static int EQUAL = 0;
	public static int INF = 1;
	public static int INF_OR_EQUAL = 2;
	public static int SUP = 3;
	public static int SUP_OR_EQUAL = 4;
	public static int DIFF = 5;
	
	public static String AND = "and";
	public static String OR = "or";
	public static String XOR = "xor";
	public static String AND_NOT = "and not";
	public static String OR_NOT = "or not";
	public static String XOR_NOT = "xor not";
	
	public Filter() {
		
		mapPropertyValues = new HashMap();
		mapOperator = new HashMap();
		vectorConstraints = new Vector();
		vectorLogicalOperators = new Vector();
		
	}
	
	public void addConstraints(String property, Object value, int op, String logicalOperator) {
		if (op < 0 || op > 5) {
			throw new IllegalArgumentException("Operator not valid : it must be between 0 and 5");
		}
		if ( logicalOperator == null && vectorConstraints.size() !=0 ) {
			throw new IllegalArgumentException("Only the first logicalOperator can be null !");
		}
		System.out.println("adding a constraints with logical operator at : "+logicalOperator);
		vectorConstraints.add(new PropertyFilter(property,op,value));
		vectorLogicalOperators.add(logicalOperator);
		System.out.println("taille de vectorOperators");
		mapPropertyValues.put(property, value);
		mapOperator.put(property, new Integer(op));
	}

	protected boolean respectConstraints(Object val, PropertyFilter pf) {
		if (pf.getOp() == Filter.EQUAL) {
			if (! val.equals(pf.getValue())) {
				return false;
			}
		}
		else if (pf.getOp() == Filter.DIFF) {
			if (val.equals(pf.getValue())) {
				return false;
			}
		}
		else if (pf.getOp() == Filter.INF && val instanceof Comparable) {
			Comparable comp = (Comparable) val;
			if (comp.compareTo(pf.getValue()) >= 0) {
				return false;
			}
		}
		else if (pf.getOp() == Filter.INF_OR_EQUAL && val instanceof Comparable) {
			Comparable comp = (Comparable) val;
			if (comp.compareTo(pf.getValue()) > 0) {
				return false;
			}
		}
		else if (pf.getOp() == Filter.SUP && val instanceof Comparable) {
			Comparable comp = (Comparable) val;
			if (comp.compareTo(pf.getValue()) <= 0) {
				return false;
			}
		}
		else if (pf.getOp() == Filter.SUP_OR_EQUAL && val instanceof Comparable) {
			Comparable comp = (Comparable) val;
			if (comp.compareTo(pf.getValue()) < 0) {
				return false;
			}
		}
		return true;
	}
	
	public boolean isValide(Object o) {
		
		//System.out.println("isValide...");
		
		boolean valide = true;
		
		for (int i = 0; i < vectorConstraints.size(); i++) {
			PropertyFilter pf = (PropertyFilter) vectorConstraints.get(i);
			Object val;
			try {
				
				Field field = o.getClass().getField(pf.getProperty());
				val = field.get(o);
				
				boolean rc = respectConstraints(val, pf);
				
				if (vectorLogicalOperators.get(i) != null) {
					//System.out.println("LogicalOperator not null !!");
					if ("and".equals(vectorLogicalOperators.get(i))) {
						valide = valide && rc;
					}
					else if ("or".equals(vectorLogicalOperators.get(i))) {
						valide = valide || rc;
					}
					else if ("xor".equals(vectorLogicalOperators.get(i))) {
						valide = (!valide && rc) || (valide && !rc);
					}
					if ("and not".equals(vectorLogicalOperators.get(i))) {
						System.out.println(valide+" and not "+rc);
						valide = valide && !rc;
					}
					else if ("or not".equals(vectorLogicalOperators.get(i))) {
						valide = valide || !rc;
					}
					else if ("xor not".equals(vectorLogicalOperators.get(i))) {
						valide = (!valide && !rc) || (valide && rc);
					}
				}
				else {
					valide = rc;
					//System.out.println("LogicalOperator null !!");
				}
				
				/*System.out.println("----------------------------");
				System.out.println("["+val.getClass()+"] : "+val);
				System.out.println("<"+pf.getOp()+">");
				System.out.println("["+pf.getValue().getClass()+"] : "+pf.getValue());*/
				
				/*if (pf.getOp() == Filter.EQUAL) {
					if (! val.equals(pf.getValue())) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.DIFF) {
					if (val.equals(pf.getValue())) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.INF && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) >= 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.INF_OR_EQUAL && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) > 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.SUP && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) <= 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.SUP_OR_EQUAL && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) < 0) {
						valide = false;
					}
				}
				//System.out.println("-->" + valide);*/
				
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (NoSuchFieldException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		
		return valide;
	}
	
	public boolean isValideSave(Object o) {
		
		//System.out.println("isValide...");
		
		boolean valide = true;
		
		for (int i = 0; i < vectorConstraints.size(); i++) {
			PropertyFilter pf = (PropertyFilter) vectorConstraints.get(i);
			Object val;
			try {
				
				Field field = o.getClass().getField(pf.getProperty());
				val = field.get(o);
				
				/*System.out.println("----------------------------");
				System.out.println("["+val.getClass()+"] : "+val);
				System.out.println("<"+pf.getOp()+">");
				System.out.println("["+pf.getValue().getClass()+"] : "+pf.getValue());*/
				
				if (pf.getOp() == Filter.EQUAL) {
					if (! val.equals(pf.getValue())) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.DIFF) {
					if (val.equals(pf.getValue())) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.INF && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) >= 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.INF_OR_EQUAL && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) > 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.SUP && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) <= 0) {
						valide = false;
					}
				}
				else if (pf.getOp() == Filter.SUP_OR_EQUAL && val instanceof Comparable) {
					Comparable comp = (Comparable) val;
					if (comp.compareTo(pf.getValue()) < 0) {
						valide = false;
					}
				}
				//System.out.println("-->" + valide);
				
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchFieldException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		return valide;
	}

	public void addConstraints(String property, int i, int op, String logicalOperator) {
		this.addConstraints(property, new Integer(i), op, logicalOperator);
	}
	
	public void afficher() {
		System.out.println("Filter : ");
		
		for (int i = 0; i < vectorConstraints.size(); i++) {
			PropertyFilter pf = (PropertyFilter) vectorConstraints.get(i);
			System.out.println(pf.getProperty()+" <"+pf.getOp()+"> "+pf.getValue() +
					" ["+pf.getValue().getClass()+"]");
		}
	}

	public int getNbFiltres() {
		return vectorConstraints.size();
	}
	
	public String getProperty(int row) {
		return ((PropertyFilter)vectorConstraints.get(row)).getProperty();
	}
	
	public int getOp(int row) {
		return ((PropertyFilter)vectorConstraints.get(row)).getOp();
	}
	
	public Object getValue(int row) {
		return ((PropertyFilter)vectorConstraints.get(row)).getValue();
	}
	
	public void setProperty(int row, String property) {
		((PropertyFilter)vectorConstraints.get(row)).setProperty(property);
	}
	
	public void setOp(int row, int op) {
		((PropertyFilter)vectorConstraints.get(row)).setOp(op);
	}
	
	public void setValue(int row, Object value) {
		((PropertyFilter)vectorConstraints.get(row)).setValue(value);
	}
	
	public String getLogicalOperator(int i) {
		return (String) vectorLogicalOperators.get(i);
	}
	
	public void removeConstraints(int row) {
		vectorConstraints.remove(row);
		vectorLogicalOperators.remove(row);
	}
	
	public class PropertyFilter {
		
		String property;
		int op;
		Object value;
		
		public PropertyFilter(String property, int op, Object value) {
			this.property = property;
			this.op = op;
			this.value = value;
		}

		public int getOp() {
			return op;
		}

		public void setOp(int op) {
			this.op = op;
		}

		public String getProperty() {
			return property;
		}

		public void setProperty(String property) {
			this.property = property;
		}

		public Object getValue() {
			return value;
		}

		public void setValue(Object value) {
			this.value = value;
		}
		
		/*public Object clone() {
			PropertyFilter pf = new PropertyFilter(new String(this.property),op,((Cloneable)value).);
		}*/
		
	}

	public void setLogicalOperator(int row, String string) {
		
		vectorLogicalOperators.remove(row);
		vectorLogicalOperators.add(row,string);
		
	}
	
	/*public Object clone() {
		Filter filter = new Filter();
		for (int i = 0; i < vectorConstraints.size(); i++) {
			
			filter.addConstraints()
		}
		return filter;
	}*/
	
}
