/*
*  
* Copyright (C) 2000-2004 Fabien Michel
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package modulecoFramework.simulation.scheduling;

import java.util.*;

/** The SimEvent class

  @author Fabien MICHEL
  @version 0.5 01/02/2004 */

public class SimEvent implements Comparable
{
	double occurrenceDate;
	Object source;//the source of the event, most of the time it is an activator
        Object content;//high level information, "which agent to activate" for instance
	
	public SimEvent(Object source, double occurrenceDate)
	{
            this(source,occurrenceDate,null);
	}
	
	public SimEvent(Object source, double occurrenceDate, Object content)
	{
		this.source=source;
		this.occurrenceDate = occurrenceDate;
                this.content=content;
	}
	
	public double getOccurrenceDate()
	{
		return occurrenceDate;
	}
        
        public Object getSource(){
            return source;
        }
	
	public int compareTo(Object o)
	{
		SimEvent se = (SimEvent) o; //crash is good here for debugging purpuse
		if(se.occurrenceDate > occurrenceDate)
			return -1;
		if (se.occurrenceDate < occurrenceDate)
			return 1;
		if(se.source instanceof ModulecoActivator) 
		{
			int priority1 = ((ModulecoActivator) source).getIndex(); //crash is good here for debugging purpuse
			int priority2 = ((ModulecoActivator) se.source).getIndex();
			if(priority1 < priority2)
				return -1;
			if(priority1 > priority2)
				return 1;
		}
                //warning
		return 0;
	}
	
	public boolean equals(Object o)
	{
		SimEvent se = (SimEvent) o; //crash is good here for debugging purpuse
		if(content.equals(se.content) && source.equals(se.source) && occurrenceDate == se.occurrenceDate)
			return true;
		return false;
	}
	
	public String toString()
	{
		return "<"+source+","+occurrenceDate+">";
	}

    public Object getContent() {
        return content;
    }
    
}