/*
 * Source File Name: discreteChoice.World.java Copyright: Copyright
 * (c)enst-bretagne @author : Denis.Phan@enst-bretagne.fr
 * 
 * @version 1.4 February, 2004
 */
package models.yves;

import java.util.ArrayList;
import java.util.Iterator;

import cern.jet.random.Normal;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

import modulecoFramework.modeleco.ENeighbourWorld;

/**
 * 
 *  
 */
public class World extends ENeighbourWorld { //ENeighbourSmallWorld
	
	
	/**
	 * trace : boolen indiquant si l'on doit afficher les traces de world
	 */
	public boolean trace = true;
	
	/** 
	 * gain1 : gain affect  la norme 1
	 * gain2 : gain affect  la norme 2
	 * 
	 */
	public int gain1;
	public int gain2;
	
	/**
	 * Reprsente les taux de participation initial
	 * aux normes 1 et 2;
	 */
	public double tauxParticipationInitNorme1;
	public double tauxParticipationInitNorme2;
	
	/**
	 * Reprsente taux de participation au moment t
	 * compris entre 0 et 1
	 */
	public double tauxParticipationNorme1;
	public double tauxParticipationNorme2;
	
	public World() {
		
		super();
		this.trace("[World()]");

		gain1 = 10;
		gain2 = 10;
		
		tauxParticipationInitNorme1 = 0.5;
		tauxParticipationInitNorme2 = 0.5;
		
		inputParameters = new String[] {"tauxParticipationInitNorme1","tauxParticipationInitNorme2","gain1","gain2"};
		outputParameters = new String[] {"tauxParticipationNorme1","tauxParticipationNorme2"};
		outputGraphics = new String[] {"Canevas"};
		
	}
	
	
	/**
	 * getInfo() receieve Info from the Eworld Before connection and
	 * initialisation
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 *  
	 */
	public void getInfo() {
		//System.out.println("discreteChoice.World.getInfo");
	}
	
	/**
	 * setDefaultValues() :
	 * Fixe les valeurs par defaut du Monde
	 */
	public void setDefaultValues() {
	}
	
	/**
	 * populate()
	 */
	/*public void populate() {
		this.trace("[World.populate()]");
		super.populate();
	}*/

	/**
	 * connect()
	 *  
	 */
	/*public void connect() {
		this.trace("[World.connect()]");
		super.connect(); // ENeighbourWorld.connect()
	}*/
	
	/**
	 * init()
	 */
	public void init() {
		
		this.trace("[World.init()]");
		super.init();
		
		tauxParticipationNorme1 = tauxParticipationInitNorme1;
		tauxParticipationNorme2 = tauxParticipationInitNorme2;
		
	}
	
	/**
	 * commit()
	 */
	public void commit() {
		this.trace("[World.commit()]");
	}
	
	public void compute() {
		this.trace("[World.compute()]");
		super.compute();
		this.calculerTauxParticipation();
	}
	
	
	/**
	 * Calcul les taux de participation aux normes 1 et 2
	 */
	private void calculerTauxParticipation() {
		
		int nb=0;
		for (Iterator i = iterator();i.hasNext();) {
			int state = ((Agent)i.next()).getAgentState();
			if (state == 1) {
				nb++;
			}
		}
		this.tauxParticipationNorme1 = (double)nb / (double)agentSet.size();
		this.tauxParticipationNorme2 = 1.0 - this.tauxParticipationNorme1;
		
	}
	
	//====================================================
	public Object getState() {
		return new Boolean(true);
	}
	
	public void trace(String s) {
		if (trace) {
			System.out.println(s);
		}
	}


	public int getGain1() {
		return gain1;
	}


	public void setGain1(int gain1) {
		this.gain1 = gain1;
	}


	public int getGain2() {
		return gain2;
	}


	public void setGain2(int gain2) {
		this.gain2 = gain2;
	}


	public double getTauxParticipationInitNorme1() {
		return tauxParticipationInitNorme1;
	}


	public void setTauxParticipationInitNorme1(double tauxParticipationInitNorme1) {
		this.tauxParticipationInitNorme1 = tauxParticipationInitNorme1;
	}


	public double getTauxParticipationInitNorme2() {
		return tauxParticipationInitNorme2;
	}


	public void setTauxParticipationInitNorme2(double tauxParticipationInitNorme2) {
		this.tauxParticipationInitNorme2 = tauxParticipationInitNorme2;
	}


	public double getTauxParticipationNorme1() {
		return tauxParticipationNorme1;
	}


	public void setTauxParticipationNorme1(double tauxParticipationNorme1) {
		this.tauxParticipationNorme1 = tauxParticipationNorme1;
	}


	public double getTauxParticipationNorme2() {
		return tauxParticipationNorme2;
	}


	public void setTauxParticipationNorme2(double tauxParticipationNorme2) {
		this.tauxParticipationNorme2 = tauxParticipationNorme2;
	}

	
	

}



