/** class MyOwnDiscreteChoice.Agent.java
 * Title:        Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author Thibaud Roussillat
 * @version 1.0 - 5 Avril 2005
 */

package models.yves;

import java.util.Iterator;
import java.util.ArrayList;
import java.util.Random;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.randomeco.JavaGaussian;
import modulecoFramework.modeleco.randomeco.RandomSD;

public class Agent extends EAgent {
	
	/**
	 * State est l'tat actuel de l'agent
	 * 1 : participe  la norme 1
	 * 2 : participe  la norme 2
	 */
	public int state;
	
	/**
	 * newState est le nouvel tat de l'agent calcul avant le commit
	 * 1 : participe  la norme 1
	 * 2 : participe  la norme 2
	 */
	protected int newState;

	/**
	 * Indique si on doit tracer l'agent ou pas...
	 */
	protected boolean trace = true;
	
	protected World world;
	
	public Agent() {
		super();
		
		this.trace("[Agent("+this.agentID+")]");
		
		inputParameters = new String[0];
		outputParameters = new String[] {"state"};
		
	}
	
	//Part I - Initialisation of the agent =================
	/**
	* getInfo()
	* receieve Info from the Eworld Before connection and initialisation
	* @see modulecoFramework.modeleco.ENeighbourWorld
	*
	*/
	public void getInfo() {
	}
	
	/**
	* init()
	*/
	public void init() {
		//this.trace("[Agent().init]");

		this.trace("[Agent().init] : "+agentID);
		
		world = (World) this.getWorld();
		
		if (Math.random() < world.getTauxParticipationInitNorme1()) {
			state = 1;
		}
		else {
			state = 2;
		}
		
	}
	

	// Part II - Agent's computations
	
	/**
	 * compute()
	 * ici : 
	 * T1 = N1 / (N1 + N2)
	 * T2 = N2 / (N1 + N2)
	 * 
	 */
	public void compute() {
		//trace("--------------------------------");
		trace("[Agent.compute()] : " + this.agentID);
		
		double G1 = world.getGain1();
		double G2 = world.getGain2();
		double T1 = world.getTauxParticipationNorme1();
		double T2 = world.getTauxParticipationNorme2();
		
		double C1 = G1*T1;
		double C2 = G2*T2;
		
		if ( C1 == C2 ) {
			newState = state;
		}
		else if ( C1 > C2) {
			newState = 1;
		}
		else {
			newState = 2;
		}
		
		System.out.println("\t" + T1 + " , " + T2 + " : " + newState);
	}

	/**
	*commit()
	*/
	public void commit() {
		
		//trace("[Agent.commit()] : " + this.agentID);
		state = newState;

	}
	
	
	// Part III - Data Exchanges =================
	
	/**
	 * Return stable state (Competitor number)
	 * methode call from XXX at each Canevas update (including between iterations)
	 */ 
	public Object getState() {
		return new Boolean(state == 1 ? true : false);
	}

	public String toString() {
		return (new Integer(state)).toString();
	}

	/**
	 * getConnectivity()
	 * @return la connectivit de l'agent c'est  dire le nombre de "relation" qu'il a
	 */
	public int getConnectivity() {
		
		connectivity = neighbours.size();
		return connectivity;

	}
	
	public void trace(String s) {
		if (trace) {
			System.out.println(s);
		}
      }

	/**
	 * @return
	 */
	public boolean getBooleanState() {
		return (state == 1);
	}

	public int getAgentState() {
		return state;
	}
	/**
	 * @param state The state to set.
	 */
	public void setState(int state) {
		this.state = state;
	}
}