/** class explorationExploitation.World
 * Title:        Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author denis.phan@enst-bretagne.fr, antoine.beugnard@enst-bretagne.fr,
 * @version 1.2  august,5, 2002
 */
package models.explorationExploitation;
import java.util.Iterator;
import java.util.ArrayList;
import java.lang.reflect.Constructor;
import java.awt.Color;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.ENeighbourWorld;
import modulecoFramework.medium.Medium;
import modulecoFramework.modeleco.randomeco.CRandomDouble;
//directly adressed in method : setRandom_s(String s)
import modulecoGUI.grapheco.descriptor.IntegerDataDescriptor;
import modulecoGUI.grapheco.descriptor.DoubleDataDescriptor;
import modulecoGUI.grapheco.descriptor.ChoiceDataDescriptor;
import modulecoGUI.grapheco.descriptor.InfoDescriptor;
import modulecoGUI.grapheco.descriptor.LongDataDescriptor;
//import modulecoGUI.grapheco.descriptor.BooleanDataDescriptor;
import modulecoGUI.grapheco.statManager.Var;
/**
 *  
 */
public class World extends ENeighbourWorld {
	/**
	 * Initial values for the 4 basic parameters of this world <br>
	 * parameter 1: world size <br>
	 * parameter 2: neighbourhood type <br>
	 * parameter 3: active zone type <br>
	 * parameter 4: scheduler type <br>
	 */
	public static String initLength = "30";
	public static String initNeighbour = "Empty";
	public static String initZone = "RandomIndividual";
	public static String initScheduler = "EarlyCommitScheduler";
	/**
	 *  
	 */
	protected int nbSellers;
	protected double mu;
	protected double Distance;
	protected double Dis;
	protected double Gains;
	protected double MaxRentabilite;
	protected double MaxPrix;
	protected double Prix;
	protected double Ve;
	protected double coeffa;
	protected double coeffb;
	protected int endOfGame;
	protected CRandomDouble random;
	protected long seed;
	protected String random_s;
	protected String distribution_pop;
	protected String distribution_pop_vendeur;
	protected double Ve_vendeur;
	protected double coeffa_vendeur;
	protected double coeffb_vendeur;
	protected double mu_vendeur;
	private static String randomPath = "modulecoFramework.modeleco.randomeco.";
	protected Color colors[];
	protected boolean hack = true;
	//trick to avoid an infinite recurvive call to setNbSellers
	public int distribution[];
	public double distributionD[];
	/**
	 * @param length
	 */
	public World(int length) {
		super(length);
	}
	/*
	 * World.getInfo()invoqued by : EWorld before setDefaultValue() condition
	 * displayXgraphics = true is needed for to exhibit 4graphics on the
	 * rightRepresentation
	 */
	public void getInfo() {
	}
	public void populate() {
		super.populate();
		//System.out.println(" world.populate()DEBUT");
		extraAgents = new Seller[nbSellers];
		for (int i = 0; i < nbSellers; i++) {
			extraAgents[i] = new Seller(i);
			//System.out.println("extra agent "+extraAgents[i]);
			((EAgent) extraAgents[0]).setWorld(this);
			extraAgents[i].getInfo();
		}
		// setup the neighbourhood settlement
		// initialize market
		mediumsInWorld = new Medium[1];
		mediumsInWorld[0] = new Market();
		//System.out.println(" world.populate()FIN");
	}
	public void connect() {
		// connect the Neighbourhood
		super.connect(); // ENeighbourWorld.connect()
		for (Iterator i = iterator(); i.hasNext();) {
			getMarket().attach(((Agent) i.next()), "customer");
			//((Agent)i.next()).setMarket(market);
		}
		for (int i = 0; i < nbSellers; i++) { // create competitors = new agents
			// (out of the array)
			getMarket().attach(extraAgents[i], "seller");
			// connect competitor to market
		}
		//System.out.println(" world.connect() ");
	}
	public void commit() {
		super.commit();
		/*
		 * for (int i =0; i < nbSellers; i++) ((Seller)
		 * extraAgents[i]).setDemand(getMarket().getDemand(i),i);
		 */
		//getMarket().marketClear();
		//System.out.println(" world.commit() ");
		MaxRentabilite = 0;
		for (int k = 0; k < 11; k++) {
			double e = k * getRepartitionReelle(k) / 10;
			if (e > MaxRentabilite) {
				MaxRentabilite = e;
				MaxPrix = (double) 10 * k;
			}
		}
		/*
		 * for (Iterator i=iterator();i.hasNext();) { A=(Agent)i.next(); for
		 * (int k=0; k <11 ; k++) { if (A.choix[k]) r[k] = r[k] +1 ;} } for (int
		 * k=0; k <11 ; k++) { System.out.println(" r"+k+" "+r[k]);}
		 */
	}
	public void init() {
		//System.out.println(" world.init()");
		colors = new Color[11];
		colors[0] = Color.yellow.brighter(); // don't buy
		colors[1] = Color.blue; // Seller 1
		colors[2] = Color.red; // Seller 2
		colors[3] = Color.green; // Seller 3
		colors[4] = Color.magenta; // Seller 4
		colors[5] = Color.darkGray; // Seller 5
		colors[6] = Color.cyan; // Seller 6
		colors[7] = Color.yellow; // Seller 7
		colors[8] = Color.gray; // Seller 8
		colors[9] = Color.orange; // Seller 9
		colors[10] = Color.pink; // Seller 10
		setSeed(seed);
		distribution = new int[11];
		distributionD = new double[11];
		distribution_pop = getDistribution_pop();
		//System.out.println(distribution_pop);
		//distribution[0] = 924; distribution[1] = 901; distribution[2] = 894;
		// distribution[3] = 894;
		//distribution[4] = 909; distribution[5] = 901; distribution[6] = 659;
		// distribution[7]= 591;
		//distribution[8] = 538; distribution[9] = 515; distribution[10] = 121;
		int ws = getAgentSetSize();
		if (distribution_pop.equalsIgnoreCase("Experimental")) {
			distribution[0] = 924;
			distribution[1] = 901;
			distribution[2] = 894;
			distribution[3] = 894;
			distribution[4] = 909;
			distribution[5] = 901;
			distribution[6] = 659;
			distribution[7] = 591;
			distribution[8] = 538;
			distribution[9] = 515;
			distribution[10] = 121;
			repartitionExperimentale();
		}
		if (distribution_pop.equalsIgnoreCase("Linear")) {
			//coeffa=-0.1;
			//coeffb=1;
			for (int k = 0; k < 11; k++) {
				distributionD[k] = coeffa * k + coeffb;
			}
			repartition();
		}
		if (distribution_pop.equalsIgnoreCase("Logistic")) {
			//V=1;
			//mu=1;
			for (int k = 0; k < 11; k++) {
				distributionD[k] = 1 / (1 + Math.exp((k - Ve) / mu));
				//System.out.println("kgjkdsjgelkjrgkjerlsjflsj"+distributionD[k]);
			}
			repartition();
		}
		Agent A;
		int r[];
		r = new int[11];
		for (Iterator i = iterator(); i.hasNext();) {
			A = (Agent) i.next();
			for (int k = 0; k < 11; k++) {
				if (A.choix[k])
					r[k] = r[k] + 1;
			}
		}
		double v = 0;
		MaxPrix = 0;
		MaxRentabilite = 0;
		for (int k = 0; k < 11; k++) {
			v = k * getRepartitionReelle(k) / 10;
			if (v > MaxRentabilite) {
				MaxRentabilite = v;
				MaxPrix = (double) 10 * k;
			}
			//System.out.println(" r"+k+" "+k*10*r[k]/getCapacity());
		}
		try {
			//statManager.add(new CalculatedVar("Viability Average",
			// modulecoFramework.Moduleco.getClass(this.pack() +
			// ".Agent").getMethod("getGraphicViability", null),
			// CalculatedVar.AVERAGE, null));
			//statManager.add(new CalculatedVar("Viability Minimum",
			// modulecoFramework.Moduleco.getClass(this.pack() +
			// ".Agent").getMethod("getGraphicViability", null),
			// CalculatedVar.MINIMUM, null));
			statManager.add(new Var("Gains", modulecoFramework.Moduleco.getClass(
					this.pack() + ".World").getMethod("getGains", null)));
			statManager.add(new Var("Prix", modulecoFramework.Moduleco.getClass(
					this.pack() + ".World").getMethod("getPrix", null)));
			statManager.add(new Var("MaxRentabilite", modulecoFramework.Moduleco.getClass(
					this.pack() + ".World")
					.getMethod("getMaxRentabilite", null)));
			statManager.add(new Var("MaxPrix", modulecoFramework.Moduleco.getClass(
					this.pack() + ".World").getMethod("getMaxPrix", null)));
			//statManager.add(new Var("Dis", modulecoFramework.Moduleco.getClass(this.pack() +
			// ".World").getMethod("getDis", null)));
		} catch (ClassNotFoundException e) {
			/* System.out.println( */
			e.printStackTrace(); // toString());
		} catch (NoSuchMethodException e) {
			//System.out.println(e.toString());
		}
		/*
		 * for (int i =0; i < nbSellers; i++) { try{ statManager.add(new
		 * CalculatedVar("Seller"+(i+1), modulecoFramework.Moduleco.getClass(this.pack() +
		 * ".Agent").getMethod("getState", null), CalculatedVar.NUMBER, new
		 * Integer(i+1))); }
		 * 
		 * catch (ClassNotFoundException e){ System.out.println(e.toString()); }
		 * 
		 * catch (NoSuchMethodException e){ System.out.println(e.toString()); } }
		 * try{ statManager.add(new CalculatedVar("Seller0",
		 * modulecoFramework.Moduleco.getClass(this.pack() + ".Agent").getMethod("getBooleanState",
		 * null), CalculatedVar.NUMBER, new Boolean(true))); }
		 * 
		 * catch (ClassNotFoundException e){ System.out.println(e.toString()); }
		 * 
		 * catch (NoSuchMethodException e){ System.out.println(e.toString()); } }
		 */
	}
	public void repartition() {
		Agent A;
		boolean e;
		double z;
		for (Iterator i = iterator(); i.hasNext();) {
			A = (Agent) i.next();
			z = random.getDouble();
			for (int k = 0; k < 11; k++) {
				e = false;
				if (z < distributionD[k])
					e = true;
				A.setChoix(k, e);
				//System.out.println(" Prix " + k);
				//System.out.println(" Z " + z);
			}
		}
	}
	public void repartitionExperimentale() {
		Agent A;
		boolean e;
		int z;
		for (Iterator i = iterator(); i.hasNext();) {
			A = (Agent) i.next();
			for (int k = 0; k < 11; k++) {
				z = new Double(random.getDouble() * 999).intValue();
				e = false;
				if ((1 + z) < distribution[k])
					e = true;
				A.setChoix(k, e);
				//System.out.println(" Prix " + k);
				//System.out.println(" Z " + z);
			}
		}
	}
	public Color[] getColors() {
		return colors;
	}
	public Object getState() {
		return new Boolean(true);
	}
	public int getEndOfGame() {
		return endOfGame;
	}
	public int getNbSellers() {
		//System.out.println(" world.getNbSellers() ");
		return nbSellers;
	}
	public int getDistribution(int prix) {
		//System.out.println(" world.getNbSellers() ");
		return distribution[prix];
	}
	/**
	 * method call by agent.init() & competitor.int() (?double emploi ? -> M+N
	 * appels avant CAgent.init() juste aprs word populate ?N= nbAgents
	 * M=nbExtraAgents?)
	 */
	public Market getMarket() {
		//System.out.println(" world.getMarket() ");
		return (Market) mediumsInWorld[0];
	}
	public Seller getSeller() {
		//System.out.println(" world.getMarket() ");
		return (Seller) extraAgents[0];
	}
	public ArrayList getDescriptors() {
		//System.out.println(" getdescriptors");
		descriptors.clear();
		descriptors.add(new IntegerDataDescriptor(this, "NbSellers",
				"nbSellers", nbSellers, true));
		//descriptors.add(new
		// DoubleDataDescriptor(this,"alpha","alpha",alpha,true,3));
		//descriptors.add(new
		// BooleanDataDescriptor(this,"proportion","proportion",proportion,true));
		descriptors.add(new ChoiceDataDescriptor(this, "Random", "random_s",
				new String[]{"Default", "JavaRandom", "JavaGaussian"},
				random_s, true));
		descriptors.add(new LongDataDescriptor(this, "Seed", "seed", seed,
				true, 3));
		descriptors.add(new InfoDescriptor("No data"));
		descriptors.add(new IntegerDataDescriptor(this, "End of Game",
				"endOfGame", endOfGame, true));
		//descriptors.add(new InfoDescriptor(""));
		descriptors.add(new ChoiceDataDescriptor(this,
				"Population Distribution", "distribution_pop", new String[]{
						"Experimental", "Logistic", "Linear"},
				distribution_pop, true));
		descriptors
				.add(new DoubleDataDescriptor(this, "Ve", "Ve", Ve, true, 3));
		descriptors
				.add(new DoubleDataDescriptor(this, "mu", "mu", mu, true, 3));
		//descriptors.add(new InfoDescriptor(""));
		//descriptors.add(new InfoDescriptor(""));
		descriptors.add(new DoubleDataDescriptor(this, "coeffa", "coeffa",
				coeffa, true, 3));
		descriptors.add(new DoubleDataDescriptor(this, "coeffb", "coeffb",
				coeffb, true, 3));
		descriptors.add(new InfoDescriptor("Vendeur"));
		descriptors.add(new ChoiceDataDescriptor(this, "Population A priori",
				"distribution_pop_vendeur", new String[]{"Experimental",
						"Logistic", "Linear"}, distribution_pop_vendeur, true));
		descriptors.add(new DoubleDataDescriptor(this, "Ve", "Ve_vendeur",
				Ve_vendeur, true, 3));
		descriptors.add(new DoubleDataDescriptor(this, "mu", "mu_vendeur",
				mu_vendeur, true, 3));
		//descriptors.add(new InfoDescriptor(""));
		//descriptors.add(new InfoDescriptor(""));
		descriptors.add(new DoubleDataDescriptor(this, "coeffa",
				"coeffa_vendeur", coeffa_vendeur, true, 3));
		descriptors.add(new DoubleDataDescriptor(this, "coeffb",
				"coeffb_vendeur", coeffb_vendeur, true, 3));
		return descriptors;
	}
	public void setDistribution_pop(String s) {
		distribution_pop = s;
	}
	public String getDistribution_pop() {
		return distribution_pop;
	}
	public void setVe(double v) {
		Ve = v;
	}
	public double getVe() {
		return Ve;
	}
	public double getMu() {
		return mu;
	}
	public void setMu(double m) {
		mu = m;
	}
	public void setCoeffa(double a) {
		coeffa = a;
	}
	public double getCoeffa() {
		return coeffa;
	}
	public void setCoeffb(double b) {
		coeffb = b;
	}
	public double getCoeffb() {
		return coeffb;
	}
	public void setDistribution_pop_vendeur(String s) {
		distribution_pop_vendeur = s;
	}
	public String getDistribution_pop_vendeur() {
		return distribution_pop_vendeur;
	}
	public String getdistribution_pop_vendeur() {
		return distribution_pop_vendeur;
	}
	public void setVe_vendeur(double v) {
		Ve_vendeur = v;
	}
	public double getVe_vendeur() {
		return Ve_vendeur;
	}
	public double getve_vendeur() {
		return Ve_vendeur;
	}
	public double getMu_vendeur() {
		return mu_vendeur;
	}
	public void setMu_vendeur(double m) {
		mu_vendeur = m;
	}
	public double getmu_vendeur() {
		return mu_vendeur;
	}
	public void setCoeffa_vendeur(double a) {
		coeffa_vendeur = a;
	}
	public double getCoeffa_vendeur() {
		return coeffa_vendeur;
	}
	public double getcoeffa_vendeur() {
		return coeffa_vendeur;
	}
	public void setCoeffb_vendeur(double b) {
		coeffb_vendeur = b;
	}
	public double getCoeffb_vendeur() {
		return coeffb_vendeur;
	}
	public double getcoeffb_vendeur() {
		return coeffb_vendeur;
	}
	public void setDefaultValues() {
		setNbSellers(1);
		setRandom_s("JavaRandom");
		seed = 10;
		distribution = new int[11];
		endOfGame = 1000;
		//System.out.println(" setdefaultvalue ");
		setDistribution_pop("Experimental");
		setVe(7);
		setMu(1);
		setCoeffa(-0.08);
		setCoeffb(1);
		setDistribution_pop_vendeur("Experimental");
		setVe_vendeur(7);
		setMu_vendeur(1);
		setCoeffa_vendeur(-0.08);
		setCoeffb_vendeur(1);
	}
	public void setEndOfGame(int j) {
		endOfGame = j;
	}
	public void setNbSellers(int j) {
		//System.out.println("setNbSellers");
		nbSellers = j;
		//if (hack) {// first call. It **is** a NbSellers change
		//restart();
		//}
		//hack = ! hack;
	}
	public void setSeed(long d) {
		seed = d;
		//System.out.println("Seed : "+seed);
		setRandom_s(random_s); //sinon on cree un random a chaque fois...
		//On ne peut modifier la graine qu'au debut d'une simulation,
		//pas en cours de simulation.
	}
	public void setRandom_s(String s) {
		random_s = s;
		try {
			Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + random_s)
					.getConstructor(new Class[]{long.class});
			random = (CRandomDouble) constructor
					.newInstance(new Object[]{new Long(seed)});
		} catch (Exception e) {
			//System.out.println(e.toString());
		}
		for (Iterator i = iterator(); i.hasNext();)
			((Agent) i.next()).setRandom(random);
	}
	public double getDistance() {
		Distance = 2;
		return Distance;
	}
	public double getGains() {
		Gains = ((Seller) extraAgents[0]).getGains();
		//Gains=2;
		return Gains;
	}
	public double getMaxRentabilite() {
		//Gains=2;
		return MaxRentabilite;
	}
	public double getMaxPrix() {
		//Gains=2;
		return MaxPrix;
	}
	public double getPrix() {
		Prix = ((Market) mediumsInWorld[0]).sendPrice();
		// ou((Seller) extraAgents[0]).getPrix();
		return 10 * Prix;
	}
	public double getDis() {
		Dis = 6.4;
		return Dis;
	}
	public int getRepartition(int prix) {
		int resultat = 0;
		if (distribution_pop.equalsIgnoreCase("Experimental")) {
			resultat = (int) (distribution[prix] / 10);
			//distribution initiale sur 1000 individu
		} else {
			resultat = (int) (100 * distributionD[prix]);
			//distri initiale en proba
		}
		return resultat;
	}
	public double getRepartitionReelle(int prix) {
		Agent A;
		int resultat = 0;
		for (Iterator i = iterator(); i.hasNext();) {
			A = (Agent) i.next();
			if (A.choix[prix])
				resultat = resultat + 1;
		}
		resultat = (int) ((100 * resultat) / (getAgentSetSize()));
		//System.out.println("capa "+getCapacity());
		return resultat;
	}
}