/*
* mobileAgent.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2004 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;
/** The main MadKit mobileAgent class. Provides support for non threaded agent
 * lifecycle, messaging, graphical interface, group and roles
 * management, agent information, ...
 *
 * The agent behavior intentionnaly is *not* defined. It is up to the
 * agent developer to choose an agent model or to develop his specific
 * agent library on top of the facilities provided by MadKit. However,
 * all agent share the same organizational view, and the basic
 * messaging code, so integration of agent coming from different
 * developer and having heterogeneous models is quite easy.
 *
 * Agent-related methods (almost everything here) can invoked only
 * after registration in the kernel (i.e. after the activate() method has been called
 * on this agent). That means that you should not use any of the agent methods in
 * constructor
 *
  @author Mansour Saber

 */
	import 	java.lang.*;
	import  java.util.Vector ;
	import madkit.kernel.*;
	//import madkit.messages.*;


	public  class MirrorAgent extends Agent implements Mirror
	{

		private AgentAddress myCurrentAgentAddress;
		private int state=-1;
		private Vector programmedItinerary;		 // To memorize the itinerary the agent have to acheive
		private Vector acheivedItinerary;

		public MirrorAgent(Vector itinerary) // 
		{
			acheivedItinerary = new Vector(1,1);
			programmedItinerary = new Vector(1,1);
			
			if(itinerary != null)
			{
				for(int i=0;i<itinerary.size();i++)
				 programmedItinerary.addElement(itinerary.elementAt(i));
			}
			else
				programmedItinerary = null;
		}

		public void activate()
		{
			joinGroup("Mobility");
			println("Mirroir");
			//getAddress().update(myCurrentAgentAddress);
		}

		public void live()
		{
			while(true)
			{
				exitImmediatlyOnKill();
				Message m=waitNextMessage();// On attend l'idMobile du migrateur;
				handleMessage(m);
			}
		}
		
		public void handleMessage(Message m)
		{
			if(m instanceof StringMessage)
			{ 
				String s= ((StringMessage)m).getString();
				
				if(s.equals("Arrived"))
				{
					System.out.println("Received message from my Master Mobile Agent "+m.toString());
//					programmedItinerary.removeElementAt(0);
					
					if(programmedItinerary.size()>0 && m.getSender().getKernel().equals((KernelAddress) programmedItinerary.elementAt(0)))// un message de l'agence o est mon agent
					{	
						myCurrentAgentAddress = m.getSender();  
					}
				}
			}
			else
			{
				if(m.getSender().equals(myCurrentAgentAddress) && (m instanceof ObjectMessage))
				{
					Vector listRoles = (Vector) ((ObjectMessage)m).getContent();
					for(int i = 0; i<listRoles.size() ;i++)
					{
					  Vector infoRole = (Vector)listRoles.elementAt(i);
						
						 joinGroup((String)infoRole.elementAt(1));
						 requestRole((String)infoRole.elementAt(0),(String)infoRole.elementAt(1),(String)infoRole.elementAt(2),null);
						 //System.out.println("<<<<<<<<<<<<<<<<Message de mon agent il contient "+listRoles.toString());							
						// System.out.println("Le role qu'on cherche est "+(String)infoRole.elementAt(1)+" le role est "+(String)infoRole.elementAt(2));
					}
				}
			}
		}

		public void end() 
		{
			System.err.println("!!Mirror broken !!");
			//currentKernel.killAgent(this);	// A terminer  si on est dans notre site ok sinon informer notre site de notre mort
		}
		

}
