/*
* NetworkRequest.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import madkit.kernel.*;

/** This message class is to be used to allow communications between mobileAgent and the placeKeeper
  	of the corresponding running kernel.

    @author Mansour Saber 07/04/04
    @version 1.0
*/

final public class MigrationRequest extends Message implements PrivateMessage

{
	private KernelAddress birthAgency; // the agency (Kernel) where the mobile Agent was born
	private KernelAddress destinationAgency; // the agency (Kernel) where the mobile Agent want to go
	private String birthPlace; //The place where the mobile agent was born
	private AgentAddress currentAddress; // the current Agency of the agent
	private String destinationPlace; //The place where the mobile agent is now
	private int neededRights; // A mobile Agent will need to get some privileges but depending on the degree of trust 
									 // the receiving Agncy will give to him, he will obtain this privilges or not
	private int offeredRights; // A mobile Agent can refuse that the receiving Agency execute some operations on its codc=e
										// or he must some informations so he must prcise all these security requierments to the Agency
	private Object key; // Some Agency will need a key to allow receiving mobileAgents or it may be the key to be received to the place

	private Object others; // Any other specific informations a developper can add

	

	public MigrationRequest(KernelAddress birthAg, AgentAddress currentAdd,String birthPl, String destPl, KernelAddress destAg,int neededR, int offredR, Object Ke, Object Oth)
	{
		birthAgency = birthAg;
		birthPlace = birthPl;
		currentAddress = currentAdd;
		destinationPlace = destPl;
		destinationAgency = destAg;
		neededRights = neededR;
		offeredRights = offredR;
		key= Ke;
		others= Oth;
	}

	

	public KernelAddress getBirthAgency(){	return birthAgency;    }
	
	public KernelAddress getDestinationAgency(){	return destinationAgency;    }
	
	public AgentAddress getCurrentAddress(){	return currentAddress;    }
	
	public String getDestinationPlace() {return destinationPlace;}
	
	public String getBirthPlace() {return birthPlace;}
	
	public int getNeededRights() {return neededRights;}
	
  public int getOffredRights() {return offeredRights;}
	
	public Object getKey() {return key;}
	
	public Object getOthers() {return others;}
	
}
