
/*
* placeKeeper.java - Kernel: the kernel of MadKit
* Copyright (C) 2004-2004 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;
/** The main MadKit mobileAgent class. Provides support for mobile Agent
 * lifecycle, mobility, messaging, actions...
 *
 * The agent behavior intentionnaly is *not* defined. It is up to the
 * agent developer to choose an agent model or to develop his specific
 * agent library on top of the facilities provided by MadKit. However,
 * all agent share the same organizational view, and the basic
 * messaging code, so integration of agent coming from different
 * developer and having heterogeneous models is quite easy.
 *
 * Agent-related methods (almost everything here) can invoked only
 * after registration in the kernel (i.e. after the activate() method has been called
 * on this agent). That means that you should not use any of the agent methods in
 * constructor
 *
  @author Mansour Saber

 */
public interface ConstMobileInterface
{

	final int permissionToEnter = 1;
	final int agentNotWaited = -1;
	final int endOfTime = -2;
	final int placeNotFound = -3;
	final int passwordNull = -4;
	final int entryNotAllowed = -5;
	final long timeOut = 5000;

}

