/*
* StringMessage.java - Core message
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.kernel;

/**
 * A message that carries a single string
 * @author Olivier Gutknecht
 */
@SuppressWarnings("serial")
public class StringMessage extends Message
{
	String content = null;
	
public StringMessage(final String s) {
	content=s;
}
  
public String getString() {
	return content;
}

/**
 * Should not be used ... 
 * Sets the string.
 * 
 * @param s the new string
 */
public void setString(final String s) {
	content = s;
}

@Override
public String toString() {
	return super.toString()+" : "+content;
}
    
}
