/*
 * SecuredMessage.java - Kernel: the kernel of MadKit
 * Copyright (C) 1998-2008 Olivier Gutknecht, Fabien Michel, Jacques Ferber
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package madkit.kernel;

/** 
 * If security is an issue for the application, implementing the <code>SecuredMessage</code> interface should be considered as,
 * although the default fields of a message could not be altered by receivers (read only or copy),
 * other messages (subclasses of Message) and their content could be intercepted via the hooking mechanism of the kernel or modified by the receiver.
 * Thus, additional content could be altered by any receiver.
 * <p>
 * Implementing the <code>SecuredMessage</code> interface 
 * (and Overriding the default <code>clone</code> method of <code>Message</code>; Do not forget to call super.clone())
 * will tell the kernel
 * to do a copy of the message for each receiver, ensuring the data security of the original object/content used to build a message.
 * 
 * @see PrivateMessage
 * @version 1.0
 * @since Madkit 4.3
 * @author Fabien Michel 
*/
public interface SecuredMessage extends Cloneable {

	/** returns a copy of the message.
	 * This is for subclasses of <code>Message</code> that need to define a deep copy.
	 * If you do not override this method, you probably do not need to implement this interface as 
	 * the <code>Message</code> class is already secured.  
	 * @return a copy of the message.
	 */
	public Message clone();
}
