/*
* CGRException.java - Kernel: Exception related to organization requests
* Copyright (C) 1998-2008 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.kernel;

/**
*    @author Fabien Michel
*    @version 1.0 23 10 2007
*    @since MadKit 4.3
 */
@SuppressWarnings("serial")
final class CGRException extends Exception {
	
	private String community,group,role;
	final private int code;
	/**
	 * The Constructor.
	 * 
	 * @param internalCause the kernel internal cause of the exception
	 * @param community the community
	 * @param group the group
	 * @param role the role
	 */
	CGRException(int code, String community, String group, String role, Throwable internalCause) {
		super(internalCause);
		this.community = community;
		this.group = group;
		this.role = role;
		this.code = code;
	}

	/**
	 * @param community the community to set
	 */
	final void setCommunity(String community) {
		this.community = community;
	}

	/**
	 * @param group the group to set
	 */
	final void setGroup(String group) {
		this.group = group;
	}

	/**
	 * @param role the role to set
	 */
	final void setRole(String role) {
		this.role = role;
	}
	
	@Override
	public String getMessage() {
		return buildCGRMessage();
	}
	
	final String buildCGRMessage(){
		String message;
		if (getCause() instanceof RoleNotHandled) {
			message = " not handled";
		}
		else if (getCause() instanceof RoleAlreadyHandled) {
			message = " already handled";
		}
		else if (getCause() instanceof AccessDeniedException) {
			message = " access denied";
		}
		else if (getCause() instanceof NotAMemberException) {
			message = " not a member";
		}
		else {
			message = " does not exist";			
		}
		message += " (set agent debug on for a trace)";
		if (role != null) {
			return " : Role <"+community+","+group+","+role+"> :"+message;
		} else if (group != null) {
			return " Group <"+community+","+group+"> :"+message;
		} else {
			return " Community <"+community+"> :"+message;
		}
	}

	int getCode() {
		return code;
	}
}
