package org.math.plot.plots;

import java.awt.*;
import java.io.*;

import javax.swing.*;

import org.math.plot.*;
import org.math.plot.plotObjects.*;
import org.math.plot.render.*;

public class ScatterPlot extends Plot {

	private int type;

	private int radius;

	private boolean[][] pattern;

	private boolean use_pattern;

	double[][] XY;

	public ScatterPlot(String n, Color c, boolean[][] _pattern, double[][] _XY) {
		super(n, c);
		XY = _XY;
		use_pattern = true;
		pattern = _pattern;
	}

	public ScatterPlot(String n, Color c, int _type, int _radius, double[][] _XY) {
		super(n, c);
		XY = _XY;
		use_pattern = false;
		type = _type;
		radius = _radius;
	}

	public ScatterPlot(String n, Color c, double[][] _XY) {
		this(n, c, AbstractDrawer.ROUND_DOT, AbstractDrawer.DEFAULT_DOT_RADIUS, _XY);
	}

	public void plot(AbstractDrawer draw, Color c) {
		if (!visible)
			return;

		draw.setColor(c);
		if (use_pattern) {
			draw.setDotType(AbstractDrawer.PATTERN_DOT);
			draw.setDotPattern(pattern);
		} else {
			draw.setDotRadius(radius);
			if (type == AbstractDrawer.CROSS_DOT)
				draw.setDotType(AbstractDrawer.CROSS_DOT);
			else
				draw.setDotType(AbstractDrawer.ROUND_DOT);
		}

		for (int i = 0; i < XY.length; i++)
			draw.drawDot(XY[i]);
	}

	public void setDotPattern(int t) {
		type = t;
		use_pattern = false;
	}

	public void setDotPattern(boolean[][] t) {
		use_pattern = true;
		pattern = t;
	}

	@Override
	public void setData(double[][] d) {
		XY = d;
	}

	@Override
	public double[][] getData() {
		return XY;
	}

	public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
		for (int i = 0; i < XY.length; i++) {
			int[] screenCoord = draw.project(XY[i]);

			if ((screenCoord[0] + note_precision > screenCoordTest[0]) && (screenCoord[0] - note_precision < screenCoordTest[0])
					&& (screenCoord[1] + note_precision > screenCoordTest[1]) && (screenCoord[1] - note_precision < screenCoordTest[1]))
				return XY[i];
		}
		return null;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// double[][] XYZ = new double[][]
		// {{.1,.2,.3},{.4,.5,.6},{.7,.8,.9},{1.0,1.1,1.2},{1.3,1.4,1.5},{1.6,1.7,1.8}}
		Plot3DPanel p = new Plot3DPanel();
		for (int i = 0; i < 10; i++) {
			double[][] XYZ = new double[100][3];
			for (int j = 0; j < XYZ.length; j++) {
				XYZ[j][0] = /*1 +*/ Math.random();
				XYZ[j][1] = /*100 **/ Math.random();
				XYZ[j][2] = /*0.0001 **/ Math.random();
			}
			p.addScatterPlot("toto" + i, XYZ);
		}
		p.addQuantiletoPlot(0, 0, 0.5);

		p.addPlotable(new PlotableImage(new File("test.gif"), 0.5f, new double[] {0.0,0.0,0.0},new double[] {1,0,0.0},new double[] {0.0,0,1}));
		p.addPlotable(new PlotableImage(new File("test.gif"), 0.5f, new double[] {0.0,0.0,0.0},new double[] {0,1,0.0},new double[] {0,0.0,1}));
		p.addPlotable(new PlotableImage(new File("test.gif"),0.5f,  new double[] {0.0,0.0,0.0},new double[] {1,0,0},new double[] {0,1,0}));
		// TODO this following case is not totally supported...
		//p.addPlotable(new PlotImage(new File("test.jpg"),0.5f,  new double[] {1,0,0},new double[] {1,1,0},new double[] {0,0,1}));

		
		p.setLegendOrientation(PlotPanel.SOUTH);
		new FrameView(p).setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		Plot2DPanel p2 = new Plot2DPanel();
		for (int i = 0; i < 10; i++) {
			double[][] XYZ = new double[100][2];
			for (int j = 0; j < XYZ.length; j++) {
				XYZ[j][0] =/*1 + */Math.random();
				XYZ[j][1] = /*100 * */Math.random();
			}
			p2.addScatterPlot("toto" + i, XYZ);
		}
		p2.addQuantiletoPlot(0, 0, 0.5);
		
		p2.addPlotable(new PlotableImage(new File("test.gif"), 0.8f,new double[] {0.2,0.5},new double[] {1.2,0.8},new double[] {0.2,1.1}));

		p2.setLegendOrientation(PlotPanel.SOUTH);
		new FrameView(p2).setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

}