/*
 * Predator.java -TurtleKit - A 'star logo' in MadKit
 * Copyright (C) 2000-2002 Fabien Michel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * un tour:
 * bouger
 * et
 * 	manger
 * 	ou
 * 	consumme
 * 	ou	
 * 	eat
 * 
 * 
 * 
 */
package turtlekit.simulations.hunt2CyanVsOrange;

import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Array;
import java.util.ArrayList;

import com.sun.corba.se.spi.extension.ZeroPortPolicy;
import com.sun.org.apache.xpath.internal.operations.Div;

import turtlekit.kernel.Turtle;

public class Cyan extends Animat 
{
	
	
	private static final String selfColor="cyan", otherColor="red";
	/*

	 */
	static private double seuilVie=30;//5;
	
	
	private ArrayList<Animat> nous;
	private ArrayList<Animat> autre;
	
	private int generation=0;


	
	/**
	 * @param visionRadius
	 * @param initLife 
	 */
	public Cyan(int visionRadius, int initLife) {
		super(visionRadius, initLife);
	}
	
	public void setup()
	{
		playRole(selfColor);
		randomHeading();
		setColor(Color.cyan);

	} 
	
	public String live()
	{
		updatePerceptions();
		
		if(!eatOther()){
			
			//mouvement
			if(!towardsAnother())
				towardsRessource();
			move();

			if(!eatOther()){
				if(life>seuilVie )
					reproduce();
				else
					consumeResource();
			}
		}
		
		nous=null;
		autre=null;
		return "live";
	}
	
	

	private void updatePerceptions(){
		
		this.nous = new ArrayList<Animat>();
		
		this.autre = new ArrayList<Animat>();
		int vue=2;
		for(int i=0;i<=vue;i++){
			for(int j=0;j<=vue;j++){
				if(j!=0  && i!=0){
				parseTurtles(turtlesAt(i,j));
				parseTurtles(turtlesAt(i,-j));
				parseTurtles(turtlesAt(-i,j));
				parseTurtles(turtlesAt(-i,-j));
				}
			}
		}
		for (Turtle t : turtlesHere()){
			
			if(t.isPlayingRole(selfColor))
				
				nous.add(0,(Animat)t);
				
				else
				autre.add((Animat)t);
		
		}
		
	}
	
	private void parseTurtles(Turtle[] turtles) {
		
		for (Turtle t : turtles)
			
			if (t.isPlayingRole(selfColor)) //instead of "instanceof". So prey can be another java class
				nous.add((Animat) t);
			else
				autre.add((Animat)t);
		
	}
	
	
	
	private boolean towardsAnother()
	{
		for(Animat a:autre){
			setHeading(towards(a.xcor(),a.ycor()));
			return true;
		}
		
		return false;
	}
	
	private ArrayList<Turtle> getOtherHere(){
	
		ArrayList<Turtle> preys = new ArrayList<Turtle>();
		Turtle[] animats = turtlesHere();
		if(animats!=null){
			for (int i = 0; i < animats.length; i++) {
				if(animats[i].isPlayingRole(otherColor)){
					preys.add((Animat)animats[i]);
				}
			}
		}
		return preys;
	}
	
	private boolean eatOther() {
		ArrayList<Turtle> t=getOtherHere();
		
		if(!t.isEmpty()){
			Animat p=(Animat)t.get(0);
			life += p.getLife();
			p.die();
			return true;
		}
		return false;
	}
	
	
	
private boolean towardsRessource(){
		
		int x=0;
		int y=0;
		double resource=0;
		double resTmp=0;
		for(int i=-1;i<=1;i++){
			for(int j=-1;j<=1;j++){
				if(j!=0  && i!=0){
					resTmp=getPatchVariableAt("resource",i,j);
					if(resTmp>resource){
						resource=resTmp;
						x=i;
						y=j;
					}
				}
			}
		}
		if(resource>0){
			towards(xcor()+x,ycor()+y);
			return true;
		}
		return false;
	}
	
	

	private ArrayList<Turtle> getUsHere() {
		ArrayList<Turtle> preys = new ArrayList<Turtle>();
		Turtle[] animats = turtlesHere();
		if(animats!=null){
			for (int i = 0; i < animats.length; i++) {
				if(animats[i].isPlayingRole(selfColor)){
					preys.add((Animat)animats[i]);
				}
			}
		}
		return preys;
	}	
}








