package turtlekit2.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import turtlekit2.kernel.Patch;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.Viewer;
import turtlekit2.kernel.XMLAttributes;

public class SimulationProbe extends Viewer implements MouseListener, MouseMotionListener,ActionListener, MouseWheelListener{
	XMLAttributes attrib = new XMLAttributes();
	
	
	ArrayList maxButton = new ArrayList();
	ArrayList totalButton = new ArrayList();
	ArrayList avgButton = new ArrayList();
	
	String dropPher = "";
	
	JMenuBar menuBar;
    JMenu pheroMenu;
    JMenuItem menuItem;
    JButtonColor redb, greenb, blueb, blackb, drop, pheroButtons, turtleb;
	JFrame f = new JFrame("Custom Viewer COnfiguration");
	JLabel cord, factors, phero;
	boolean turtleDisplay = true;
	
	/**No usage*/
	public void init() {}
	
	/**MadKit usage, no redefinition*/
	public void initGUI() {
		super.initGUI();
		createFrame();
		getOnScreen().addMouseWheelListener(this);
		getOnScreen().addMouseListener(this);
		getOnScreen().addMouseMotionListener(this);
	}

	
	public void test(){
		for(int i=0; i<getFlavors().size();i++){
			double maxPheromone = 0;
			double totalPheromone = 0;
		  	for(int j=0;j<envWidth;j++){
			      for(int k=0;k<envHeight;k++){
			    	totalPheromone += patchGrid[j][k].getVariableValue(getFlavorName(i));
			        if((patchGrid[j][k].getVariableValue(getFlavorName(i)) > maxPheromone))
			        {
			        	maxPheromone = patchGrid[j][k].getVariableValue(getFlavorName(i));
			        	((JButton)(maxButton.get(i))).setText(getFlavorName(i) + " MAX: " + new Double(maxPheromone).toString());
			        }
			      }
		  	}
		  	((JButton)(totalButton.get(i))).setText(getFlavorName(i) + " TOTAL: " + new Double(totalPheromone).toString());
		  	double avgValue = totalPheromone / (envWidth * envHeight);
		  	((JButton)(avgButton.get(i))).setText(getFlavorName(i) + " AVG: " + new Double(avgValue).toString());

		}
    }
	
	/**Graphical usage, no redefinition*/
	public void createFrame(){
		JPanel panel = new JPanel();
	    f.getContentPane().add(panel, BorderLayout.CENTER);
		cord = new JLabel("Coord X - Y", SwingConstants.CENTER);
		panel.add(cord);
		f.setSize(400, 250);
	    Container content = f.getContentPane();
	    content.setLayout(new FlowLayout());
	    for(int i=0; i<getFlavors().size();i++){
	    	//menuItem = new JMenuItem(getFlavorName(i));
	    	JButton maxValue = new JButton(getFlavorName(i));
	    	JButton totalValue = new JButton(getFlavorName(i));
	    	JButton avgValue = new JButton(getFlavorName(i));
	    	maxButton.add(i, maxValue);
	    	totalButton.add(i, totalValue);
	    	avgButton.add(i, avgValue);
	    	content.add(maxValue);
	    	content.add(totalValue);
	    	content.add(avgValue);
	    }
	    f.setJMenuBar(menuBar);
	    f.setVisible(true);
	}
	
	/**Standard graphical representation of turtle. Can be disabled/enabled in real time. 
	 * You can override this method in order to give a special graphic representation of your turtles.*/
	public void paintTurtle(Graphics g, Turtle t,int x,int y,int cellS)
    {
		test();
		if(turtleDisplay){
			g.setColor(t.getColor());
			g.fillRect(x,y,cellS,cellS);
		}
	}
	
	
	
	/**GUI method*/
	public void updateColorList(ArrayList colorList, String pheromone){
		if(colorList.contains(pheromone)) colorList.remove(pheromone);
		else colorList.add(pheromone);
	}
	
	/**GUI method*/
    public void actionPerformed(ActionEvent e) { 
    	 Object s=e.getSource();
    	
    } 
    
    /**GUI method*/
	 public void mousePressed(MouseEvent e){}
	 /**GUI method*/
	 public void mouseReleased(MouseEvent e){}
	 /**GUI method*/
	 public void mouseEntered(MouseEvent e){}
	 /**GUI method*/
	 public void mouseExited(MouseEvent e){}
	 /**GUI method*/
	 public void mouseClicked(MouseEvent e){}
	 /**GUI method. It drops Pheromones/Flavors on the environment*/
	 public void mouseDragged(MouseEvent e){
		 int x = e.getX()/getCellSize();
	     int y = e.getY()/getCellSize();
	     if(flavorsContains(dropPher)) patchGrid[x][envHeight - y].incrementPatchVariable(dropPher,1000);
	 }
	 /**GUI method. When a Flavor is selected to be dropped, it displays its quantity in the environment.*/   
	 public void mouseMoved(MouseEvent e){
		 	test();
	    	cord.setText("X:" +e.getX()/getCellSize() + " Y:"+ (e.getY())/getCellSize());
	    }
	 /**GUI method. WheelMouse modify the scale of flavors displaying as a function of RGB canals.*/
	  public void mouseWheelMoved(MouseWheelEvent e) {
	        String message;
	  }
}

