/*
* Genetic Package for TurtleKit 2: TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2002-2007 Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.genetic;
 
import java.util.Random;

/**
 * <p>Titre : EvolutionManager </p>
 * <p>Description : A basic evolution manager implementing reproduction beetween 2 individuals and roulette wheel selection.
 * Others selection methods are disables for the moment. </p>

 */ 
public class EvolutionManager {
	final static int WAITING = -1;

	final static int ACTIVATED = 0;

	final static int PARENT = 1;
	
	int appels = 0;
	
	Pool managedPool = null;
	
	Random randomizer = new Random();
	
	Pool parents = new Pool();
	
	Pool children = new Pool();
	
	Pool elites = new Pool();
	
	public EvolutionManager() {
	}
	
	public EvolutionManager(Pool pool) {
		managedPool = pool;
	}
	
	/** First reproduction method */
	public void reproduce(Pool pool){
		appels++;
		if(pool.size()>1){
			System.out.println("Reproduction " + appels);
			managedPool = pool;
			rouletteWheelSelection();
			reproduction();
			}
		else{
			System.out.println("no reproduction with 1 genome");
			}
	}
	
	/** Roulette Wheel Selection method. */
	public void rouletteWheelSelection(){
		managedPool.fitSortDesc();
		double fitnessGlobal = 0;
		int nbParents = 0;
		for(int i=0; i<managedPool.size(); i++){
			fitnessGlobal += ((Genome)(managedPool.get(i))).getFitness();
		}
		while(nbParents < managedPool.size()/2){
			double randomSample = randomizer.nextDouble();
			double fitnessSum = 0;
			
			for(int j=0; j<managedPool.size(); j++){
				fitnessSum += (((Genome)(managedPool.get(j))).getFitness()/fitnessGlobal);
				if (fitnessSum >= randomSample){
					if(((Genome)(managedPool.get(j))).getState() != PARENT) nbParents++;
					((Genome)(managedPool.get(j))).setState(PARENT);
					break;
				}
			}
		}
		parents.clear();
		elites.clear();
		for(int i=0; i<managedPool.size(); i++){
			if(i==0) elites.add(managedPool.get(i));
			if(((Genome)(managedPool.get(i))).getState() == PARENT) parents.add(((Genome)(managedPool.get(i))));
		}
		System.out.println("Roulette Wheel Selection done.");
	}
	
	
	/** reproduction method. Reproduction effects depend on genes properties and methods */
	public void reproduction() {
		children.clear();
		System.out.println(" ******* BEST GENOME ****** "+ ((Genome) managedPool.get(0)).toString());
		for (int i = 0; i < (parents.size()); i++) {
			int motherIndex = randomizer.nextInt(parents.size());
			int fatherIndex = randomizer.nextInt(parents.size());
			Genome father = (Genome) parents.get(fatherIndex);
			Genome mother = (Genome) parents.get(motherIndex);
			Genome child = (Genome)father.clone();

			// a dplacer dans les gnomes - a faire plus propre
			for (int l = 0; l < father.size(); l++) {
				Gene fatherGene = (Gene) father.get(l);
				Gene motherGene = (Gene) mother.get(l);
				if(fatherGene.isFixed()){
					child.set(l, (Gene) fatherGene.clone());
					((Gene)(child.get(l))).setFixed(true);
				}
				else ((Gene) child.get(l)).cross(fatherGene, motherGene);
			}
			child.setState(WAITING);
			child.setFitness(WAITING);
			children.add(child);
		}
		int conservedSize = managedPool.size();
		managedPool.clear();
		managedPool.addAll(elites);
		System.out.println("**APRES ELITE** " + managedPool.size());
		for(int i =0; i<managedPool.size();i++){
			for(int j=0; j<parents.size();j++){
				if(((Genome)(managedPool.getGenome(i))).isEqual((Genome)(parents.getGenome(j)))) {
					parents.remove(j);
					j--;
				}
			}
		}

		while(parents.size()>=conservedSize/2){
			parents.remove(parents.size()-1);
		}
		managedPool.addAll(parents);
		
		for(int i =0; i<managedPool.size();i++){
			((Genome)(managedPool.getGenome(i))).setState(ACTIVATED);
			for(int j=0; j<children.size();j++){
				/***Mutation****/
				Genome genome = (Genome) children.get(i);
				for (int l = 0; l < genome.size(); l++) {
					if(!((Gene) genome.get(l)).isFixed()) ((Gene) genome.get(l)).mutate();
				}
				/******/
				if(((Genome)(managedPool.getGenome(i))).isEqual((Genome)(children.getGenome(j)))) ((Genome)children.getGenome(j)).reset();
			}
		}
		managedPool.addAll(children);
	}

	/** Genes crossing method 1 */
	public void crossGenes1() {
		managedPool.fitSortDesc();
		System.out.println(" ******* BEST GENOME ****** "
				+ ((Genome) managedPool.get(0)).toString());
		for (int i = 0; i < (managedPool.size() / 2); i++) {
			Genome father = (Genome) managedPool.get(i);
			int motherIndex = managedPool.randomizer.nextInt(managedPool.size() / 2);
			Genome mother = (Genome) managedPool.get(motherIndex);
			Genome child = (Genome) managedPool.get(i + (managedPool.size() / 2));

			// a dplacer dans les gnomes - a faire plus propre
			for (int l = 0; l < father.size(); l++) {
				Gene fatherGene = (Gene) father.get(l);
				Gene motherGene = (Gene) mother.get(l);
				if(fatherGene.isFixed()){
					child.set(l, (Gene) fatherGene.clone());
					((Gene)(child.get(l))).setFixed(true);
				}
				else ((Gene) child.get(l)).cross(fatherGene, motherGene);
			}
		}
	}
	
	/** Genes crossing method 2 */
	public void crossGenes2() {
		managedPool.fitSortDesc();
		System.out.println(" ******* BEST GENOME ****** " + ((Genome) managedPool.get(0)).toString());
		for (int i = 0; i < (managedPool.size()/2); i++) {
			Genome father = (Genome) managedPool.get(i);
			int motherIndex = managedPool.randomizer.nextInt(managedPool.size() / 2);
			Genome mother = (Genome) managedPool.get(motherIndex);
			Genome child = (Genome) managedPool.get(i + (managedPool.size() / 2));

			// a dplacer dans les gnomes - a faire plus propre
			for (int l = 0; l < father.size(); l++) {
				Gene fatherGene = (Gene) father.get(l);
				Gene motherGene = (Gene) mother.get(l);
				if(fatherGene.isFixed()){
					child.set(l, (Gene) fatherGene.clone());
					((Gene)(child.get(l))).setFixed(true);
				}
				else ((Gene) child.get(l)).cross(fatherGene, motherGene);
			}
		}
	}
	
	/******************************************************************/

	public void setManagedPool(Pool managedPool) {
		this.managedPool = managedPool;
	}


}
