/*
 * TurtleActivator.java -TurtleKit - A 'star logo' in MadKit
 * Copyright (C) 2000-2008 Fabien Michel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package turtlekit.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import madkit.boot.Madkit;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;

/** The TurtleActivator invoke and set the turtles nextAction variable 

  @author Fabien MICHEL
  @version 4.0 24/02/2007 */

final class TurtleActivator extends Activator<Turtle>
{     
	Map<Class<Turtle>,Map<String,Method>> methodTable;

	public TurtleActivator(String group)
	{
		super(Launcher.COMMUNITY,group, Turtle.TURTLE_DEFAULT_ROLE);
		methodTable=new HashMap<Class<Turtle>,Map<String,Method>>();
	}

	@SuppressWarnings("unchecked")
	@Override
	public void initialize()
	{
		for(AbstractAgent t : getCurrentAgentsList())
		{
			methodTable.put((Class<Turtle>) t.getClass(),new HashMap<String,Method>());
		}
	}    

	@SuppressWarnings("unchecked")
	@Override
	public void update(AbstractAgent theAgent, boolean added)
	{
		Class<Turtle> c = (Class<Turtle>) theAgent.getClass();
		if (added && ! methodTable.containsKey(c))
			methodTable.put(c,new HashMap<String,Method>());
	}    

	@SuppressWarnings("unchecked")
	@Override
	synchronized public void execute()
	{
		for(Turtle t : getShuffledList()) //TODO shuffle or not !!
		{
			if(t.position==null)
				return;
			String nextMethod=null; 
			try	{	
				nextMethod = (String) t.nextAction.invoke(t);
			}
			catch (Exception e){
				if(Madkit.debug){
					System.err.println("Can't invoke:"+e+" "+(t.nextAction).toString()+"\n");
					e.printStackTrace();
					return;
				}
			}
			if (nextMethod != null)	{
				Method m = methodTable.get(t.getClass()).get(nextMethod);
				if (m == null)	{
					try {
						final Class<? extends Turtle> c = t.getClass();
						m = c.getMethod(nextMethod);
						methodTable.get(c).put(nextMethod.intern(), m);
					}
					catch (NoSuchMethodException e) {System.err.println("Can't find method: "+nextMethod);e.printStackTrace();}
					catch (SecurityException e) {System.err.println("problem with method: "+nextMethod);e.printStackTrace();}
				}
				t.setNextAction(m);
			}
			else
				t.setNextAction(null);
		}
	}

//final synchronized Turtle[] getTurtles()
//{
//return (Turtle[]) getCurrentAgentsList().toArray(new Turtle[0]);
//}


}

