/*
* ReflexiveProbe.java - Simulation: the general classes for handling simulation in MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.simulation.probes;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;

/** This class implements a dynamic probe on a given property.
  @version 3.1
  @author Olivier Gutknecht
  @author Fabien Michel*/

public class ReflexiveProbe extends Probe<AbstractAgent>
{     
	protected Map<AbstractAgent, Field> fields;
	private String property;
    

public ReflexiveProbe(String group, String role,String property)
{
	super(group, role);
	this.property = property;
	fields = new HashMap<AbstractAgent, Field>();
}
    
public ReflexiveProbe(String community, String group, String role, String property)
{
	super(community, group, role);
	this.property = property;
	fields = new HashMap<AbstractAgent, Field>();
}
    
public String getProperty() {return property;}

public void findFields()
{
	for (AbstractAgent theAgent : getCurrentAgentsList()) {
    		try {
    			fields.put(theAgent, theAgent.getClass().getField(property));
    		}
    		catch(Exception e) {
    			System.err.println("Can't find property: "+property+" on "+ theAgent.toString() +e);
		}
	}
}

public void initialize()
{
	findFields();
}

public void update(AbstractAgent theAgent, final boolean added)
{
	if(added)
		updateFieldFor(theAgent);
	else
		fields.remove(theAgent);
}
   
public void updateFieldFor(AbstractAgent theAgent)
{
	try	{
		fields.put(theAgent, theAgent.getClass().getField(property));
	}
 	catch(Exception e) {
		System.err.println("Can't find property: "+property+" on "+ theAgent.toString()+"  "+ e);
	}
}

    synchronized public double getDouble(AbstractAgent theAgent) {
    	try
    	{
    		return fields.get(theAgent).getDouble(theAgent);
    	}
    	catch(IllegalAccessException e)
    	{
    		System.err.println("Unable to getDouble on "+theAgent.toString()+"  "+e);
    		return Double.NaN;
    	}
    }
    
    synchronized public long getLong(AbstractAgent theAgent) 
    {
    	try
    	{
		return fields.get(theAgent).getLong(theAgent);
    	}
    	catch(IllegalAccessException e)
    	{
    		System.err.println("Unable to getLong on "+ theAgent.toString()+"  "+ e);
    		return (long) Double.NaN;
    	}
    }
    synchronized public boolean getBoolean(AbstractAgent theAgent) 
    {
    	try
    	{
		return fields.get(theAgent).getBoolean(theAgent);
    	}
    	catch(IllegalAccessException e)
    	{
    		System.err.println("Unable to getBoolean on "+ theAgent.toString()+"  "+ e);
    		return false;
    	}
    }

    synchronized public char getChar(AbstractAgent theAgent) 
    {
    	try
    	{
		return fields.get(theAgent).getChar(theAgent);
    	}
    	catch(IllegalAccessException e)
    	{
    		System.err.println("Unable to getBoolean on "+ theAgent.toString()+"  "+ e);
    		return Character.MAX_VALUE;
    	}
    }

    synchronized public Object getObject(AbstractAgent theAgent) 
    {
    	try
    	{
		return fields.get(theAgent).get(theAgent);
    	}
    	catch(IllegalAccessException e)
    	{
    		System.err.println("Unable to getObject on "+ theAgent.toString()+"  "+ e);
    		return null;
    	}
    }
    public int getPropertyCount()
    {
	return fields.size();
    }
}
