/*
 * ObjectProbe.java - Simulation: the general classes for handling simulation in MadKit
 * Copyright (C) 2008 Fabien Michel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package madkit.simulation.probes;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Kernel;
import madkit.kernel.Probe;
/** This probe inspects properties of type P on Referenceable agents of type A.
  @author Fabien Michel
  @version 1.0
 */

public class PropertyProbe<A extends AbstractAgent,P> extends Probe<A>
{ 
	final private HashMap<A, P> properties = new HashMap<A, P>();
	final private String fieldName;

	public PropertyProbe(String group, String role, String property)
	{
		this(Kernel.DEFAULT_COMMUNITY,group, role, property);
	}

	public PropertyProbe(String community, String group, String role,String property)
	{
		super(community, group, role);
		fieldName = property;
	}

	@Override
	public void initialize()
	{
		findFields();
	}

//	@SuppressWarnings("unchecked")
	@Override
	public void update(AbstractAgent theAgent, final boolean added)
	{
		if(added)
			findFieldOfAgent((A) theAgent);
		else
			properties.remove(theAgent);
	}
	   

	final private void findFields()
	{
		for (A theAgent : getCurrentAgentsList()) {
			findFieldOfAgent(theAgent);
		}
	}

	/**
	 * @param theAgent
	 */
	@SuppressWarnings("unchecked")
	private void findFieldOfAgent(A theAgent) {
		try {
			properties.put(theAgent, (P) theAgent.getClass().getField(fieldName).get(theAgent));
		}
		catch(NoSuchFieldException e) {
			System.err.println("Can't find property: "+fieldName+" on "+ theAgent.toString() +e);
		}catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}
	
	public Map<A, P> getMapping() {
		return properties;
	}
	
	public P getPropertyOf(A theAgent){
		return properties.get(theAgent);
	}
	
	public Collection<P> getAllProperties() {
		return properties.values();
	}

}