/**
 * http://www.javafr.com/forum.v2.aspx?id=226334
 * ChartFactory : permet de crer facilement des graphiques  partir
 * des donnes passs en paramtre
 */

package test;

import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.TableOrder;

/**
* @author MAT
*
* To change the template for this generated type comment go to
* Window - Preferences - Java - Code Generation - Code and Comments
*/
public class Chart {
public static final int TYPE_PIE = 1;
public static final int TYPE_BAR = 2;
public static final int TYPE_PIE3D = 3;
public static final int TYPE_BAR3D = 4;
public static final int TYPE_HISTOGRAM = 5;
public static final int TYPE_MULTIPLEPIE = 6;


private int type;
private DefaultCategoryDataset donnees;
private String nomFichier;
private String titre;
private int longueur;
private int largeur;

public Chart(String nomFic, String leTitre, int laLongueur,int laLargeur, DefaultCategoryDataset lesDonnees, int leType){
type = leType;
donnees = lesDonnees;
nomFichier = nomFic;
titre = leTitre;
longueur = laLongueur;
largeur = laLargeur;
}

public void makeChart(){
switch(type){
case TYPE_PIE:
makePie();
break;
case TYPE_PIE3D :
makePie3D();
break;
case TYPE_BAR:
makeBar();
break;
case TYPE_BAR3D:
makeBar3D();
break;
case TYPE_HISTOGRAM:
makeHistogram();
break;
case TYPE_MULTIPLEPIE:
makeMultiplePie();
break;

}
}

/**
*
*/
private void makeMultiplePie() {
// TODO Auto-generated method stub
try{
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);

JFreeChart barChart = ChartFactory.createMultiplePieChart3D(titre,donnees,TableOrder.BY_COLUMN,true,true,false);

BufferedImage bi = barChart.createBufferedImage(longueur,largeur);
ImageIO.write(bi,"png",fic);


}catch(Exception e){
e.printStackTrace();
}
}

public void makeAllTypes(){
makePie();
makePie3D();
makeBar();
makeBar3D();
makeHistogram();
}
/**
*
*/
private void makeBar3D() {
// TODO Auto-generated method stub
try{
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);
JFreeChart barChart = ChartFactory.createBarChart3D(titre,"","",donnees,PlotOrientation.VERTICAL,true,true,false);

BufferedImage bi = barChart.createBufferedImage(longueur,largeur);

ImageIO.write(bi,"png",fic);


}catch(Exception e){
e.printStackTrace();
}
}

/**
*
*/
private void makePie3D() {
// TODO Auto-generated method stub
try {
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);
DefaultPieDataset pieData = new DefaultPieDataset();
for(int i = 0; i< donnees.getRowCount();i++){
Number value = donnees.getValue(i,0);
String name = (String) donnees.getRowKey(i);
pieData.setValue(name,value);
}
JFreeChart pieChart = ChartFactory.createPieChart3D(titre,pieData,true,true,false);
BufferedImage bi = pieChart.createBufferedImage(longueur,largeur);
ImageIO.write(bi,"png",fic);
//ImageIO.write(bi,"jpg",fic);
} catch (Exception e) {
// TODO Auto-generated catch block
e.printStackTrace();
}
}

/**
*
*/
private void makeBar() {
// TODO Auto-generated method stub
try{
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);
JFreeChart barChart = ChartFactory.createBarChart(titre,"","",donnees,PlotOrientation.VERTICAL,true,true,false);

BufferedImage bi = barChart.createBufferedImage(longueur,largeur);
ImageIO.write(bi,"png",fic);


}catch(Exception e){
e.printStackTrace();
}
}

/**
*
*/
private void makePie() {
// TODO Auto-generated method stub
try {
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);
DefaultPieDataset pieData = new DefaultPieDataset();
for(int i = 0; i< donnees.getRowCount();i++){
Number value = donnees.getValue(i,0);
String name = (String) donnees.getRowKey(i);
pieData.setValue(name,value);
}
JFreeChart pieChart = ChartFactory.createPieChart(titre,pieData,true,true,false);
BufferedImage bi = pieChart.createBufferedImage(longueur,largeur);
ImageIO.write(bi,"png",fic);
//ImageIO.write(bi,"jpg",fic);
} catch (Exception e) {
// TODO Auto-generated catch block
e.printStackTrace();
}
}

private void makeHistogram(){
try {
File fic = new File("c:/ArtiJava/IHMWeb/stat/all/"+nomFichier);
DefaultTableXYDataset histoData = new DefaultTableXYDataset();

for(int i = 0; i< donnees.getRowCount();i++){
Number value = donnees.getValue(i,0);
String name = (String) donnees.getRowKey(i);
XYSeries serie = new XYSeries(name,true,false);
serie.add(i+1,value);
histoData.addSeries(serie);
}

JFreeChart pieChart = ChartFactory.createHistogram(titre,"","nombres",histoData,PlotOrientation.VERTICAL,true,true,true);
BufferedImage bi = pieChart.createBufferedImage(longueur,largeur);
ImageIO.write(bi,"png",fic);
//ImageIO.write(bi,"jpg",fic);
} catch (Exception e) {
// TODO Auto-generated catch block
e.printStackTrace();
}
}

}
