package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import modulecoFramework.utils.graphicalWatcher.probes.AverageMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.CountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.Filter;
import modulecoFramework.utils.graphicalWatcher.probes.MaxMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MinMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.watchers.AutoCountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class JPanelOperation3 extends JPanel implements ActionListener, FocusListener {
	
	JTable jTableSeries;
	
	JLabel jLabelSeries;
	
	CountSeriesTableModel countSeriesTableModel;
	
	JScrollPane jScrollPaneSeries;
	
	JButton jButtonNewSerie;
	
	CountWatcher countWatcher;
	
	String choosenCommunity;
	String choosenGroup;
	String choosenRole;
	
	Map hashMapLink;
	
	Object bean = null;
	
	public JPanelOperation3(CountWatcher countWatcher) {
		super(new GridBagLayout());
		this.countWatcher = countWatcher;
		hashMapLink = new HashMap();
		this.build();
	}
	
	public void build() {
		
		jLabelSeries = new JLabel("Sries : ");
		
		countSeriesTableModel = new CountSeriesTableModel(countWatcher);
		
		jTableSeries = new JTable(countSeriesTableModel);
		jTableSeries.setDefaultEditor(Color.class, new ColorEditor());
		jTableSeries.setDefaultRenderer(Color.class, new ColorRenderer(true));
		jTableSeries.setDefaultEditor(Filter.class, new FilterEditor(bean));
		jTableSeries.setDefaultRenderer(Filter.class, new FilterEditor(bean));
		jTableSeries.setIntercellSpacing(new Dimension(2,2));
		jTableSeries.setRowHeight(25);
		jTableSeries.setRowSelectionAllowed(false);
		jTableSeries.addFocusListener(this);
		
		jScrollPaneSeries = new JScrollPane(jTableSeries);
		
		jButtonNewSerie = new JButton("Nouvelle Srie");
		jButtonNewSerie.addActionListener(this);
		
		this.add(jLabelSeries,
				new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
	
		this.add(jScrollPaneSeries,
				new GridBagConstraints(0,1,1,1,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
		this.add(jButtonNewSerie,
				new GridBagConstraints(0,2,1,1,1.0,1.0,GridBagConstraints.SOUTHEAST,GridBagConstraints.NONE,new Insets(0,5,5,5),0,0));
		
	}
	
	public void setObject(Object o) {
		
		//System.out.println("JPanelOperation3 : setObject "+o);
		this.bean = o;
		jTableSeries.setDefaultEditor(Filter.class, new FilterEditor(this.bean));
		jTableSeries.setDefaultRenderer(Filter.class, new FilterEditor(this.bean));

	}
	
	public void setChoosenCommunity(String choosenCommunity) {
		this.choosenCommunity = choosenCommunity;
	}
	
	public void setChoosenGroup(String choosenGroup) {
		this.choosenGroup = choosenGroup;
	}
	
	public void setChoosenRole(String choosenRole) {
		this.choosenRole = choosenRole;
	}
	
	public void addSeries(String property) {
		
		//System.out.println("addSeries for property : "+property);
		
		CountMemoryProbe countMemoryProbe = new CountMemoryProbe(choosenCommunity, choosenGroup, choosenRole);
	
		countWatcher.addMemoryProbe(countMemoryProbe, property);
		((CountSeriesTableModel)jTableSeries.getModel()).updateSeries();
		//jTableModality.setModel(modaliyTableModel);

	}
	
	/*
	public void removeSeries(String operation, String property) {
		System.out.println("removeSeries !!!!");
		MemoryProbe memoryProbe = (MemoryProbe)hashMapLink.get(operation+property);
		hashMapLink.remove(operation+property);
		countWatcher.removeMemoryProbe(memoryProbe);
		((SeriesTableModel) jTableSeries.getModel()).updateSeries();
	}*/

	public void actionPerformed(ActionEvent evt) {
		
		if (evt.getSource().equals(jButtonNewSerie)) {
			this.addSeries(null);
		}
		/*String item = (String)jComboBoxProperty.getSelectedItem();
		System.out.println("ACTION PERFORMED !!! "+item);
		if (evt.getSource().equals(jComboBoxProperty)) {
			if (item != null) {
				this.addSeries((String)jComboBoxProperty.getSelectedItem());
				jTableSeries.validate();
				jTableSeries.repaint();
			}
		}*/
		
	}

	public void focusGained(FocusEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	public void focusLost(FocusEvent arg0) {
		
		System.out.println("Focus lost");
		jTableSeries.validate();
		
	}
	
}
