package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;

import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

import modulecoFramework.utils.graphicalWatcher.probes.Filter;
import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;

public class JConfigureFilter extends JPanel implements ActionListener {
	
	JPanel contentPane;
	
	JButton jButtonOK;
	
	JPanel jPanelButton;
	
	CountWatcher countWatcher;
	
	Filter filterSave;
	
	JDialog jDialog;
	
	public JConfigureFilter(Component parent, Object o, Filter filter, CountWatcher countWatcher) {
		//super("Configuration du filtre");
//		/filterSave = filter.
		this.countWatcher = countWatcher;
		//contentPane = (JPanel) this.getContentPane();
		this.setLayout(new BorderLayout());
		
		JPanelFilter jPanelFilter = new JPanelFilter(o,filter,countWatcher);

		jPanelButton = new JPanel(new FlowLayout());
		
		/*jButtonAnnuler = new JButton("Annuler");
		jButtonAnnuler.addActionListener(this);*/
		
		jButtonOK = new JButton("Valider");
		jButtonOK.addActionListener(this);
		
		//jPanelButton.add(jButtonAnnuler);
		jPanelButton.add(jButtonOK);
		
		
		this.add(jPanelFilter,BorderLayout.CENTER);
		this.add(jPanelButton,BorderLayout.SOUTH);
		
		jDialog = this.createDialog(parent);
		
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JDialog.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JDialog)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle("Configurer le filtre : ");
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}
	
	public int showConfigureFilter() {
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return 1;
	}

	public void actionPerformed(ActionEvent evt) {
		
		/*if (evt.getSource().equals(jButtonAnnuler)) {
			
		}*/
		if (evt.getSource().equals(jButtonOK)) {
			countWatcher.recalculate();
			jDialog.setVisible(false);
			jDialog.dispose();
		}
		
	}
	
}

class JPanelFilter extends JPanel {

	Filter filter;
	Object bean;
	
	JTable jTableFilter;
	JScrollPane jScrollPane;
	FilterTableModel filterTableModel;
	
	public JPanelFilter(Object o, Filter filter, CountWatcher countWatcher) {
		super(new BorderLayout()); 
		this.bean = o;
		this.filter = filter;
		this.setBackground(Color.blue);
		this.build();
	}
	
	public void build() {
		
		filterTableModel = new FilterTableModel(this.bean, this.filter);
		
		jTableFilter = new JTable(filterTableModel);
		jTableFilter.setModel(filterTableModel);
		jTableFilter.setSelectionBackground(Color.white);
		jTableFilter.setSelectionForeground(Color.black);
		jScrollPane = new JScrollPane(jTableFilter);
		
		/** Building editors for logical operators... **/
		TableColumn propertyColumn0 = jTableFilter.getColumnModel().getColumn(0);
		JComboBox comboBox0 = new JComboBox();
		comboBox0.addItem("");
		comboBox0.addItem("and");
		comboBox0.addItem("or");
		comboBox0.addItem("xor");
		comboBox0.addItem("and not");
		comboBox0.addItem("or not");
		comboBox0.addItem("xor not");
		propertyColumn0.setCellEditor(new DefaultCellEditor(comboBox0));
		
		/** Building editors for property... **/
		TableColumn propertyColumn1 = jTableFilter.getColumnModel().getColumn(1);
		JComboBox comboBox1 = new JComboBox();
		Field[] fields = this.bean.getClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			comboBox1.addItem(fields[i].getName());
		}
		propertyColumn1.setCellEditor(new DefaultCellEditor(comboBox1));
		
		/** Building editors for operator... **/
		TableColumn propertyColumn2 = jTableFilter.getColumnModel().getColumn(2);
		propertyColumn2.setCellEditor(new OperatorEditor());
		
		this.add(jScrollPane,BorderLayout.CENTER);
		
	}
	
}
