package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class CountSeriesTableModel extends AbstractTableModel {
	
	Map mapSeries;
	CountWatcher countWatcher;
	
	private Object[] objects = new Object[0];/*{
			"Test",
			new Color(120,255,120)
	};*/
	
	private String[] columnNames = new String[]{"Nom de la Srie","Occurences","Couleur","Filtres"};
	/*private Object[][] data = new Object[][]{objects};*/
	
	public CountSeriesTableModel(CountWatcher countWatcher) {
		super();
		this.countWatcher = countWatcher;
		mapSeries = new HashMap();
	}
	
	public CountWatcher getCountWatcher() {
		return countWatcher;
	}

	public void setCountWatcher(CountWatcher countWatcher) {
		this.countWatcher = countWatcher;
	}

	public void updateSeries() {
		countWatcher.recalculate();
		fireTableDataChanged();
	}

	public int getColumnCount() {
		return columnNames.length;
	}
	
	public int getRowCount() {
		//System.out.println("getNumberOfSeries : "+normalWatcher.getNumberOfSeries());
		return countWatcher.getNumberOfSeries();
	}
	
	public String getColumnName(int col) {
		return columnNames[col];
	}
	
	public Object getValueAt(int row, int col) {
		if (col==0) {
			//System.out.println(row+" : "+countWatcher.getSerieName(row));
			return countWatcher.getSerieName(row);
		}
		else if (col==1){
			return new Double(countWatcher.getLastValue(row));
		}
		else if (col==2){
			return countWatcher.getColor(row);
		}
		else if (col==3){
			return countWatcher.getFiltre(row);
		}
		return null;
	}
	
	public Class getColumnClass(int c) {
		//System.out.println("Column : "+c);
		//if (getValueAt(0, c) != null) {
			return getValueAt(0, c).getClass();
		//}
		//else return String.class;
	}
	
	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 */
	public boolean isCellEditable(int row, int col) {
		if (col == 1) {
			return false;
		}
		return true;
	}
	
	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 */
	public void setValueAt(Object value, int row, int col) {
		if (col==0) {
			countWatcher.setSerieName(row,(String)value);
		}
		else if (col==2) {
			//countWatcher.set
			countWatcher.setColor(row,(Color)value);
		}
		fireTableCellUpdated(row, col);
		fireTableDataChanged();
	}
}
