/* Source File Name:   Canevas.java
* Copyright:    Copyright (c)enst-bretagne
* @author denis.phan@enst-bretagne.fr
* created may 2000 - Interface graphique compatible jdk 1.1
* @version 1.2  august,5, 2002
*/

package modulecoGUI.grapheco;


import javax.swing.Icon;

import modulecoFramework.modeleco.CAgent;

import modulecoGUI.CentralControl;
/**
 * This interface is implemented by classes which represents a CAgent.
 * An implementing class can be added to a CAgentRepresentationContainer
 * like CentralControl.
 * @see modulecoGUI.grapheco.CAgentRepresentationContainer
 * @see modulecoGUI.grapheco.CentralControl
 */
public interface CAgentRepresentation {
	
	/**
	 * This method will be used to set which agent should be represented.
	 * @param cAgent The CAgent that should be represented
	 */
	public void setCAgent(CAgent cAgent);
	
	/**
	 * 
	 * @return the represented Agent
	 */
	public CAgent getCAgent();

	/**
	 * Should update the representation. Called usualy after each world 
	 * iteration.
	 */
	public void updateImage();

	/**
	 * Should reset the representation.
	 */
	public void resetImage();

	/**
	 * Set the central control. Usefule in some cases. Called at the creation
	 * of the CAgentRepresentation
	 */
	public void setCentralControl(CentralControl centralControl);
	
	/**
	 * 
	 * @return the centralControl
	 */
	public CentralControl getCentralControl();
	
	/**
	 * return the name of the representation as a String.
	 */
	public String getName();
	/**
	 * set the name of the representation as a String.
	 */
	public void setName(String s);
	
	/**
	 * 
	 * @return the DefaultPosition of the Representation in the GUI
	 */
	public String getDefaultPosition();
	
	/**
	 * 
	 * @param defaultPosition
	 */
	public void setDefaultPosition(String defaultPosition);
	
	/**
	 * set the GUI Icon for this representation
	 * @param icon
	 */
	public void setIcon(Icon icon);
	
	/**
	 * 
	 * @return the GUI Icon for this representation
	 */
	public Icon getIcon();

}
