/*
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
 * DAMAGES OR LIABILITIES SUFFERED BY LICENSEE AS A RESULT OF OR
 * RELATING TO USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE OR
 * ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT,
 * SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF
 * THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 */
package modulecoGUI.cAgentEditor;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

/**
 * Column model for the PropertyTable
 *
 * @version 1.7 04/16/03
 * @author  Mark Davidson
 */
public class PropertyColumnModel extends DefaultTableColumnModel  {
    private final static String COL_LABEL_PROP = "Property";
    private final static String COL_LABEL_DESC = "Description";
    private final static String COL_LABEL_VALUE = "Value";
    private final static String COL_PARAMETERS_VALUE = "Parameters";
    private final static String COL_HELP_VALUE = "Help";

    private static final int minColWidth = 150;

    public PropertyColumnModel()  {
        // Configure the columns and add them to the model
        TableColumn column;

        // Property
        column = new TableColumn(0);
        column.setHeaderValue(COL_LABEL_PROP);
        //column.setPreferredWidth(minColWidth);
        column.setCellRenderer(new PropertyNameRenderer());
        addColumn(column);

        // Value
        column = new TableColumn(1);
        column.setHeaderValue(COL_LABEL_VALUE);
        //column.setPreferredWidth(minColWidth * 2);
        column.setCellEditor(new PropertyValueEditor());
        column.setCellRenderer(new PropertyValueEditor());
        addColumn(column);
        
        //Paramtres...
        column = new TableColumn(2);
        column.setHeaderValue(COL_PARAMETERS_VALUE);
        //column.setPreferredWidth(minColWidth);
        //PropertyParameterEditor ppe = new PropertyParameterEditor();
        column.setCellEditor(new PropertyParameterEditor());
        column.setCellRenderer(new PropertyParameterEditor());
        addColumn(column);
        
        //Aides...
        column = new TableColumn(3);
        column.setHeaderValue(COL_HELP_VALUE);
        column.setPreferredWidth(20);
        //column.setCellEditor(new TableCellEditor());
        column.setCellRenderer(new HelpRenderer());
        addColumn(column);
    }

}
