/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

import modulecoFramework.Moduleco;
import modulecoFramework.modeleco.EWorld;
import modulecoGUI.XMLGuiReader.XMLGuiReader;
import modulecoGUI.cAgentEditor.BeanInfoFactory;
import modulecoGUI.cAgentEditor.PropertyColumnModel;
import modulecoGUI.cAgentEditor.PropertyTableModel;
import modulecoGUI.cAgentEditor.editors.SwingEditorSupport;

/**
 * @author Thibaud Roussillat
 * @version 1.0
 * Cette classe reprsente le JPanel permettant d'afficher les paramtres du modle  son chargement.
 * Elle se sert des classes prsentes dans le packages modulecoGUI.cAgentEditor pour afficher des zones
 * de saisie sous la forme de JTable
 */
public class JPanelParameters extends JPanel implements ActionListener {

	/** serialVersionUID **/
	private static final long serialVersionUID = 740630972389642379L;

	/** Le CentralControl **/
	CentralControl centralControl;
	
	/** Label des catgories de paramtre (world's parameter, modele's parameters, simulation's parameters) **/
	JLabel jLabelWorldParameter;
	JLabel jLabelModelParameter;
	JLabel jLabelSimulationParameter;
	/** Le label de titre en haut qui contient le nom du modle **/
	JLabel jLabelTitle;
	
	/** JcrollPane contenant les paneaux d'dition de paramtres et
	 * qui permet de les visualiser s'ils sont trs nombreux 
	 **/
	JScrollPane jScrollPane;
	
	/** Le panneau Conteneur des paramtres **/
	JPanel jPanelContainer;
	/** Le panneau conteneur des boutons **/
	JPanel jPanelButtons;
	
	/** La checkbox permettant de spcifier s'il on veut charger un fichier de paramtre **/
	JCheckBox jCheckBoxUseParameterFile;
	/** L'adresse du fichier de paramtres  charger **/
	JTextField jTextFieldParameterFile;
	/** Le bouton permettant de parcourir l'arborescence pour trouver le fichier de paramtres **/
	JButton jButtonBrowseParameterFile;
	
	/** L'objet  introspecter : ici il s'agit du monde **/
	Object bean;
	
	/** Pour les paramtres de la simulation... mais inactif pour le moment... **/
	private JRadioButton jRadioButtonSimulationUnique;
	private JRadioButton jRadioButtonSimulationBatch;
	private ButtonGroup buttonGroupSimulation;
	
	/** Les boutons du bas permettant de valider ou non les paramtres **/
	JButton jButtonCancel;
	JButton jButtonSave;
	JButton jButtonOk;
	
	/**
	 * TODO : modifier ce j qui sert  l'affichage des param et le passer
	 * en paramtre de "displayParameters"
	 */
	int j=0;
	/** La hauteur minimum des lignes de la table **/
	int minRowHeight = 24;
	/** L'intervale entre les lignes de la table **/
	int intercellSpacing = 1;
	
	/**
	 * Constructeur de la classe JPanelParameters
	 * @param centralControl : le CentralControl pour appeler les actions ncessaires
	 * @param bean :l'objet  diter, ici en l'occurence, il s'agit du monde
	 */
	public JPanelParameters(CentralControl centralControl, Object bean) {
		
		this.centralControl = centralControl;
		this.bean = bean;
		
		this.setBackground(Color.white);
		this.setLayout(new BorderLayout());

		this.build();
		
	}

	/** Contruit l'interface graphique **/
	private void build() {
		
		// Construction "globale"
		jPanelContainer = new JPanel();
		jPanelContainer.setLayout(new GridBagLayout());
		
		jScrollPane = new JScrollPane(jPanelContainer);
		jScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		
		this.add(jScrollPane,BorderLayout.CENTER);
		
		// Construction du label de titre avec le nom du modle //
		jLabelTitle = makeJLabelTitle(Moduleco.getCurrentModelName().toUpperCase(),"");
		jLabelTitle.setBackground(Color.white);
		jLabelTitle.setHorizontalAlignment(JLabel.CENTER);
		/* Ajout du titre */
		jPanelContainer.add(jLabelTitle,new GridBagConstraints(0,j,7,1,0.0,0.0,GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(5,5,5,10),0,0));
		j++;
		
		// Construction de la zone permettant de charger un fichier de paramtre //
		jCheckBoxUseParameterFile = new JCheckBox(XMLGuiReader.getLabel("JPanelParameters/CheckBoxUseParameterFile"));
		jTextFieldParameterFile = new JTextField();
		jButtonBrowseParameterFile = new JButton(XMLGuiReader.getLabel("JPanelParameters/ButtonBrowseParameterFile"));
		
		jButtonBrowseParameterFile.addActionListener(this);
		jCheckBoxUseParameterFile.addActionListener(this);
		
		jButtonBrowseParameterFile.setEnabled(false);
		jTextFieldParameterFile.setEnabled(false);
		
		jPanelContainer.add(jCheckBoxUseParameterFile,new GridBagConstraints(0,j,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,5,5,10),0,0));
		jPanelContainer.add(jTextFieldParameterFile,new GridBagConstraints(1,j,4,1,1.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,10),0,0));
		jPanelContainer.add(jButtonBrowseParameterFile,new GridBagConstraints(5,j,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.HORIZONTAL,new Insets(5,10,5,20),0,0));
		//jPanelContainer.add(makeJLabelHelp(),new GridBagConstraints(6,j,1,1,0.0,0.0,GridBagConstraints.EAST,GridBagConstraints.NONE,new Insets(5,10,5,20),0,0));
		j++;
		
		// Construction des labels principaux : World's Parameter, Model's Parameters //
		jLabelWorldParameter = makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelWorldParameter"),"html.png");
		jLabelModelParameter = makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelModelParameter"),"exe.png");
		jLabelSimulationParameter = makeJLabelTitle(XMLGuiReader.getLabel("JPanelParameters/LabelSimulationParameter"),"file_temporary.png");
		
		// Ajout du titre "World's Parameters //
		jPanelContainer.add(jLabelWorldParameter,new GridBagConstraints(0,j,7,1,1.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,0,5,0),0,0));
		j++;
		
		// Ajout de l'dition des paramtres du monde (ModelParameter) //
		PropertyTableModel tableModelParameters = new PropertyTableModel(centralControl.modulecoLauncher.getModelParameters());
        PropertyColumnModel columnModelParameters = new PropertyColumnModel();
        JTable tableParameters = new JTable(tableModelParameters, columnModelParameters);
		
        this.setTable(tableParameters);
  
        jPanelContainer.add(tableParameters,new GridBagConstraints(0,j,7,1,1.0,1.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,25,5,25),0,0));
		j++;
		
		// Ajout du titre "Model's Parameters //
		jPanelContainer.add(jLabelModelParameter,new GridBagConstraints(0,j,7,1,1.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,0,5,0),0,0));
		j++;
		/* Ajout des paramtres sous forme de table... */
		PropertyTableModel tableModel = new PropertyTableModel(bean);
		
        PropertyColumnModel columnModel = new PropertyColumnModel();
        JTable table = new JTable(tableModel, columnModel);
        
        this.setTable(table);
        
        jPanelContainer.add(table,new GridBagConstraints(0,j,7,1,1.0,1.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,25,5,25),0,0));
		j++;
		
		/**
         * TODO : Rajouter les paramtres de simulation : simulation unique, simulation par batch, ...
		 **/
		/*jPanelContainer.add(jLabelSimulationParameter,new GridBagConstraints(0,j,7,1,1.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,0,5,0),0,0));
		j++;*/
		/* Ajout des model's parameters */
		
		/*jRadioButtonSimulationUnique = new JRadioButton("Simulation Unique");
		jRadioButtonSimulationBatch = new JRadioButton("Simulation par Batch");
		buttonGroupSimulation = new ButtonGroup();
		buttonGroupSimulation.add(jRadioButtonSimulationUnique);
		buttonGroupSimulation.add(jRadioButtonSimulationBatch);
		
		jPanelContainer.add(jRadioButtonSimulationUnique,new GridBagConstraints(0,j,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,0,5,0),0,0));
		j++;
		
		jPanelContainer.add(jRadioButtonSimulationBatch,new GridBagConstraints(0,j,1,1,0.0,0.0,GridBagConstraints.WEST,GridBagConstraints.BOTH,new Insets(5,0,5,0),0,0));
		j++;*/
		
		//displayParameters(this.getCategoryParameters(Parameter.SIMULATION_PARAMETER));
        
		/* Boucheur de trou pour que les composants soit aligns en haut...*/
		jPanelContainer.add(new JPanel(),new GridBagConstraints(0,j,7,1,1.0,1.0,GridBagConstraints.WEST,GridBagConstraints.NONE,new Insets(5,0,5,0),0,0));
	
		// Appel du constructeur des boutons du bas... //
		this.makeJButtonButtom();
		
	}
	
	private void setTable(JTable table) {
		
        table.setGridColor(UIManager.getColor("control"));
        table.setBackground(UIManager.getColor("control"));
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		
		table.setIntercellSpacing(new Dimension(0,intercellSpacing));
		
		for (int i=0;i<table.getRowCount();i++) {
        	Component c1 = table.getCellRenderer(i,1).getTableCellRendererComponent(table, table.getValueAt(i,1), false, false, i, 1);
        	Component c2 = table.getCellRenderer(i,2).getTableCellRendererComponent(table, table.getValueAt(i,2), false, false, i, 2);
        	Component c3 = table.getCellRenderer(i,3).getTableCellRendererComponent(table, table.getValueAt(i,3), false, false, i, 3);
        	
        	double c1H = c1.getPreferredSize().getHeight();
        	double c2H = c2.getPreferredSize().getHeight();
        	double c3H = c3.getPreferredSize().getHeight();
        	
        	if (c1H > c2H && c1H > c3H && c1H > minRowHeight) {
        		table.setRowHeight(i,(int)c1H);
        	}
        	else if (c2H > c1H && c2H > c3H && c2H > minRowHeight) {
        		table.setRowHeight(i,(int)c2H);
        	}
        	else {
        		table.setRowHeight(i,minRowHeight);
        	}
      
        }
		
	}
	
	/**
	 * Construction des boutons en bas du panneau de paramtre
	 * Appel par  la fin de la mthode build()
	 */
	private void makeJButtonButtom() {
		
		/**
		 * Partie des boutons du bas
		 */
		FlowLayout flowLayout = new FlowLayout();
		flowLayout.setHgap(50);
		flowLayout.setVgap(10);
		jPanelButtons = new JPanel(flowLayout);
		
		jButtonCancel = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
		jButtonSave = new JButton(XMLGuiReader.getLabel("JPanelParameters/ButtonSave"));
		jButtonOk = new JButton(XMLGuiReader.getLabel("Default/ButtonOK"));
		
		jButtonCancel.addActionListener(this);
		jButtonSave.addActionListener(this);
		jButtonOk.addActionListener(this);
		
		jPanelButtons.add(jButtonCancel);
		jPanelButtons.add(jButtonSave);
		jPanelButtons.add(jButtonOk);
		
		
		this.add(jPanelButtons,BorderLayout.SOUTH);
		
	}
	
	/**
	 * Construit un label de titre de type World's Parameters ou Model's Parameters
	 * @param label : le nom du titre
	 * @param fileName : l'image  mettre  cot
	 * @return un label avec le texte et l'image et la mise en forme
	 */
	public JLabel makeJLabelTitle(String label,String fileName) {
		
		JLabel jLabel;
		try {
			URL url = getClass().getResource("/images/JPanelParameters/"+fileName);
			//Image image = Toolkit.getDefaultToolkit().createImage("images/JPanelParameters/"+fileName);
			//String imgLocation = "images/JPanelParameters/"+fileName;
			//URL imageURL = JPanelMiddle.class.getResource(imgLocation);
			//ImageIcon icon = new ImageIcon(imageURL,"img");
			ImageIcon icon = new ImageIcon(url,"img");
			jLabel = new JLabel(label,icon,JLabel.LEFT);
		}
		catch (Exception e) {
			e.printStackTrace();
			jLabel = new JLabel(label);
		}
		
		jLabel.setOpaque(true);
		jLabel.setBackground(Color.gray);
		Font f = jLabel.getFont();
		jLabel.setFont(new Font(f.getName(),Font.BOLD,f.getSize()+4));
		jLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		jLabel.setPreferredSize(new Dimension(800,40));
		jLabel.setFocusable(false);
		
		return jLabel;
		
	}
	
	/**
	 * Fabrique les labels d'aide... (ne met qu'une image dedans ou help si pas d'image)
	 * @return un label avec une image d'aide dedans
	 */
	public JLabel makeJLabelHelp() {
		
		JLabel jLabel;
		try {
			URL url = getClass().getResource("/images/JPanelParameters/help.gif");
			//Image image = Toolkit.getDefaultToolkit().createImage("/images/JPanelParameters/help.gif");
			//String imgLocation = "../images/JPanelParameters/help.gif";
			//URL imageURL = JPanelMiddle.class.getResource(imgLocation);
			ImageIcon icon = new ImageIcon(url,"help");
			jLabel = new JLabel("",icon,JLabel.LEFT);
		}
		catch (Exception e) {
			e.printStackTrace();
			jLabel = new JLabel("Aide");
		}
		
		return jLabel;
		
	}

	/**
	 * Actionperformed : effectue les diffrentes actions en fonction des actions 
	 * utilisateurs
	 * @param ActionEvent
	 * 
	 */
	public void actionPerformed(ActionEvent e) {

		if (e.getSource().equals(jButtonOk)) {
			centralControl.validateParameters();
		}
		else if (e.getSource().equals(jButtonSave)) {
			centralControl.writeModelParameters();
		}
		else if (e.getSource().equals(jButtonCancel)) {
			centralControl.removeJPanelParameters();
		}
		else if (e.getSource().equals(jButtonBrowseParameterFile)) {
			String fileName = centralControl.readModelParameter();
			jTextFieldParameterFile.setText(fileName);
		}
		else if (e.getSource().equals(jCheckBoxUseParameterFile)) {
			jTextFieldParameterFile.setEnabled(jCheckBoxUseParameterFile.isSelected());
			jButtonBrowseParameterFile.setEnabled(jCheckBoxUseParameterFile.isSelected());
		}
		
	}

}
