/*
 * Created on 16 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

import javax.swing.JComponent;
import javax.swing.JPanel;

import modulecoGUI.grapheco.AbstractCAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentation;
import modulecoGUI.grapheco.CAgentRepresentationContainer;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.util.ViewMap;
import net.infonode.util.Direction;

/**
 * @author user
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JPanelDockingMiddle extends JPanel{

	CentralControl centralControl;
	
	/* Container principale */
	RootWindow rootWindow;
	
	/* SplitWindow bottom - top */
	SplitWindow splitWindowBottomTop;
	
	/* SplitWindow left - rigth */
	SplitWindow splitWindowLeftRigth;
	
	/* TabWindow : reprsentation graphique (sur la droite) */
	TabWindow tabWindowRigth;
	
	/* TabWindow : reprsentation des agents (sur la gauche) */
	TabWindow tabWindowLeft;
	
	/* TabWindow : reprsentation textuel (en bas...) */
	TabWindow tabWindowBottom;
	
	static String LEFT_POSITION = "LEFT";
	static String RIGTH_POSITION = "RIGTH";
	static String BOTTOM_POSITION = "BOTTOM";
	
	private int nbOfRepresentation;
	
	ViewMap viewMap;
	
	Preferences preferences = Preferences.userNodeForPackage(JPanelDockingMiddle.class);
	
	Map mapTabWindow;
	
	/**
	 * 
	 * @param centralControl
	 */
	public JPanelDockingMiddle(CentralControl centralControl) {
		
		this.centralControl = centralControl;
		this.setBackground(Color.white);
		this.setLayout(new BorderLayout());
		
		this.build();
		
	}
	
	public void build() {
		
		this.removeAll();
		this.nbOfRepresentation = 0;
		this.mapTabWindow = new HashMap();
		
		viewMap = new ViewMap();
		
		tabWindowRigth = new TabWindow();
		tabWindowRigth.setName(RIGTH_POSITION);
		mapTabWindow.put(tabWindowRigth.getName(),tabWindowRigth);
		
		tabWindowLeft = new TabWindow();
		tabWindowLeft.setName(LEFT_POSITION);
		mapTabWindow.put(tabWindowLeft.getName(),tabWindowLeft);
		
		tabWindowBottom = new TabWindow();
		tabWindowBottom.setName(BOTTOM_POSITION);
		mapTabWindow.put(tabWindowBottom.getName(),tabWindowBottom);
		
		splitWindowLeftRigth = new SplitWindow(true,0.5f,tabWindowLeft,tabWindowRigth);

		splitWindowBottomTop = new SplitWindow(false,0.7f,splitWindowLeftRigth,tabWindowBottom);
		
		// On recupre tout les AgentRepresentation
		CAgentRepresentationContainer cAgentRepresentationContainer = centralControl.getAgentRepresentationContainer();
		
		for (Iterator i=cAgentRepresentationContainer.iterator();i.hasNext();) {
			//On ajoute les vues...
			CAgentRepresentation agentRepresentation = (CAgentRepresentation) i.next();
			this.addAgentRepresentation(agentRepresentation,agentRepresentation.getDefaultPosition());
			
		}
		
		rootWindow = new RootWindow(null);
		//rootWindow = DockingUtil.createRootWindow(null, true);
		
		//preferences.get("setWindow",".")
		
		rootWindow.setWindow(splitWindowBottomTop);
		
		/*rootWindow.setWindow(
				new SplitWindow(false,0.7f,
					new SplitWindow(true,0.5f,
							viewMap.getView(0),
							new TabWindow(new DockingWindow[]{viewMap.getView(1),viewMap.getView(2),viewMap.getView(3)})
					),
					viewMap.getView(4)
				));*/
		
		rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
		this.add(rootWindow,BorderLayout.CENTER);
	
	}
	
	public void addAgentRepresentation(CAgentRepresentation agentRepresentation) {
		
		//System.out.println("JPANELDOCKING MIDDLE : adding a new Agent Representation...");
		/**
		 * TODO : a modifier qd CAgentRepresentation et AbstractAgentRepresentation seront tablie.
		 */
		if (agentRepresentation instanceof AbstractCAgentRepresentation) {
			viewMap.addView(nbOfRepresentation, new View(agentRepresentation.getName(),((AbstractCAgentRepresentation)agentRepresentation).getIcon(),(JPanel)agentRepresentation));
		}
		else {
			viewMap.addView(nbOfRepresentation, new View(agentRepresentation.getName(),null,(JComponent)agentRepresentation));
		}
		nbOfRepresentation++;
		this.validate();
		this.repaint();
		
	}
	
	/**
	 * TODO : implmenter les politiques de rpartition de Panel
	 * @param agentRepresentation 
	 * @param tabName : le nom du panneau o mettre cette reprsentation
	 */
	public void addAgentRepresentation(CAgentRepresentation agentRepresentation, String tabName) {
		
		/**
		 * TODO : a modifier qd CAgentRepresentation et AbstractAgentRepresentation seront tablie.
		 */
		View view;
		if (agentRepresentation instanceof AbstractCAgentRepresentation) {
			view = new View(agentRepresentation.getName(),((AbstractCAgentRepresentation)agentRepresentation).getIcon(),(JComponent)agentRepresentation);
		}
		else {
			view = new View(agentRepresentation.getName(),null,(JComponent)agentRepresentation);
		}
		//View view = new View(agentRepresentation.getName(),agentRepresentation.getIcon(),(JPanel)agentRepresentation);
		//View view = new View("Representation "+nbOfRepresentation,null,(JPanel)agentRepresentation);
		viewMap.addView(nbOfRepresentation, view);
		nbOfRepresentation++;
		
		//TabWindow tw = getTabWindow(rootWindow,tabName);
		TabWindow tw=null;
		//System.out.println("addAgentRepresentation : " + agentRepresentation.getName() + " , " + tabName );
		if (tabName != null) {
			 tw = (TabWindow) mapTabWindow.get(tabName);
		}
		else {
			tw = (TabWindow) mapTabWindow.get(RIGTH_POSITION);
		}
		
		if (tw == null) {
			tw = this.getFirstTabWindow(rootWindow);
		}
		
		tw.addTab(view);
		view.restore();
		
	}
	
	/**
	 * 
	 *
	 */
	public void displayDockingHierarchy() {
		
		displayDockingHierarchy(rootWindow,"");
		
	}
	
	/**
	 * 
	 * @param dw
	 * @param indent
	 */
	public void displayDockingHierarchy(DockingWindow dw, String indent) {
		System.out.println(indent+dw.getName()+" : "+dw.getTitle()+" : "+dw.getClass());
		for (int i=0;i<dw.getChildWindowCount();i++) {
			displayDockingHierarchy(dw.getChildWindow(i),indent+"\t");
		}
	}
	
	/**
	 * Recupre la premire TabWindow capable d'hberger une reprsentation graphique...
	 * @param dw DockingWindow mre
	 * @return the first TabWindow dans l'arbre graphique
	 */
	private TabWindow getFirstTabWindow(DockingWindow dw) {
		
		// je suis une tabWindow
		if (TabWindow.class.equals(dw.getClass())) return (TabWindow) dw;
		// je ne suis pas une tab window mais j'ai des enfants
		else {
			int i=0;
			DockingWindow dwChild = null;
			while (i<dw.getChildWindowCount() && dwChild == null) {
				dwChild = getFirstTabWindow(dw.getChildWindow(i));
				i++;
			}
			if (dwChild != null && dwChild.getClass().equals(TabWindow.class)) return (TabWindow)dwChild;
			else return null;
		}
		
	}
	
	/**
	 * 
	 * @param dw
	 * @param name
	 * @return
	 */
	/*public TabWindow getTabWindow(DockingWindow dw, String name) {
		if (name.equals(dw.getName()) && dw.getClass().equals(TabWindow.class)) return (TabWindow)dw;
		else {
			int i=0;
			DockingWindow dwChild = null;
			while (i<dw.getChildWindowCount() && dwChild == null) {
				dwChild = getTabWindow(dw.getChildWindow(i), name);
				i++;
			}
			if (dwChild != null && dwChild.getClass().equals(TabWindow.class)) return (TabWindow)dwChild;
			else return null;
		}
	}*/

	/**
	 * Permet de remettre  zro l'organisation des diffrents composants
	 * dans la fentre principale
	 */
	public void resetPerspective() {
		
		this.build();
		
		/*
		tabWindowRigth = new TabWindow(new DockingWindow[]{viewMap.getView(1),viewMap.getView(2),viewMap.getView(3),viewMap.getView(4)});
		tabWindowRigth.setName("tabWindowRigth");
		splitWindowLeftRigth = new SplitWindow(true,0.5f,viewMap.getView(0),tabWindowRigth);
		splitWindowBottomTop = new SplitWindow(false,0.7f,splitWindowLeftRigth,viewMap.getView(5));
		rootWindow.setWindow(splitWindowBottomTop);
		*/
	}
	
	/**
	 * 
	 * @param listView: Une liste de "View" contenant des "Component"
	 * @param c : Class
	 * @return la liste des "View" constitu de "Component" de classe c
	 */
	/*private List getView(List listView, Class c) {
		
		List list = new ArrayList();
		for (Iterator i=listView.iterator();i.hasNext();) {
			View v = (View) i.next();
			if (v.getComponent().getClass().equals(c)) {
				list.add(i.next());
			}
		}
		return list;
		
	}*/

	/**
	 * @param name
	 */
	public void showView(String name) {
	
		for (int i=0;i<viewMap.getViewCount();i++) {
			if (viewMap.getView(i).getTitle().equals(name)) {
				viewMap.getView(i).restore();
			}
		}
	}
	
	
	/**
	 * TODO : Unused
	 * @param dw
	 * @param title
	 * @return
	 */
	/*public View findView(DockingWindow dw, String title) {
		//System.out.println(dw.getTitle());
		if (title.equals(dw.getTitle()) && dw.getClass().equals(View.class)) return (View)dw;
		else {
			int i=0;
			DockingWindow dwChild = null;
			while (i<dw.getChildWindowCount() && dwChild == null) {
				dwChild = findView(dw.getChildWindow(i), title);
				i++;
			}
			if (dwChild != null && dwChild.getClass().equals(View.class)) return (View)dwChild;
			else return null;
		}
	}*/
	
	/*public void writeConfiguration() {
		//	 Write the window state to a byte array
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		ObjectOutputStream out = new ObjectOutputStream(bos);
		rootWindow.write
		rootWindow.write(out);
		preferences.putByteArray("rootWindow",bos.)
		out.close();
	}*/
	
}
