package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

import modulecoFramework.Moduleco;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

public class JModelChooser extends JPanel implements ActionListener {
	
	/** serialVersionUID **/
	private static final long serialVersionUID = 8650215181519467527L;
	
	JList jListModel;
	JScrollPane jScrollPaneListModel;
	
	JPanel jPanelMiddle;
	JPanel jPanelButton;
	
	JButton jButtonOk;
	JButton jButtonAnnuler;
	
	JLabel jLabelModelName;
	
	JDialog jDialog;
	
	static public int APPROVE_OPTION = 1;
	static public int CANCEL_OPTION = 0;
	
	static int action;
	
	public JModelChooser(Component parent, String string) {
		
		this.setLayout(new BorderLayout());
		
		jPanelButton = new JPanel(new FlowLayout());
		
		jButtonAnnuler = new JButton(XMLGuiReader.getLabel("Default/ButtonCancel"));
		jButtonOk = new JButton(XMLGuiReader.getLabel("Default/ButtonOK"));
		
		jButtonAnnuler.addActionListener(this);
		jButtonOk.addActionListener(this);
		
		jPanelButton.add(jButtonAnnuler);
		jPanelButton.add(jButtonOk);
		
		jLabelModelName = new JLabel(XMLGuiReader.getLabel("JModelChooser/LabelChoosenModel"));
		
		List list = Moduleco.getModelsList();
		jListModel = new JList(list.toArray());

		MouseListener mouseListener = new MouseAdapter() {
		     public void mouseClicked(MouseEvent e) {
		    	 int index = jListModel.locationToIndex(e.getPoint());
		    	 jLabelModelName.setText(jListModel.getModel().getElementAt(index).toString());
		         //System.out.println("Double clicked on Item " + index);
		     }
		 };
		jListModel.addMouseListener(mouseListener);
		
		jScrollPaneListModel = new JScrollPane(jListModel);
		jScrollPaneListModel.setPreferredSize(new Dimension(150,80));
		
		jPanelMiddle = new JPanel(new GridBagLayout());
		jPanelMiddle.add(new JLabel(XMLGuiReader.getLabel("JModelChooser/LabelChooseAModel")),new GridBagConstraints(0,0,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(5,5,5,5),0,0));
		jPanelMiddle.add(jScrollPaneListModel,new GridBagConstraints(0,1,1,1,0.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(5,5,5,5),0,0));
		jPanelMiddle.add(new JLabel(XMLGuiReader.getLabel("JModelChooser/LabelChoosenModel")),new GridBagConstraints(1,1,1,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.NONE,new Insets(5,5,5,5),0,0));
		jPanelMiddle.add(jLabelModelName,new GridBagConstraints(2,1,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.NONE,new Insets(5,5,5,5),0,0));
		
		jPanelMiddle.setPreferredSize(new Dimension(400,300));
		
		//this.add(jScrollPaneListModel,BorderLayout.CENTER);
		this.add(jPanelMiddle,BorderLayout.CENTER);
		this.add(jPanelButton,BorderLayout.SOUTH);
		
		jDialog = this.createDialog(parent);
		

		jListModel.setSelectedValue(string, true);
		if (jListModel.getSelectedValue() != null && jListModel.getSelectedValue().equals(string)) {
			jLabelModelName.setText(string);
		}
		else {
			jLabelModelName.setText(XMLGuiReader.getLabel("JModelChooser/NoModelSelected"));
		}
		
	}
	
	public String getSelectedModel() {
		return (String) jListModel.getSelectedValue();
	}
	
	public int showModelChooser() {
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return action;
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle(XMLGuiReader.getLabel("JModelChooser/Frame"));
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}

	public void actionPerformed(ActionEvent evt) {
		
		if (evt.getSource().equals(jButtonAnnuler)) {
			action = CANCEL_OPTION;
			jDialog.dispose();
		}
		else if (evt.getSource().equals(jButtonOk)) {
			action = APPROVE_OPTION;
			jDialog.dispose();
		}
		
	}
	
}
