/*
 * Created on 27 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.utils.graphicalWatcher.GraphicalWatcher;
import modulecoGUI.cAgentEditor.JAgentEditor;
import modulecoGUI.cAgentEditor.PropertyColumnModel;
import modulecoGUI.cAgentEditor.PropertyTableModel;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

/**
 * @author Thibaud Roussillat
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class JAgentEditorQuick extends AbstractCAgentRepresentation {
	
	GraphicalWatcher graphicalWatcher;
	
	JComboBox jComboBoxCommunities;
	JComboBox jComboBoxGroups;
	JComboBox jComboBoxRoles;
	
	JList jListAgent;
	
	JLabel jLabelCommunity;
	JLabel jLabelGroup;
	JLabel jLabelRole;
	JLabel jLabelList;
	JLabel jLabelAvertissement;
	
	JButton jButtonEdit;
	
	static String MESSAGE_NO_AGENT = "Attention! Aucun agent n'est prsent dans la liste! Cela peut affecter les rsultats.";
	static String MESSAGE_AGENT_WITH_DIFF_CLASS = "Attention! Les agents prsents dans cette communaut/groupe/role sont de type diffrent! Cela peut affecter les rsultats.";
	
	String choosenCommunity="";
	String choosenGroup="";
	String choosenRole="";
	
	public JAgentEditorQuick(GraphicalWatcher graphicalWatcher) {
		
		this.graphicalWatcher = graphicalWatcher;
		
		this.setLayout(new GridBagLayout());
		this.setDefaultPosition(AbstractCAgentRepresentation.BOTTOM_POSITION);
		this.name = "Agents Editor";
		
		this.build();
		
	}
	
	private void build() {

		jLabelCommunity = new JLabel("Communaut : ");
		jLabelGroup = new JLabel("Group : ");
		jLabelRole = new JLabel("Role : ");
		jLabelList = new JLabel("Agents List : ");
		jLabelAvertissement = new JLabel(MESSAGE_NO_AGENT);
		
		jComboBoxCommunities = new JComboBox(graphicalWatcher.getCommunities());
		jComboBoxGroups = new JComboBox();
		jComboBoxRoles = new JComboBox();
		
		jListAgent = new JList(new String[]{});
		
		jComboBoxCommunities.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
		        choosenCommunity = (String)jComboBoxCommunities.getSelectedItem();
		        //System.out.println(s);
		        jComboBoxGroups.removeAllItems();
		        String[] groups = graphicalWatcher.getGroups(choosenCommunity);
		        for (int i=0;i<groups.length;i++) {
		        	jComboBoxGroups.addItem(groups[i]);
		        }
			}		
		});
		
		jComboBoxGroups.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
		        choosenGroup = (String)jComboBoxGroups.getSelectedItem();
		        jComboBoxRoles.removeAllItems();
		        String[] roles = graphicalWatcher.getRoles(choosenCommunity,choosenGroup);
		        for (int i=0;i<roles.length;i++) {
		        	jComboBoxRoles.addItem(roles[i]);
		        }
			}		
		});
		
		jComboBoxRoles.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
		        
				/* Building a probe to get agent with specified community, group and role */
				choosenRole = (String)jComboBoxRoles.getSelectedItem();
				//System.out.println("Choosen C/G/R : "+choosenCommunity+"/"+choosenGroup+"/"+choosenRole);
				Probe probe = graphicalWatcher.createProbe(
						choosenCommunity,
						choosenGroup,
						choosenRole);
		        //System.out.println("Nbre d'agents : "+probe.getCurrentAgentsList().size());
				/* Adding all agents to the list */
		        DefaultListModel defaultListModel = new DefaultListModel();
		        boolean sameClass = true;
		        Class c = null;
		        for (Iterator i=probe.getAgentsIterator();i.hasNext();) {
		        	AbstractAgent aa = (AbstractAgent)i.next();
		        	Class cl = aa.getClass();
		        	if (c != null) {
		        		if (!c.equals(cl)) sameClass = false;
		        	}
		        	c = cl;
		        	//defaultListModel.addElement(aa.getName());
		        	defaultListModel.addElement(aa);
		        }
		        jListAgent.setModel(defaultListModel);
		        if (!sameClass) {
		        	jLabelAvertissement.setText(MESSAGE_AGENT_WITH_DIFF_CLASS);
		        }
		        else if (probe.getCurrentAgentsList().size() == 0) {
		        	jLabelAvertissement.setText(MESSAGE_NO_AGENT);
		        }
		        else {
		        	jLabelAvertissement.setText("");
		        }
			}		
		});
		
		final JComponent jComp = this;
		MouseListener mouseListener = new MouseAdapter() {
		     public void mouseClicked(MouseEvent e) {
		         if (e.getClickCount() == 2) {
		             int index = jListAgent.locationToIndex(e.getPoint());
		             EAgent agent = (EAgent)jListAgent.getSelectedValue();
		             System.out.println("Double clicked on Item " + index+" : "+jListAgent.getSelectedValue());
		             System.out.println("Class : " + agent.getClass().getName());
		             
		             JAgentEditor jAgentEditor = new JAgentEditor(agent);
		             jAgentEditor.showAgentEditor(jComp);
		             
		             //graphicalWatcher.get
		          }
		     }
		 };
		 jListAgent.addMouseListener(mouseListener);

		jButtonEdit = new JButton("Edit...");
		jButtonEdit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent evt) {
				EAgent agent = (EAgent)jListAgent.getSelectedValue();
				if (agent != null) {
					JAgentEditor jAgentEditor = new JAgentEditor(agent);
					jAgentEditor.showAgentEditor(jComp);
				}
				else {
					String message = "No agent selected! Please select an agent in the list.";
					JOptionPane.showMessageDialog(jComp, message, "Warning", JOptionPane.WARNING_MESSAGE);
				}
			}
		});
		
		this.add(jLabelCommunity, 
				new GridBagConstraints(0,0,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,0,5),0,0));
		this.add(jComboBoxCommunities,
				new GridBagConstraints(0,1,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		
		this.add(jLabelGroup,
				new GridBagConstraints(0,2,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(jComboBoxGroups,
				new GridBagConstraints(0,3,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		
		this.add(jLabelRole,
				new GridBagConstraints(0,4,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(jComboBoxRoles,
				new GridBagConstraints(0,5,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		
		this.add(jLabelList,
				new GridBagConstraints(1,0,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,5,0,5),0,0));
		this.add(new JScrollPane(jListAgent),
				new GridBagConstraints(1,1,1,4,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
		this.add(jButtonEdit,
				new GridBagConstraints(1,6,1,1,0.5,0.0,GridBagConstraints.CENTER,GridBagConstraints.NONE,new Insets(0,5,0,5),0,0));
		
		this.add(jLabelAvertissement,
				new GridBagConstraints(0,6,1,1,0.5,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
		
		//this.add(new JPanel(),
				//new GridBagConstraints(0,7,1,2,1.0,1.0,GridBagConstraints.NORTHWEST,GridBagConstraints.BOTH,new Insets(0,5,5,5),0,0));
	}

	public void updateImage() {
		// TODO Auto-generated method stub
		
	}

	public void resetImage() {
		// TODO Auto-generated method stub
		
	}
	

}
