/**
 * EWorld.java
 * Copyright (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr, Denis.Phan@enst-bretagne.fr, philippe.legoff@enst-bretagne.fr
 * @version 1.0  May 2000
 * @version 1.2  August 2002
 * @version 1.4  February 2004
 */
package modulecoFramework.modeleco;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.io.Serializable;
import java.util.List;
import modulecoFramework.medium.Medium;
import modulecoFramework.simulation.SimulationControl;
import modulecoFramework.*;

// MadKit
import madkit.kernel.*;
// MadKit
/**
 * Je dfinis un monde (carr) puis le fais voluer. Un monde est caractris
 * par les classes passes en paramtre du constructeur :
 * <p>
 * <ol>
 * <li>capacity : n*n, la taille du monde (le nombre d'agents visibles)
 * <li>eaClass : nom de la classe des agents (unique - donc tous agents
 * identiques))
 * <li>vsClass : nom de la classe dcrivant la manire de construire les
 * voisinages)
 * <li>tsClass : nom de la classe dcrivant la nature de l'volution du temps
 * <li>zsClass : nom de la classe dcrivant la zone qui volue  chaque
 * volution
 * </ol>
 * Je m'initialise en 4 phases :
 * <ol>
 * <li>populateAll(nsClass) pour la cration des agents, mdiums ...
 * <li>connectAll() pour leur interconnexion
 * <li>initAll() pour leur initialisation
 * <li>compute() pour dfinir mon tat de dpart
 * </ol>
 * J'execute chacun de mes pas dans un Thread contrairement aux EAgent...
 * <p>
 * Si l'on souhaite altrer la faon de parcourir mon contenu, il suffit de
 * redefinir iterator().
 * <p>
 * La methode edit() est spcialise dans les sous-classes.
 */
public abstract class EWorld extends Watcher implements ReferenceableAgent, CAgent, Serializable {
    /**
     * Define for each medium the connection strategy used to attach agents and
     * mediums. There are as many mediums as connectionsStrategies. <br>
     * Used only by subclasses.
     */
    protected ZoneSelector[] connectionsStrategies;
    /**
     * Used in this.initAll()
     */
    protected Medium[] mediumsInWorld;
    /**
     * Extra-Agents are Agents that are not visible.
     */
    protected CAgent[] extraAgents = new CAgent[0];
    /**
     * The ID of the world considered as an agent in the world it belongs (in
     * case of recursive simulation)
     */
    protected int agentID;
    /**
     * N, the size of a row of agents. <br>
     * The World is a N-by-N square of agents.
     */
    public int length;
    /**
     * The NxN visible agents
     */
    public int agentSetSize;
    
    /**
     * Manage the simulation.
     * TODO : remove ?
     */
    public SimulationControl simulationControl;
   
    /**
     * The agent list
     */
    public ArrayList agentSet;
   
    //	====== RECURSIVITY
    /**
     * My own Mediums, since I'm potentialy an Agent. used only by
     * this.getMediums()- (in case of recursion)
     */
    protected Medium[] mediums;
    
    /**
     * The world I'm in (in case of recursion). <br>
     * For parent word if needed, "this" by default.
     */
    protected EWorld worldMother;
    
    /**
     * Reprsente sous forme de String les variables d'entre  afficher
     * TODO : reflchir sur le positionnement de ce tableaux. Voir pr le migrer ds une classe abstraite
     * pour la partager avec EAgent.
     */
    public String[] inputParameters; //Thib 31/5/05
    
    public String[] outputParameters; //Thib 31/5/05
    
    public String[] outputGraphics;
    
    public ModelParameters modelParameters;
    
    public HashMap hashMapChoiceValue;
    public HashMap hashMapChoiceString;
    
    /**
     * Construit un nouveau monde sans paramtre.
     * Attention, ceux-ci devront tre spcifi utlrieurement
     */
    
    public EWorld() {
    	System.out.println("-->EWorld()");
    	this.setWorld(this);
    	inputParameters=new String[]{};
    	outputParameters=new String[]{};
    	outputGraphics=new String[]{"Canevas","Graphique"};
    	hashMapChoiceString = new HashMap();
    	hashMapChoiceValue = new HashMap();
    	//this.getInfo();
    }
    
    public void build() {
    	System.out.println("-->EWorld.build()");
    	this.length = modelParameters.length;
    	agentSetSize = length * length;
    	agentSet = new ArrayList(agentSetSize);
    }
    
    /**
     * Set the ModelParameters to this model.
     * @param modelParameters
     */
    public void setModelParameters(ModelParameters modelParameters) { // Thib 31/05/05
    	this.modelParameters = modelParameters;
        this.length = modelParameters.length;
        this.agentSetSize = length * length;
        agentSet = new ArrayList(agentSetSize);
    }
    
    /**
     * 
     * @return the ModelParameter of this model
     */
    public ModelParameters getModelParameters() {
    	return this.modelParameters;
    }
    
    /**
     * Get information from the editor (during <init>- constructor) <br>
     * Required to be a CAgent.
     */
    //public abstract void getInfo();
   
    /**
     * Called when the world is created.
     */
    public void activate() {
    	System.out.println("-->EWorld.activate()");
        createGroup(false, Moduleco.COMMUNITY, Moduleco.MODEL_GROUP, null, null);
        createGroup(false, Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, null, null);
        requestRole(Moduleco.COMMUNITY, Moduleco.MODEL_GROUP, Moduleco.ENVIRONMENT_ROLE, null);
        requestRole(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, Moduleco.ENVIRONMENT_ROLE, null);
        //init();
    }
    
    /** 
     * Called when the world is killed.
     */
    public void end() {
        for(Iterator i=agentSet.iterator();i.hasNext();){
            killAgent((AbstractAgent)i.next());
        }
    }
    
    /**
     * Populate the world with Agents, Mediums, ZoneSelectors method invoked by
     * ModulecoLauncher.agentLauncher(EWorld ew) Not to redefine
     * Methods that subclasses CAN redefine
     */
    public void populateAll(String nsClass) {
    	System.out.println("-->EWorld.populateAll()");
        this.populate();
    }
    
    /**
     * Populate the world with Agents, Mediums, ZoneSelectors This is a default
     * implementation to be ascendent compatible with the previous neighbourhood
     * management Methods that subclasses CAN redefine
     */
    // Because populate() can be redefine by subclasses
    // please add command line in populateAll but not in populate()
    public void populate() {
    	System.out.println("-->EWorld.populate()");
        //System.out.println("eWorld.populate()");
    }
    
    /**
     * Methods that subclasses CAN redefine
     */
    public void connectAll() {
        //System.out.println("eWorld.connectAll()");
    	System.out.println("-->EWorld.connectAll()");
        this.connect();
    }
    
    /**
     * Connect Agents with Mediums... This is a default implementation to be
     * ascendent compatible with the previous neighbourhood management It
     * assumes that Agent have already created a NeighbourMedium.
     * Methods that subclasses CAN redefine
     */
    public void connect() {
    	System.out.println("-->EWorld.connect()");
        // Because connect() can be redefine by subclasses
        // please add command line in connectAll() but not in connect()
        //System.out.println("eWorld.connect()");
    }
    
    /**
     * Initialize all states (Mediums and Agents) method invoked by
     * modulecoFramework.modeleco.SimulationControl
     * Methods that subclasses CAN redefine
     */
    public void initAll() {
        System.out.println("-->EWorld.InitAll()");
        for (Iterator i = agentSet.iterator(); i.hasNext();) {
            ((EAgent) i.next()).init();
        }
        if (extraAgents != null) {
            for (int i = 0; i < extraAgents.length; i++) {
                extraAgents[i].init();
            }
        }
        if (mediumsInWorld != null) {
            for (int i = 0; i < mediumsInWorld.length; i++) {
                mediumsInWorld[i].init();
            }
        }
        this.init();
    }
    
    /**
     *  Initialize the world. Do nothing, but can be overloaded in subclasses.
     *  Required to be a CAgent. Methods that subclasses CAN redefine
     * @see{ENeighbourWorld, mobility.EMobileWorld}
     */
    public void init() {
    	System.out.println("-->EWorld.init()");
        // Because init() can be redefine by subclasses
        // please add command line in initAll() but not in init()
        //System.out.println("eWorld.init()");
    }
    //	==== step method invoked at the initialization
    /**
     * Required to be a CAgent. Methods that subclasses MUST redefine MISE AU
     * POINT DOIT DEVENIR ABSTRAITE Liste des modeles qui n'implementent pas
     * compute : discrete Choice, Ecxploration Exploitation, KMR Lux segragation
     * twoPart Tarif Competition
     */
    public void compute() {
    	System.out.println("-->EWorld.compute()");
    } //abstract ;
    //	==== step method ====
    /**
     * At each time step, method inoked by SimulationControl.progress() Commit
     * the Cagent state change.
     *  Methods that subclasses CAN redefine
     * @see modulecoFramework.modeleco.SimulationControl.progress()
     */
    public void commitAll() { //DP 05/08/2002
        //System.out.println("eWorld.commitAll()");
    	System.out.println("-->EWorld.commitAll()");
        compute();
        commit();
    }
    /**
     * Commit the Cagent state change. First recalculate the world state, then
     * update the statManager, then the display. Required to be a CAgent.
     *  Methods that subclasses CAN redefine
     */
    public void commit() {
    	System.out.println("-->EWorld.commit()");
        // Because commit() can be redefine by subclasses
        // please add command line in commitAll() but not in commit()
        //System.out.println("eWorld.commit()");
        
    }
    //============ Terminate the process =====
    /**
     * To close my editor and those of my content (CAgents). Required to be a
     * CAgent. invoked by SimulationControl.terminate()
     * TODO : verify if not duplicate with the method end()
     * @see modulecoFramework.modeleco.EAgent.terminate()
     * @see modulecoFramework.modeleco.SimulationControl.terminate()
     */
    public void terminate() {
        System.out.println("EWorld.terminate()");
        List listAgent = getAgentsRefWithRole("basicAgent");
        for (Iterator i = listAgent.iterator();i.hasNext();) {
        	killAgent((AbstractAgent) i.next());
        }
        agentSet.clear();
        //killAgent(this);
    }
    /**
     * MadKit / non active method linked with terminate() ?
     * TODO : remove ???
     */
    public void cleanup() {
        System.out.println("eWorld.cleanup()");
    }
   
    /**
     * Return the current number of iteration by calling the simulationControl.getIter();
     * this method is called by the model "Lux" and "BilateralMarket"
     */
    public int getIter() { // added DP 02/08/2001
        System.out.println("eWorld.getIter()");
        return simulationControl.getIter();
    }
    
    //==== AgentSet =====================================
    /**
     * get the ith element of the population encapsulate method get() of the
     * class ArrayList
     *
     */
    public Object get(int i) {
        return agentSet.get(i);
    }
    
    /**
     * return an iterator on the elements of the population encapsulate class
     * iterator() associated with ArrayList
     */
    public Iterator iterator() {
        //return agentSet.iterator();
        return getAgentsRefWithRole("basicAgent").iterator();
    }
    
    /**
     * insert a CAgent at the ith position on the elements of the population
     * encapsulate method add() of the class ArrayList
     */
    public EAgent addAgent(String className) {
        EAgent eAgent=null;
        try{
	        eAgent = (EAgent) Moduleco.getClass(this.pack() +"."+className).newInstance();
	        eAgent.setWorld(this);
	        eAgent.setAgentID(agentSet.size());
	        //eAgent.getInfo();
	        agentSet.add(eAgent);
	        launchAgent((EAgent)eAgent, "modulecoAgent"+(agentSet.size()-1), false);
        }
        catch(Exception e) {
        	System.err.println("Unable to launch agent "+className+" "+e);e.printStackTrace();
        }
        return eAgent;
    }
    
    /**
     * encapsulate method indexOf() of the class ArrayList (used in many
     * subclasses)
     *
     * @param agent
     * @return the index of this CAgent within the ArrayList
     */
    public int getIndex(CAgent agent) {
        return agentSet.indexOf(agent);
    }
    
    /**
     * return the size of the population
     *
     */
    public int size() {
        return agentSet.size();
    }
    
    /**
     * Returns the arraylist of the agentSet
     *
     */
    public ArrayList getAgents() {
        return agentSet;
    }
 
    /**
     * Inverse world state. Do nothing. Can be overloaded. Required to be a
     * CAgent.
     */
    public void inverseState() {}
    
    /**
     * Create the Autorun of the model.
     *
     * @return the Autorun
     */
    public CAutorun createAutorun() {
        return null;
    }
    
    /**
     * Access to the world state. Do nothing. Can be overloaded. Required to be
     * a CAgent.
     */
    public Object getState() {
        return null;
    }
    
    /**
     * Return the array of non visible CAGents (extraAgents)
     * @see{models.market.World}
     */
    public CAgent[] getExtraAgents() {
        return extraAgents;
    }
    
    /**
     * Return the array of mediums in this world.
     * @see{medium.Medium}
     * Required to be a CAgent.
     */
    public Medium[] getMediums() {
        return mediums;
    }
    
    /**
     * Get the world I'm in (usualy myself) Required to be a CAgent.
     */
    public EWorld getWorld() {
        return worldMother;
    }
    
    /**
     * Get the number of agents in this world Math.square(getLength())
     */
    public int getAgentSetSize() {
        return agentSetSize;
    }
    
    /**
     * Get the length of this EWorld.
     *
     * @return length
     */
    public int getLength() {
        return length;
    }
    
    /**
     * Get the full path of the implementation of this EWorld.
     *
     * @return name
     */
    public String pack() {
        String name = this.getClass().getName();
        return name.substring(0, name.lastIndexOf('.'));
    }
    
    /**
     * Get the package name of the implementation of this EWorld.
     */
    public String getPackageName() {
        return ((this.getClass()).getPackage()).getName();
    }
    
    /**
     * The agentID of this EWorld is -1.
     *
     * @return -1
     */
    public int getAgentID() {
        return -1;
    }
    
    /**
     * Set the world I'm in (usualy myself) Required to be a CAgent.
     *
     * @param eWorld
     */
    public void setWorld(EWorld eWorld) {
        worldMother = eWorld;
    }
    
    /**
     * Set the agent ID in the world I'm in
     */
    public void setAgentID(int agentID) {
        this.agentID = agentID;
    }
    
    /**
     * Set the SimulationControl. <br>
     * Used in SimulationCrontol.buildScheduler()
     *
     * @param simulationControl
     */
    public void setSimulationControl(SimulationControl simulationControl) {
        this.simulationControl = simulationControl;
    }
    
    //////////////////////// FM
    
    /**takes a role within the simulation*/
    public void playRole(String roleName){
		requestRole(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, roleName, null);
	}

	/**gives up a role within the simulation*/
   	public void leaveRole(String roleName){
		leaveRole(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, roleName);
    }
    
    public List getAgentsRefWithRole(String roleName){
        try{
        Probe p = new Probe(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, roleName);
        addProbe(p);
        List l = p.getCurrentAgentsList();
        removeAllProbes();
        return l;}
        catch(Exception e){return new ArrayList();}
    }
    
    public void initializeMedium(){
    }
    
    public double nextEventDeltaTime(){
        return 1;
    }
    
    /** 
     * Ajoute le paramtre de nom donn au vecteur inputParameters
     * @param s : le nom du paramtre
     */
    public void addInputParameters(String s) {
    	String[] temp = inputParameters;
    	inputParameters = new String[temp.length+1];
    	for (int i = 0; i < temp.length; i++) {
			inputParameters[i] = temp[i];
		}
    	inputParameters[temp.length] = s;
    }
    
    /** 
     * Ajoute les paramtres dont les noms sont dans le vecteur au vecteur inputParameters
     * @param s : le nom du paramtre
     */
    public void addInputParameters(String[] s) {
    	String[] temp = inputParameters;
    	inputParameters = new String[temp.length+s.length];
    	for (int i = 0; i < temp.length; i++) {
			inputParameters[i] = temp[i];
		}
    	for (int i = 0; i < s.length; i++) {
    		inputParameters[temp.length+i] = s[i];
		}
    	
    }
    
    /** 
     * Enlve toutes les entres prsentes dans inputParameters
     * Cette mthode est surtout utile s'il on veut retirer les paramtres
     * dfinis dans les classes mres.
     */
    public void clearInputParameters() {
    	inputParameters = new String[0];
    }
    
    /** 
     * Ajoute le paramtre de nom donn au vecteur outputParameters
     * @param s : le nom du paramtre
     */
    public void addOutputParameters(String s) {
    	String[] temp = outputParameters;
    	outputParameters = new String[temp.length+1];
    	for (int i = 0; i < temp.length; i++) {
    		outputParameters[i] = temp[i];
		}
    	outputParameters[temp.length] = s;
    }
    
    /** 
     * Ajoute les paramtres dont les noms sont dans le vecteur au vecteur outputParameters
     * @param s : le nom du paramtre
     */
    public void addOutputParameters(String[] s) {
    	String[] temp = outputParameters;
    	outputParameters = new String[temp.length+s.length];
    	for (int i = 0; i < temp.length; i++) {
    		outputParameters[i] = temp[i];
		}
    	for (int i = 0; i < s.length; i++) {
    		outputParameters[temp.length+i] = s[i];
		}
    }
    
    /** 
     * Enlve toutes les entres prsentes dans outputParameters
     * Cette mthode est surtout utile s'il on veut retirer les paramtres
     * dfinis dans les classes mres.
     */
    public void clearOutputParameters() {
    	outputParameters = new String[0];
    }
    
    /** 
     * Ajoute la sortie graphique de nom donn au vecteur outputGraphics
     * @param s : le nom du graphique
     */
    public void addOutputGraphics(String s) {
    	String[] temp = outputGraphics;
    	outputGraphics = new String[temp.length+1];
    	for (int i = 0; i < temp.length; i++) {
    		outputGraphics[i] = temp[i];
		}
    	outputGraphics[temp.length] = s;
    }
    
    public void addOutputGraphics(String[] s) {
    	String[] temp = outputGraphics;
    	outputGraphics = new String[temp.length+s.length];
    	for (int i = 0; i < temp.length; i++) {
    		outputGraphics[i] = temp[i];
		}
    	for (int i = 0; i < s.length; i++) {
    		outputGraphics[temp.length+i] = s[i];
		}
    }
    
    public void clearOutputGraphics() {
    	outputGraphics = new String[0];
    }
    
    /** 
     * Permet d'ajouter diffrents choix pour une variables
     * @param parameterName : le nom de la variable
     * @param choicesNames : tableau contenant le nom des choix
     * @param choicesValues : tableau contenant les valeurs des choix
     */
    public void addInputParametersChoices(String parameterName, String[] choicesNames, Object[] choicesValues) {
    	hashMapChoiceString.put(parameterName,choicesNames);
    	hashMapChoiceValue.put(parameterName,choicesValues);
    }
    
}