/**
 * Title:       bilateralGame.Agent<p>
 * Description:  Chaque Agent joue avec ses voisins et adopte, pour le tour suivant, la
 * statgie de celui qui a le meilleur gain. Le gain est rinitialis  chaque tour.
 * La matrice de gain est la mme pour tous les Agents ; elle est enregistr par le World.<p>
 * Copyright:    Copyright (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr, Denis.Phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */
package modulecoFramework.abstractModels;

import java.util.Iterator;

import modulecoFramework.modeleco.EAgent;

import modulecoFramework.medium.NeighbourMedium;


public abstract class EAgentGame extends EAgent {
	
	public boolean newStrategy, oldStrategy, nextStrategy;
	protected String revisionRuleIndex;
	protected boolean hasChanged;
	protected int[][] payoffMatrix;
	protected int payoff = 0;

	public EAgentGame() {
		super();
		inputParameters = new String[] {"newStrategy","oldStrategy"};
	}

	public void init() {
		
		//System.out.println("EAgentGame.init()");
		EWorldGame w = (EWorldGame) world;
		revisionRuleIndex = w.getRevisionRuleIndex();
		
		payoffMatrix = new int[2][2];
		
		payoffMatrix[0][0] = w.getS1AgainstS1();
		payoffMatrix[1][0] = w.getS2AgainstS1();
		payoffMatrix[0][1] = w.getS1AgainstS2();
		payoffMatrix[1][1] = w.getS2AgainstS2();
		newStrategy = oldStrategy;
		nextStrategy = newStrategy;
		neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
	}

	//=======

	public void computeBestReply() {
		
		neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
		
		EAgentGame A;
		int cumulatedPayoffS1 = 0, cumulatedPayoffS2 = 0;
		for (Iterator i = neighbours.iterator(); i.hasNext();) {
			A = (EAgentGame) i.next();
			if (A.newStrategy) {
				cumulatedPayoffS1 += payoffMatrix[0][0];
				cumulatedPayoffS2 += payoffMatrix[1][0];
			} else {
				cumulatedPayoffS1 += payoffMatrix[0][1];
				cumulatedPayoffS2 += payoffMatrix[1][1];
			}
		}
		nextStrategy = false;
		if (cumulatedPayoffS1 > cumulatedPayoffS2) {
			nextStrategy = true;
			//cumulatedPayoff = cumulatedPayoffS1
		}

		if (cumulatedPayoffS1 == cumulatedPayoffS2) {
			nextStrategy = newStrategy; // inertie
			//  if (random.getDouble() < 0.5 ) nextStrategy = true ;
		}
	}

	public void ComputeBestPayoff(int payoff) {
		
		//neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
		
		int payoffMax = payoff;
		EAgentGame dpa;

		for (Iterator i = neighbours.iterator(); i.hasNext();) {
			dpa = (EAgentGame) i.next();
			if (payoffMax < dpa.payoff) {
				nextStrategy = dpa.oldStrategy;
				//on copie la strategie du meilleur voisin
				payoffMax = dpa.payoff;
			}
		}
		newStrategy = nextStrategy;
	}

	public void ComputeBestAveragePayoff(int payoff) {
		
		//neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
		
		EAgentGame dpa;
		int n1 = 0;
		int n2 = 0;
		int payoff1 = 0;
		int payoff2 = 0;
		double averagePayoff1;
		double averagePayoff2;
		//System.out.println("ComputeBestAveragePayoff()");

		for (Iterator i = neighbours.iterator(); i.hasNext();) {
			dpa = (EAgentGame) i.next();
			if (dpa.oldStrategy) {
				n1++;
				payoff1 = payoff1 + dpa.payoff;
			} else {
				n2++;
				payoff2 = payoff2 + dpa.payoff;
			}
		}
		if (n1 == 0)
			averagePayoff1 = 0;
		else
			averagePayoff1 = payoff1 / n1;
		if (n2 == 0)
			averagePayoff2 = 0;
		else
			averagePayoff2 = payoff2 / n2;
		//System.out.println("averagePayoff1 = "+averagePayoff1+" averagePayoff2 = "+averagePayoff2);
		//on copie la strategie qui apporte le meilleur payoff moyen
		if (averagePayoff1 > averagePayoff2)
			nextStrategy = true;
		if (averagePayoff2 > averagePayoff1)
			nextStrategy = false;
		if (averagePayoff1 == averagePayoff2)
			nextStrategy = oldStrategy;
		newStrategy = nextStrategy;
		//finalAveragePayoff1 = averagePayoff1;
		//finalAveragePayoff2 = averagePayoff2;
	}

	//===========================================
	public Boolean hasChanged() {
		boolean temp;
		temp = hasChanged;
		hasChanged = false;
		return new Boolean(temp);
	}

	public Object getState() {
		return new Boolean(newStrategy);
	}
	/*
	   public String toString() {
	      String s;
	      s = (new Boolean(newStrategy)).toString() + " g = " + (new Integer(gain)).toString();
	      return s ;
	   }
	*/

	public void setNewStrategy(boolean b) {
		newStrategy = b;
		System.out.println("gant : " + agentID + " inverseState()");
	}

	public void setOldStrategy(boolean b) {
		oldStrategy = b;
	}
	
	public boolean getNewStrategy() {
		return newStrategy;
	}

	public boolean getOldStrategy() {
		return oldStrategy;
	}
}
